/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.opengauss.hostagent.action;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.database.sdk.model.ClusterInstance;
import com.huawei.ism.drm.host.agent.action.RemoteShellAction;
import com.huawei.ism.drm.host.agent.action.Stdin;
import com.huawei.ism.drm.opengauss.hostagent.action.OpenGaussActionApi;
import com.huawei.ism.drm.opengauss.hostagent.action.OpenGaussParam;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;

public class AgentlessOpenGaussActionApi
extends RemoteShellAction
implements OpenGaussActionApi {
    private static final Log LOGGER = LogFactory.getInstance(AgentlessOpenGaussActionApi.class);
    private static final String KEY_CLUSTER_USER = "--cluster_user";
    private static final String KEY_PROTOCOL_TYPE = "--protocol_type";
    private static final String KEY_DSS_SHARED_NUM = "--dss_shared_num";
    private static final String KEY_DSS_SHARED = "--dss_shared";
    private static final String KEY_DSS_PRIVATE_0 = "--dss_private_0";
    private static final String KEY_CM_VOTE = "--cm_vote";
    private static final String KEY_CM_SHARED = "--cm_shared";
    private static final String KEY_RUN_MODE = "--run_mode";
    private static final String KEY_BUILD_TYPE = "--build_type";

    public AgentlessOpenGaussActionApi(NeMgrProtocolExtend extend) {
        super(extend);
    }

    @Override
    public String queryClusters() {
        try {
            return this.execute("guard opengauss query_cluster", new Object[0]).get();
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Exec to query cluster info failed, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073948118L);
        }
    }

    @Override
    public String queryLunList(OpenGaussParam openGaussParam) {
        try {
            return this.execute("guard opengauss query_lun_info", new Object[]{KEY_CLUSTER_USER, openGaussParam.getClusterUser()}).get();
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() != -1L) {
                throw e;
            }
            LOGGER.error((Object)"Exec to query openGauss lun info failed, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073949729L);
        }
    }

    @Override
    public void startCluster(OpenGaussParam openGaussParam) {
        try {
            this.execute("guard opengauss start_cluster", new Object[]{KEY_CLUSTER_USER, openGaussParam.getClusterUser()}).get();
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() != -1L) {
                throw e;
            }
            LOGGER.error((Object)"Exec to start database failed, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073949731L);
        }
    }

    @Override
    public void stopCluster(OpenGaussParam openGaussParam) {
        try {
            this.execute("guard opengauss stop_cluster", new Object[]{KEY_CLUSTER_USER, openGaussParam.getClusterUser()}).get();
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() != -1L) {
                throw e;
            }
            LOGGER.error((Object)"Exec to stop database failed, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073949733L);
        }
    }

    @Override
    public void testConnection(OpenGaussParam openGaussParam) {
        String clusterStatus;
        try {
            ArrayList<String> testArgs = new ArrayList<String>();
            testArgs.add(KEY_CLUSTER_USER);
            testArgs.add(openGaussParam.getClusterUser());
            if (!VerifyUtil.isEmpty((String)openGaussParam.getClusterUserPwd())) {
                Stdin userPwd = Stdin.use((String)"user_pwd", (String)openGaussParam.getClusterUserPwd());
                testArgs.add((String)userPwd);
            }
            clusterStatus = this.execute("guard opengauss test_cluster", testArgs.toArray()).get();
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() != -1L) {
                throw e;
            }
            LOGGER.error((Object)"Exec to test database cluster failed, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073949732L);
        }
        if (!ClusterInstance.ClusterState.isClusterAvailable((String)clusterStatus)) {
            LOGGER.error((Object)"The database cluster of user(%s) is unavailable, cluster status is: %s.", new Object[]{openGaussParam.getClusterUser(), clusterStatus});
            throw new LegoCheckedException(1073948119L);
        }
    }

    @Override
    public String switchoverCluster(OpenGaussParam openGaussParam) {
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(KEY_CLUSTER_USER);
        paramList.add(openGaussParam.getClusterUser());
        paramList.add(KEY_RUN_MODE);
        paramList.add(openGaussParam.getClusterRunMode().getRunMode());
        try {
            return this.execute("guard opengauss switchover", paramList).get();
        }
        catch (LegoCheckedException ex) {
            if (ex.getErrorCode() != -1L) {
                throw ex;
            }
            LOGGER.error((Object)"Failed to switchover the openGauss cluster(name: %s), errorMsg: %s", new Object[]{openGaussParam.getClusterUser(), ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw new LegoCheckedException(1073949740L);
        }
    }

    @Override
    public void failoverCluster(OpenGaussParam openGaussParam) {
        try {
            this.execute("guard opengauss failover", new Object[]{KEY_CLUSTER_USER, openGaussParam.getClusterUser()}).get();
        }
        catch (LegoCheckedException ex) {
            LOGGER.error((Object)"Failed to failover the openGauss cluster(name: %s), errorMsg: %s", new Object[]{openGaussParam.getClusterUser(), ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw new LegoCheckedException(1073949740L);
        }
    }

    @Override
    public void queryRpo(OpenGaussParam openGaussParam) {
    }

    @Override
    public String buildCheck(OpenGaussParam openGaussParam) {
        try {
            return this.execute("guard opengauss build_check", new Object[]{KEY_CLUSTER_USER, openGaussParam.getClusterUser()}).get();
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Exec to build check failed, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073949734L);
        }
    }

    @Override
    public boolean execBuild(OpenGaussParam param) {
        try {
            ArrayList<String> bodyList = new ArrayList<String>();
            bodyList.add(KEY_CLUSTER_USER);
            bodyList.add(param.getClusterUser());
            bodyList.add(KEY_BUILD_TYPE);
            bodyList.add(param.getBuildType().getValue());
            String reqBody = String.join((CharSequence)" ", bodyList);
            LOGGER.info((Object)"The request body is: %s", new Object[]{reqBody});
            String buildResult = this.execute("guard opengauss exec_build", bodyList).get();
            LOGGER.info((Object)"The build result is: %s", new Object[]{buildResult});
            return "{\"buildSuccess\":true}".equals(buildResult);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Exec build failed, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073949735L);
        }
    }

    @Override
    public String queryNodeRole(OpenGaussParam openGaussParam) {
        try {
            String resultJsonStr = this.execute("guard opengauss query_active_node", new Object[]{KEY_CLUSTER_USER, openGaussParam.getClusterUser()}).get();
            JSONObject jsonObject = JSONObject.fromObject((Object)resultJsonStr);
            return jsonObject.getString("node_role");
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Query node role failed, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            return "Offline";
        }
    }

    @Override
    public void configLunInfo(OpenGaussParam param) {
        ArrayList<String> bodyList = new ArrayList<String>();
        bodyList.add(KEY_CLUSTER_USER);
        bodyList.add(param.getClusterUser());
        bodyList.add(KEY_PROTOCOL_TYPE);
        bodyList.add(param.getLunInfo().getProtocolType());
        bodyList.add(KEY_DSS_PRIVATE_0);
        bodyList.add(param.getLunInfo().getDssPrivate0WWN());
        bodyList.add(KEY_CM_VOTE);
        bodyList.add(param.getLunInfo().getCmVoteWWN());
        bodyList.add(KEY_CM_SHARED);
        bodyList.add(param.getLunInfo().getCmSharedWWN());
        bodyList.add(KEY_DSS_SHARED_NUM);
        bodyList.add(String.valueOf(param.getLunInfo().getDssSharedList().size()));
        bodyList.add(KEY_DSS_SHARED);
        param.getLunInfo().getDssSharedList().forEach(bodyList::add);
        String reqBody = String.join((CharSequence)" ", bodyList);
        LOGGER.info((Object)"The request body is: %s", new Object[]{reqBody});
        try {
            this.execute("guard opengauss restore_prepare", bodyList).get();
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Config lun info failed, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073949739L);
        }
    }

    @Override
    public void cleanForDrilling(OpenGaussParam param) {
        try {
            this.execute("guard opengauss clean", new Object[]{KEY_CLUSTER_USER, param.getClusterUser()}).get();
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Exec clean for drilling failed, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073949742L);
        }
    }

    @Override
    public String buildQuery(OpenGaussParam param) {
        try {
            return this.execute("guard opengauss build_query", new Object[]{KEY_CLUSTER_USER, param.getClusterUser()}).get();
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Exec build query failed, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073949503L);
        }
    }

    @Override
    public String queryNodeState(OpenGaussParam openGaussParam) {
        try {
            return this.execute("guard opengauss get_db_state", new Object[]{KEY_CLUSTER_USER, openGaussParam.getClusterUser()}).get();
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Exec query cluster state failed, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073949504L);
        }
    }

    @Override
    public String queryOneCluster(OpenGaussParam openGaussParam) {
        try {
            return this.execute("guard opengauss get_cluster_topo", new Object[]{KEY_CLUSTER_USER, openGaussParam.getClusterUser()}).get();
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Exec query cluster state failed, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073949505L);
        }
    }
}

