/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.opengauss.hostagent.action;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.database.opengauss.sdk.model.OpenGaussBuildState;
import com.huawei.ism.database.opengauss.sdk.model.OpenGaussCluster;
import com.huawei.ism.database.opengauss.sdk.model.OpenGaussLunInfo;
import com.huawei.ism.drm.app.util.JsonUtil;
import com.huawei.ism.drm.host.agent.action.AgentRestAction;
import com.huawei.ism.drm.opengauss.constant.OpenGaussEumDefine;
import com.huawei.ism.drm.opengauss.hostagent.action.OpenGaussActionApi;
import com.huawei.ism.drm.opengauss.hostagent.action.OpenGaussParam;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class OpenGaussAction
extends AgentRestAction {
    private static final String MAIN_STANDBY = "Main Standby";
    private static final String PRIMARY = "Primary";
    private static final String AGENTLESS_ERROR_CODE = "1";
    private final OpenGaussActionApi api;

    public OpenGaussAction(NeMgrProtocolExtend extend, String devSn) {
        super(extend, devSn);
        this.api = OpenGaussActionApi.create(extend);
    }

    public List<OpenGaussCluster> queryClusters() {
        String result = this.api.queryClusters();
        if (this.isResultEmpty(result)) {
            LOGGER.debug((Object)"Query openGauss cluster is null, IP:%s.", new Object[]{this.getExtend().getNetworkIpAddress()});
            return Collections.emptyList();
        }
        JSONObject resultObject = JSONObject.fromObject((Object)result);
        if (!resultObject.containsKey((Object)"clusters")) {
            LOGGER.info((Object)"Result object do not have 'cluster' property, IP:%s.", new Object[]{this.getExtend().getNetworkIpAddress()});
            return Collections.emptyList();
        }
        JSONArray jsonArray = resultObject.getJSONArray("clusters");
        ArrayList<OpenGaussCluster> clusters = new ArrayList<OpenGaussCluster>();
        for (Object jsonObject : jsonArray) {
            JSONObject cluster = JSONObject.fromObject(jsonObject);
            clusters.add(this.generateOpenGaussClusterByJson(cluster));
        }
        return clusters;
    }

    public boolean isPrimary(String clusterUser) {
        OpenGaussParam openGaussParam = new OpenGaussParam();
        openGaussParam.setClusterUser(clusterUser);
        String nodeRole = this.api.queryNodeRole(openGaussParam);
        return PRIMARY.equals(nodeRole);
    }

    public boolean isMainStandby(String clusterUser) {
        OpenGaussParam openGaussParam = new OpenGaussParam();
        openGaussParam.setClusterUser(clusterUser);
        String nodeRole = this.api.queryNodeRole(openGaussParam);
        return MAIN_STANDBY.equals(nodeRole);
    }

    public JSONObject queryLunList(String clusterUser) {
        this.checkUser(clusterUser);
        OpenGaussParam openGaussParam = new OpenGaussParam();
        openGaussParam.setClusterUser(clusterUser);
        String lunListInfo = this.api.queryLunList(openGaussParam);
        if (VerifyUtil.isEmpty((String)lunListInfo)) {
            LOGGER.error((Object)"The lun info of cluster user(%s) is null.", new Object[]{clusterUser});
            throw new LegoCheckedException(1073949729L);
        }
        return JSONObject.fromObject((Object)lunListInfo);
    }

    public void testConnection(String clusterUser, String userPwd) {
        this.checkUser(clusterUser);
        VerifyUtil.checkObject((Object)userPwd);
        OpenGaussParam openGaussParam = new OpenGaussParam();
        openGaussParam.setClusterUser(clusterUser);
        openGaussParam.setClusterUserPwd(userPwd);
        this.api.testConnection(openGaussParam);
    }

    public void testConnection(String clusterUser) {
        this.checkUser(clusterUser);
        OpenGaussParam openGaussParam = new OpenGaussParam();
        openGaussParam.setClusterUser(clusterUser);
        this.api.testConnection(openGaussParam);
    }

    public void startCluster(String clusterUser) {
        this.checkUser(clusterUser);
        OpenGaussParam openGaussParam = new OpenGaussParam();
        openGaussParam.setClusterUser(clusterUser);
        this.api.startCluster(openGaussParam);
    }

    public void stopCluster(String clusterUser) {
        this.checkUser(clusterUser);
        OpenGaussParam openGaussParam = new OpenGaussParam();
        openGaussParam.setClusterUser(clusterUser);
        this.api.stopCluster(openGaussParam);
    }

    public void switchoverCluster(String cluster, OpenGaussEumDefine.ClusterRunMode runMode) {
        if (VerifyUtil.isEmpty((String)cluster) || VerifyUtil.isEmpty((Object)((Object)runMode))) {
            LOGGER.error((Object)"Param error, cluster or runMode is null.");
            throw new LegoCheckedException(1073947393L);
        }
        OpenGaussParam openGaussParam = new OpenGaussParam();
        openGaussParam.setClusterUser(cluster);
        openGaussParam.setClusterRunMode(runMode);
        String switchoverResult = this.api.switchoverCluster(openGaussParam);
        JSONObject jsonObject = JSONObject.fromObject((Object)switchoverResult);
        boolean isSuccess = jsonObject.getBoolean("switchSuccess", Boolean.FALSE.booleanValue());
        if (!isSuccess) {
            LOGGER.error((Object)"Failed to switchover the openGauss cluster(name: %s).", new Object[]{cluster});
            throw new LegoCheckedException(1073949740L);
        }
    }

    public void failoverCluster(String cluster) {
        if (VerifyUtil.isEmpty((String)cluster)) {
            LOGGER.error((Object)"Param error, cluster or runMode is null.");
            throw new LegoCheckedException(1073947393L);
        }
        OpenGaussParam openGaussParam = new OpenGaussParam();
        openGaussParam.setClusterUser(cluster);
        this.api.failoverCluster(openGaussParam);
    }

    private OpenGaussCluster generateOpenGaussClusterByJson(JSONObject cluster) {
        String clusterName = JsonUtil.getString((JSONObject)cluster, (String)"clusterName", (String[])new String[]{""});
        String clusterUser = JsonUtil.getString((JSONObject)cluster, (String)"clusterUser", (String[])new String[]{""});
        String productName = JsonUtil.getString((JSONObject)cluster, (String)"productName", (String[])new String[]{""});
        String version = JsonUtil.getString((JSONObject)cluster, (String)"version", (String[])new String[]{""});
        String dataDir = JsonUtil.getString((JSONObject)cluster, (String)"dataDir", (String[])new String[]{""});
        String appPath = JsonUtil.getString((JSONObject)cluster, (String)"appPath", (String[])new String[]{""});
        String sepEnvPath = JsonUtil.getString((JSONObject)cluster, (String)"sepEnvPath", (String[])new String[]{""});
        String state = JsonUtil.getString((JSONObject)cluster, (String)"clusterState", (String[])new String[]{"0"});
        OpenGaussCluster openGaussCluster = new OpenGaussCluster();
        openGaussCluster.setClusterName(clusterName);
        openGaussCluster.setName(clusterName);
        openGaussCluster.setClusterUser(clusterUser);
        openGaussCluster.setProductName(productName);
        openGaussCluster.setVersion(version);
        openGaussCluster.setDataDir(dataDir);
        openGaussCluster.setAppPath(appPath);
        openGaussCluster.setSepEnvPath(sepEnvPath);
        openGaussCluster.setClusterState(state);
        String installMode = JsonUtil.getString((JSONObject)cluster, (String)"installStatus", (String[])new String[]{"0"});
        openGaussCluster.setInstallStatus(Integer.parseInt(installMode));
        boolean isCDB = JsonUtil.getBoolean((JSONObject)cluster, (String)"isCDB", (Boolean[])new Boolean[]{false});
        openGaussCluster.setIsCDB(isCDB);
        String nodeName = JsonUtil.getString((JSONObject)cluster, (String)"nodeName", (String[])new String[]{""});
        JSONArray nodeConfig = JsonUtil.getJSONArray((JSONObject)cluster, (String)"nodes") == null ? new JSONArray() : JsonUtil.getJSONArray((JSONObject)cluster, (String)"nodes");
        JSONArray remoteIpArr = JsonUtil.getJSONArray((JSONObject)cluster, (String)"remoteIp");
        JSONArray localIpArr = JsonUtil.getJSONArray((JSONObject)cluster, (String)"localIp");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("nodeName", nodeName);
        props.put("nodeConfig", nodeConfig.toString());
        props.put("remoteIp", remoteIpArr == null ? "[]" : remoteIpArr.toString());
        props.put("localIp", localIpArr == null ? "[]" : localIpArr.toString());
        openGaussCluster.setProps(props);
        String uuid = String.join((CharSequence)":", this.getDevSn(), clusterUser, this.getSuffix(appPath));
        openGaussCluster.setUuid(uuid);
        String nodeRole = JsonUtil.getString((JSONObject)cluster, (String)"nodeRole", (String[])new String[]{""});
        openGaussCluster.setIsPrimary(PRIMARY.equals(nodeRole));
        openGaussCluster.setClusterType(19);
        openGaussCluster.setHostSN(this.getDevSn());
        return openGaussCluster;
    }

    private String getSuffix(String appPath) {
        if (VerifyUtil.isEmpty((String)appPath)) {
            LOGGER.info((Object)"AppPath is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        String[] dirs = appPath.split("/");
        return dirs[dirs.length - 1];
    }

    private void checkUser(String clusterUser) {
        if (VerifyUtil.isEmpty((String)clusterUser)) {
            LOGGER.error((Object)"Cluster user is null");
            throw new LegoCheckedException(1073947393L);
        }
    }

    public String buildCheck(String clusterUser) {
        this.checkUser(clusterUser);
        OpenGaussParam openGaussParam = new OpenGaussParam();
        openGaussParam.setClusterUser(clusterUser);
        JSONObject jsonObject = JSONObject.fromObject((Object)this.api.buildCheck(openGaussParam));
        return jsonObject.getString("buildType", OpenGaussEumDefine.BuildType.NEEDLESS_BUILD.getValue());
    }

    public boolean execBuild(String clusterUser, OpenGaussEumDefine.BuildType buildType) {
        this.checkUser(clusterUser);
        OpenGaussParam openGaussParam = new OpenGaussParam();
        openGaussParam.setClusterUser(clusterUser);
        openGaussParam.setBuildType(buildType);
        return this.api.execBuild(openGaussParam);
    }

    public void configLunInfo(String clusterUser, OpenGaussLunInfo lunInfo) {
        this.checkUser(clusterUser);
        OpenGaussParam openGaussParam = new OpenGaussParam();
        openGaussParam.setClusterUser(clusterUser);
        openGaussParam.setLunInfo(lunInfo);
        this.api.configLunInfo(openGaussParam);
    }

    public void cleanForDrilling(String clusterUser) {
        this.checkUser(clusterUser);
        OpenGaussParam openGaussParam = new OpenGaussParam();
        openGaussParam.setClusterUser(clusterUser);
        this.api.cleanForDrilling(openGaussParam);
    }

    public OpenGaussBuildState buildQuery(String clusterUser) {
        this.checkUser(clusterUser);
        OpenGaussParam openGaussParam = new OpenGaussParam();
        openGaussParam.setClusterUser(clusterUser);
        String queryResult = this.api.buildQuery(openGaussParam);
        if (VerifyUtil.isEmpty((String)queryResult) || AGENTLESS_ERROR_CODE.equals(queryResult)) {
            throw new LegoCheckedException(1073949503L);
        }
        JSONObject object = JSONObject.fromObject((Object)queryResult);
        OpenGaussBuildState buildState = new OpenGaussBuildState();
        buildState.setDbState(JsonUtil.getString((JSONObject)object, (String)"dbState", (String[])new String[]{"-"}));
        buildState.setBuildMode(JsonUtil.getString((JSONObject)object, (String)"buildMode", (String[])new String[]{"-"}));
        buildState.setDataSynchronized(JsonUtil.getString((JSONObject)object, (String)"dataSynchronized", (String[])new String[]{"0.00kB"}));
        buildState.setEstimatedTotalData(JsonUtil.getString((JSONObject)object, (String)"estimatedTotalData", (String[])new String[]{"0.00kB"}));
        buildState.setProcessSchedule(JsonUtil.getString((JSONObject)object, (String)"processSchedule", (String[])new String[]{"0%"}));
        buildState.setEstimatedRemainTime(JsonUtil.getString((JSONObject)object, (String)"estimatedRemainTime", (String[])new String[]{"--:--:--"}));
        return buildState;
    }

    public OpenGaussEumDefine.ClusterNodeState queryClusterNodeState(String clusterUser) {
        this.checkUser(clusterUser);
        OpenGaussParam openGaussParam = new OpenGaussParam();
        openGaussParam.setClusterUser(clusterUser);
        String nodeStateJson = "";
        try {
            nodeStateJson = this.api.queryNodeState(openGaussParam);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Get cluster node state failed, error msg:%s", new Object[]{e.getMessage()});
            return OpenGaussEumDefine.ClusterNodeState.OTHER;
        }
        if (VerifyUtil.isEmpty((String)nodeStateJson) || AGENTLESS_ERROR_CODE.equals(nodeStateJson)) {
            return OpenGaussEumDefine.ClusterNodeState.OTHER;
        }
        JSONObject object = JSONObject.fromObject((Object)nodeStateJson);
        return OpenGaussEumDefine.ClusterNodeState.getByType(object.getString("dbState"));
    }

    public OpenGaussCluster queryOneCluster(String clusterUser) {
        this.checkUser(clusterUser);
        OpenGaussParam openGaussParam = new OpenGaussParam();
        openGaussParam.setClusterUser(clusterUser);
        String clusterJson = this.api.queryOneCluster(openGaussParam);
        if (VerifyUtil.isEmpty((String)clusterJson) || AGENTLESS_ERROR_CODE.equals(clusterJson)) {
            throw new LegoCheckedException(1073949505L);
        }
        JSONObject object = JSONObject.fromObject((Object)clusterJson);
        String clusterName = JsonUtil.getString((JSONObject)object, (String)"clusterName", (String[])new String[]{""});
        String state = JsonUtil.getString((JSONObject)object, (String)"clusterState", (String[])new String[]{"0"});
        OpenGaussCluster cluster = new OpenGaussCluster();
        cluster.setClusterUser(clusterUser);
        cluster.setClusterName(clusterName);
        cluster.setClusterState(state);
        return cluster;
    }
}

