/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.opengauss.recovery.process;

import com.huawei.ism.database.opengauss.sdk.model.OpenGaussLunInfo;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.opengauss.hostagent.action.OpenGaussAction;
import com.huawei.ism.drm.opengauss.recovery.process.OpenGaussBaseProcessor;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConfigOpenGaussProcessor
extends OpenGaussBaseProcessor {
    private static final Log LOGGER = LogFactory.getInstance(ConfigOpenGaussProcessor.class);
    private static final long serialVersionUID = 2801500054424344421L;
    private final String keyCmShared = "_cm_shared";
    private final String keyCmVote = "_cm_vote";
    private final String keyDssPrivate0 = "_dss_private_0";
    private final String keyDssShared = "_dss_shared";

    protected boolean execute(RecoveryProcessorContext context) {
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        LOGGER.debug((Object)"Begin execute config openGauss processor.");
        try {
            String clusterUser = (String)context.getAttribute("clusterUser", String.class);
            List actions = context.getObjects("primaryActionList", OpenGaussAction.class);
            if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue()) {
                Map snapshotMap = (Map)context.getAttribute("CreateSnapshotSubProcessors", Map.class);
                if (VerifyUtil.isEmpty((Map)snapshotMap)) {
                    LOGGER.error((Object)"Get snapshot map from context failed.");
                    this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                    return false;
                }
                OpenGaussLunInfo lunInfo = this.getOpenGaussLunInfo(context, snapshotMap);
                for (OpenGaussAction action : actions) {
                    LOGGER.info((Object)"Begin config openGauss lun info.");
                    action.configLunInfo(clusterUser, lunInfo);
                }
            } else {
                LOGGER.info((Object)"Begin clean lun info for openGauss drilling.");
                String processName = "com.huawei.ism.drm.opengauss.recovery.process.ConfigOpenGaussCleanProcessor";
                this.setProcName(processName);
                for (OpenGaussAction action : actions) {
                    action.cleanForDrilling(clusterUser);
                }
            }
            LOGGER.info((Object)"Success to to config openGauss processors.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Failed to execute config openGauss processors. errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("lego.err." + e.getErrorCode(), new String[0]);
            return false;
        }
    }

    private OpenGaussLunInfo getOpenGaussLunInfo(RecoveryProcessorContext context, Map<String, String> snapshotMap) {
        OpenGaussLunInfo lunInfo = new OpenGaussLunInfo();
        Set<Map.Entry<String, String>> entrySet = snapshotMap.entrySet();
        ProtectObject protectObject = this.getProtectObject(context);
        for (Map.Entry<String, String> entry : entrySet) {
            String lunId = entry.getKey().split("LunID=")[1];
            String diskName = this.getDiskNameById(lunId, protectObject);
            String protocolType = this.getProtocalType(lunId, protectObject);
            String snapshotWWN = DrmEnumDefine.InitiatorType.NVME_OVER_ROCE.getName().equals(protocolType) ? entry.getValue().split(";")[4] : entry.getValue().split(";")[2];
            this.updateLunInfo(lunInfo, snapshotWWN, diskName, protocolType);
        }
        return lunInfo;
    }

    private void updateLunInfo(OpenGaussLunInfo lunInfo, String snapshotWWN, String diskName, String protocolType) {
        lunInfo.setProtocolType(protocolType);
        if (diskName.contains("_dss_shared")) {
            LinkedList<String> dssSharedList = lunInfo.getDssSharedList();
            if (VerifyUtil.isEmpty((Collection)dssSharedList)) {
                dssSharedList = new LinkedList<String>();
            }
            if (diskName.substring(diskName.lastIndexOf("/") + 1).equals("_dss_shared")) {
                dssSharedList.addLast(snapshotWWN);
            } else {
                dssSharedList.addFirst(snapshotWWN);
            }
            lunInfo.setDssSharedList(dssSharedList);
        }
        if (diskName.contains("_cm_shared")) {
            lunInfo.setCmSharedWWN(snapshotWWN);
        }
        if (diskName.contains("_cm_vote")) {
            lunInfo.setCmVoteWWN(snapshotWWN);
        }
        if (diskName.contains("_dss_private_0")) {
            lunInfo.setDssPrivate0WWN(snapshotWWN);
        }
    }

    private String getDiskNameById(String lunId, ProtectObject po) {
        for (ProtectObjectStorageInfo lun : po.getUsedStorageResourceSet()) {
            if (!lun.getResourceId().equals(lunId)) continue;
            return lun.getDeviceName();
        }
        LOGGER.error((Object)"Get disk name by id failed, lun id: %s.", new Object[]{lunId});
        throw new LegoCheckedException(201L);
    }

    private String getProtocalType(String lunId, ProtectObject po) {
        for (ProtectObjectStorageInfo lun : po.getUsedStorageResourceSet()) {
            if (!lun.getResourceId().equals(lunId)) continue;
            return lun.getAlias().split(":")[0];
        }
        LOGGER.error((Object)"Get protocol type by id failed, lun id: %s.", new Object[]{lunId});
        throw new LegoCheckedException(201L);
    }
}

