/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.opengauss.recovery.process;

import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.host.util.DBRecoveryTools;
import com.huawei.ism.drm.opengauss.hostagent.action.OpenGaussAction;
import com.huawei.ism.drm.opengauss.recovery.process.OpenGaussFullBuildingProcessor;
import com.huawei.ism.drm.opengauss.util.OpenGaussUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public abstract class OpenGaussBaseProcessor
extends BaseRecoveryProcessor {
    public static final String CLUSTER_USER_KEY = "clusterUser";
    public static final String PRIMARY_ACTION = "primaryAction";
    public static final String MAIN_STANDBY_ACTION = "mainStandbyAction";
    public static final String PRIMARY_ACTION_LIST = "primaryActionList";
    public static final String STANDBY_ACTION_LIST = "StandbyActionList";
    public static final String HOST_SN_SPLIT_CHAR = ",";
    private static final Log LOGGER = LogFactory.getInstance(OpenGaussFullBuildingProcessor.class);

    protected void stopPrimaryCluster(RecoveryProcessorContext context) {
        this.initPrimaryActions(context);
        OpenGaussAction action = (OpenGaussAction)((Object)context.getAttribute(PRIMARY_ACTION, OpenGaussAction.class));
        if (VerifyUtil.isEmpty((Object)((Object)action))) {
            LOGGER.error((Object)"Init primary action error.");
            throw new LegoCheckedException(1073948119L);
        }
        String clusterUser = (String)context.getAttribute(CLUSTER_USER_KEY, String.class);
        action.stopCluster(clusterUser);
    }

    protected void stopStandbyCluster(RecoveryProcessorContext context) {
        this.initStandbyActions(context);
        OpenGaussAction action = this.getMainStandbyAction(context);
        context.setAttribute(MAIN_STANDBY_ACTION, (Object)action);
        String clusterUser = (String)context.getAttribute(CLUSTER_USER_KEY, String.class);
        action.stopCluster(clusterUser);
    }

    private OpenGaussAction getMainStandbyAction(RecoveryProcessorContext context) {
        OpenGaussAction action = (OpenGaussAction)((Object)context.getAttribute(MAIN_STANDBY_ACTION, OpenGaussAction.class));
        if (!VerifyUtil.isEmpty((Object)((Object)action))) {
            return action;
        }
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() != this.getProcType()) {
            LOGGER.error((Object)"Init standby action error.");
            throw new LegoCheckedException(2117645L);
        }
        List disasterActionList = context.getObjects(STANDBY_ACTION_LIST, OpenGaussAction.class);
        String clusterUser = (String)context.getAttribute(CLUSTER_USER_KEY, String.class);
        return disasterActionList.stream().filter(perAction -> perAction.isPrimary(clusterUser)).findFirst().orElseThrow(() -> {
            LOGGER.info((Object)"Failed to query the primary node of the original primary cluster, cluster user: %s.", new Object[]{clusterUser});
            return new LegoCheckedException(2117645L);
        });
    }

    protected ProtectObject getProtectObject(RecoveryProcessorContext context) {
        ProtectGroup protectGroup = context.getProtectGroup();
        Set protectObjectSet = Optional.ofNullable(protectGroup).map(ProtectGroup::getPolist).orElse(Collections.emptySet());
        return (ProtectObject)protectObjectSet.stream().findFirst().orElseThrow(() -> new LegoCheckedException(1073947393L));
    }

    private void initPrimaryActions(RecoveryProcessorContext context) {
        LOGGER.info((Object)"Begin init primary actions.");
        Set keySet = context.getAttributeKeys();
        if (keySet.contains(PRIMARY_ACTION) && keySet.contains(PRIMARY_ACTION_LIST)) {
            LOGGER.info((Object)"PRIMARY_ACTION and PRIMARY_ACTION_LIST has been contained.");
            return;
        }
        this.initActions(context, PRIMARY_ACTION, PRIMARY_ACTION_LIST);
    }

    protected void initStandbyActions(RecoveryProcessorContext context) {
        LOGGER.info((Object)"Begin init standby actions.");
        Set keySet = context.getAttributeKeys();
        if (keySet.contains(MAIN_STANDBY_ACTION) && keySet.contains(STANDBY_ACTION_LIST)) {
            LOGGER.info((Object)"MAIN_STANDBY_ACTION and STANDBY_ACTION_LIST has been contained.");
            return;
        }
        this.initActions(context, MAIN_STANDBY_ACTION, STANDBY_ACTION_LIST);
    }

    private void initActions(RecoveryProcessorContext context, String actionKey, String actionListKey) {
        LOGGER.info((Object)"Begin init openGauss attributes, actionKey: %s, actionListKey: %s.", new Object[]{actionKey, actionListKey});
        ProtectObject protectObject = this.getProtectObject(context);
        String clusterUser = OpenGaussUtil.getClusterUser(protectObject);
        boolean isPrimary = PRIMARY_ACTION.equals(actionKey);
        boolean isReProtecting = this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue();
        Set<String> hostSnList = isPrimary == isReProtecting ? OpenGaussUtil.getDisasterHost(protectObject) : OpenGaussUtil.getPrimaryHostSns(protectObject);
        ArrayList<OpenGaussAction> actions = new ArrayList<OpenGaussAction>();
        INeMgrProtocolExtendService extendService = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
        for (String devSn : hostSnList) {
            LOGGER.info((Object)"HostSn: %s.", new Object[]{devSn});
            OpenGaussAction action = new OpenGaussAction(extendService.findBySn(devSn), devSn);
            if (isPrimary ? action.isPrimary(clusterUser) : action.isMainStandby(clusterUser)) {
                LOGGER.info((Object)"Begin set attribute, key: %s, value: %s.", new Object[]{actionKey, String.valueOf((Object)action)});
                context.setAttribute(actionKey, (Object)action);
            }
            if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() || this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue()) {
                LOGGER.info((Object)"Begin set attribute, key: %s, value: %s.", new Object[]{actionKey, String.valueOf((Object)action)});
                context.setAttribute(actionKey, (Object)action);
            }
            LOGGER.info((Object)"Begin add action to list, action: %s.", new Object[]{String.valueOf((Object)action)});
            actions.add(action);
        }
        if (VerifyUtil.isEmpty((Object)context.getAttribute(actionKey, OpenGaussAction.class))) {
            LOGGER.warn((Object)"The node role is not primary or main standby, get the first element of actions as default value.");
            context.setAttribute(actionKey, actions.get(0));
        }
        context.setAttribute(CLUSTER_USER_KEY, (Object)clusterUser);
        context.setAttribute(actionListKey, actions);
    }

    protected void updateProtectObjectPrimaryHostSn(ProtectObject protectObject) {
        String pgId = protectObject.getProtectGroup().getUuid();
        String disasterHostSn = DBRecoveryTools.getDisasterHostSn((RecoveryPlan)this.getContextRef().getRecoveryPlan(), (String)pgId, (int)this.getProcType());
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        DrResource drResource = recoveryService.getDrResourceByID(disasterHostSn);
        DrHostGroup drHostGroup = new DrHostGroup();
        if (drResource instanceof DrHostGroup) {
            drHostGroup = (DrHostGroup)drResource;
        }
        Set childResources = drHostGroup.getChildResources();
        JSONArray testHostSnArr = new JSONArray();
        childResources.forEach(resource -> testHostSnArr.add((Object)resource.getDeviceSn()));
        String nodeConfig = (String)protectObject.getProps().get("nodeConfig");
        JSONObject jsonObject = JSONObject.fromObject((Object)nodeConfig);
        jsonObject.put((Object)"PRIMARY", (Object)testHostSnArr);
        protectObject.getProps().put("nodeConfig", jsonObject.toString());
        LOGGER.info((Object)"Update project nodeConfig, new nodes: %s.", new Object[]{jsonObject.toString()});
    }
}

