/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.opengauss.recovery.process;

import com.huawei.ism.database.opengauss.sdk.model.OpenGaussBuildState;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.opengauss.constant.OpenGaussEumDefine;
import com.huawei.ism.drm.opengauss.hostagent.action.OpenGaussAction;
import com.huawei.ism.drm.opengauss.hostagent.action.OpenGaussBuildingTask;
import com.huawei.ism.drm.opengauss.recovery.process.OpenGaussBaseProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoConfig;

public class OpenGaussFullBuildingProcessor
extends OpenGaussBaseProcessor {
    private static final long serialVersionUID = -1328597216586378566L;
    private static final Log LOGGER = LogFactory.getInstance(OpenGaussFullBuildingProcessor.class);
    private static final long BUILD_QUERY_INTERVAL = 60000L;
    private static final long BUILD_QUERY_TIMEOUT = 3600000L;
    private static final int BUILD_FAILED_NUM = 3;
    private OpenGaussAction action;
    private String clusterUser;

    protected boolean execute(RecoveryProcessorContext context) {
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        LOGGER.debug((Object)"Begin to execute full building.");
        this.clusterUser = (String)context.getAttribute("clusterUser", String.class);
        this.action = (OpenGaussAction)((Object)context.getAttribute("mainStandbyAction", OpenGaussAction.class));
        try {
            OpenGaussBuildState buildState = this.action.buildQuery(this.clusterUser);
            if (!OpenGaussEumDefine.ReBuildState.BUILDING.getValue().equalsIgnoreCase(buildState.getDbState())) {
                String buildType = this.action.buildCheck(this.clusterUser);
                if (OpenGaussEumDefine.BuildType.NEEDLESS_BUILD.getValue().equalsIgnoreCase(buildType)) {
                    LOGGER.info((Object)"Build type is NEEDLESS_BUILD, no need execute.");
                    return this.success("com.huawei.ism.drm.opengauss.recovery.process.OpenGaussFullBuildingProcessor.info", null);
                }
                ExecutionService.submit((Runnable)new OpenGaussBuildingTask(this.action, this.clusterUser, buildType));
            }
            return this.buildQuery(context);
        }
        catch (LegoCheckedException ex) {
            this.processFail(context, ex);
            return false;
        }
    }

    private boolean buildQuery(RecoveryProcessorContext context) {
        long startTime = System.currentTimeMillis();
        long timeout = LegoConfig.getInstance().getNumber("opengauss.building.timeout", 3600000L);
        int currentFailedNum = 0;
        do {
            CommUtil.pauseThread((long)60000L);
            OpenGaussBuildState buildState = this.action.buildQuery(this.clusterUser);
            this.updateProcessDetail("com.huawei.ism.drm.opengauss.recovery.process.building.process.info", new String[]{buildState.getEstimatedTotalData(), buildState.getDataSynchronized(), buildState.getProcessSchedule(), buildState.getEstimatedRemainTime()});
            ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
            String dbState = buildState.getDbState();
            if (OpenGaussEumDefine.ReBuildState.BUILD_COMPLETED.getValue().equalsIgnoreCase(dbState)) {
                LOGGER.debug((Object)"Execute full building successful.");
                return this.success();
            }
            if (OpenGaussEumDefine.ReBuildState.BUILD_FAILED.getValue().equalsIgnoreCase(dbState)) {
                LOGGER.warn((Object)"Build query, the current failed num is: %s.", new Object[]{String.valueOf(++currentFailedNum)});
            }
            if (currentFailedNum != 3) continue;
            LOGGER.error((Object)"Execute build failed, the accumulated failure times is %s.", new Object[]{String.valueOf(currentFailedNum)});
            this.processFail(context, new LegoCheckedException(1073949735L));
            return false;
        } while (System.currentTimeMillis() - startTime <= timeout);
        LOGGER.error((Object)"Execute full building timout.");
        return this.failure("com.huawei.ism.drm.opengauss.recovery.process.OpenGaussFullBuildingProcessor.error", null);
    }

    private void processFail(RecoveryProcessorContext context, LegoCheckedException ex) {
        LOGGER.error((Object)"Failed to execute full building, cluster user: %s, err msg: %s.", new Object[]{context.getAttribute("clusterUser", String.class), ExceptionUtil.getErrorMessage((Throwable)ex)});
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        long errorCode = ex.getErrorCode() == -1L ? 1073949735L : ex.getErrorCode();
        this.updateProcessDetail("lego.err." + errorCode, null);
    }
}

