/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.opengauss.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryLog;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.opengauss.constant.OpenGaussEumDefine;
import com.huawei.ism.drm.opengauss.hostagent.action.OpenGaussAction;
import com.huawei.ism.drm.opengauss.recovery.process.OpenGaussSwitchoverProcessor;
import com.huawei.ism.drm.opengauss.recovery.process.OpenGaussSwitchoverSubProcessor;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OpenGaussReprotectSwitchoverProcessor
extends OpenGaussSwitchoverProcessor {
    private static final long serialVersionUID = -210445628034746364L;
    private static final Log LOGGER = LogFactory.getInstance(OpenGaussReprotectSwitchoverProcessor.class);

    @Override
    public boolean execute(RecoveryProcessorContext recoveryProcessorContext) {
        LOGGER.info((Object)"Begin execute switchover processor.");
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        try {
            this.switchOverCluster(recoveryProcessorContext);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Exec to switchover cluster failed, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return true;
    }

    @Override
    protected void switchOverCluster(RecoveryProcessorContext context) {
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == this.getProcType()) {
            super.switchOverCluster(context);
        }
    }

    @Override
    protected Set<RecoveryProcessor> updateSubProcessors(RecoveryProcessorContext context) {
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        List disasterActionList = context.getObjects("StandbyActionList", OpenGaussAction.class);
        String clusterUser = (String)context.getAttribute("clusterUser", String.class);
        for (OpenGaussAction action : disasterActionList) {
            OpenGaussSwitchoverSubProcessor subProcessor = this.createOpenGaussSwitchoverSubProcessor(action, clusterUser, OpenGaussEumDefine.ClusterRunMode.CLUSTER_STANDBY);
            subProcessors.add((RecoveryProcessor)subProcessor);
        }
        return subProcessors;
    }

    public void resetEnableStatus(ProtectGroup pg, DrmEnumDefine.RecoveryPlanExecuteTypeE procType) {
        IRecoveryPlanService planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        RecoveryLog log = planService.getLatestSuccessHistoryRecoveryLog(this.getPlanId(), Long.valueOf(new Date().getTime()));
        this.setIsEnabled(VerifyUtil.isEmpty((Object)log) || log.getLogType() != DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue());
        this.setIsEditable(false);
    }
}

