/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.opengauss.recovery.process;

import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.database.opengauss.sdk.model.OpenGaussCluster;
import com.huawei.ism.database.sdk.model.ClusterInstance;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.opengauss.constant.OpenGaussEumDefine;
import com.huawei.ism.drm.opengauss.hostagent.action.OpenGaussAction;
import com.huawei.ism.drm.opengauss.recovery.process.OpenGaussBaseProcessor;
import com.huawei.ism.drm.opengauss.recovery.process.OpenGaussSwitchoverSubProcessor;
import com.huawei.ism.drm.opengauss.util.OpenGaussUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OpenGaussSwitchoverProcessor
extends OpenGaussBaseProcessor {
    private static final long serialVersionUID = -1863614973887630518L;
    private static final Log LOGGER = LogFactory.getInstance(OpenGaussSwitchoverProcessor.class);
    private String primaryHostSn;

    public String getPrimaryHostSn() {
        return this.primaryHostSn;
    }

    public void setPrimaryHostSn(String primaryHostSn) {
        this.primaryHostSn = primaryHostSn;
    }

    protected boolean execute(RecoveryProcessorContext context) {
        if (this.isAlreadySwitchover(context)) {
            LOGGER.info((Object)"Cluster already switchover.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            this.updateProcessDetail("com.huawei.ism.drm.opengauss.recovery.process.switchover.info", null);
            return true;
        }
        LOGGER.info((Object)"Begin to switchover cluster.");
        this.initStandbyActions(context);
        try {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            if (this.isPrimaryClusterStopped(context)) {
                LOGGER.info((Object)"Primary cluster has stopped, begin init attributes of primary.");
                this.initPrimaryAttributes(context);
            } else {
                this.stopPrimaryCluster(context);
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue());
                this.primaryHostSn = ((OpenGaussAction)((Object)context.getAttribute("primaryAction", OpenGaussAction.class))).getDevSn();
            }
            this.switchOverCluster(context);
            this.startupCluster(context);
        }
        catch (LegoCheckedException ex) {
            String clusterUser = (String)context.getAttribute("clusterUser", String.class);
            LOGGER.error((Object)"Failed to switchover cluster, cluster user: %s, err msg: %s.", new Object[]{clusterUser, ExceptionUtil.getErrorMessage((Throwable)ex)});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail(ex);
            ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
            return false;
        }
        LOGGER.info((Object)"Switchover cluster successfully.");
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return true;
    }

    private boolean isPrimaryClusterStopped(RecoveryProcessorContext context) {
        ProtectObject protectObject = this.getProtectObject(context);
        String clusterUser = OpenGaussUtil.getClusterUser(protectObject);
        Set<String> primaryHostSns = OpenGaussUtil.getPrimaryHostSns(protectObject);
        INeMgrProtocolExtendService extendService = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
        for (String hostSn : primaryHostSns) {
            OpenGaussAction action = new OpenGaussAction(extendService.findBySn(hostSn), hostSn);
            try {
                OpenGaussCluster openGaussCluster = action.queryOneCluster(clusterUser);
                return ClusterInstance.ClusterState.STOPPED.getDesc().equals(openGaussCluster.getClusterState());
            }
            catch (LegoCheckedException e) {
                LOGGER.error((Object)"Get cluster state failed, devSn:%s, error msg:%s", new Object[]{hostSn, e.getMessage()});
            }
        }
        return false;
    }

    protected boolean isAlreadySwitchover(RecoveryProcessorContext context) {
        ProtectGroup protectGroup = context.getProtectGroup();
        return OpenGaussUtil.isAlreadySwitchover(protectGroup, context, true) && OpenGaussUtil.isAlreadySwitchover(protectGroup, context, false);
    }

    protected void switchOverCluster(RecoveryProcessorContext context) {
        Set<RecoveryProcessor> subProcessors = this.updateSubProcessors(context);
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.setChildProc(subProcessors);
        } else {
            this.updateSubProcessors(subProcessors);
        }
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType());
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor(new ArrayList<RecoveryProcessor>(subProcessors), (DrmEnumDefine.RecoveryPlanExecuteTypeE)type);
        recoveryTemplate.process(context);
        if (!this.calcProcessResultBySubProc()) {
            String clusterUser = (String)context.getAttribute("clusterUser", String.class);
            LOGGER.error((Object)"Failed to switchover cluster, cluster user: %s", new Object[]{clusterUser});
            throw new LegoCheckedException(1073949740L);
        }
    }

    protected boolean calcProcessResultBySubProc() {
        DrmEnumDefine.RecoveryPlanExecuteResultE procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        if (procStatus == DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS) {
            LOGGER.info((Object)"Success to switchover all opengauss cluster.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        if (procStatus == DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS) {
            LOGGER.error((Object)"Failed to switchover all opengauss cluster, executing status: part success.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue());
            return false;
        }
        LOGGER.error((Object)"Failed to switchover opengauss cluster, executing status: failed.");
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        return false;
    }

    protected Set<RecoveryProcessor> updateSubProcessors(RecoveryProcessorContext context) {
        OpenGaussSwitchoverSubProcessor subProcessor;
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        String clusterUser = (String)context.getAttribute("clusterUser", String.class);
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == this.getProcType()) {
            List primaryActionList = context.getObjects("primaryActionList", OpenGaussAction.class);
            for (OpenGaussAction action : primaryActionList) {
                subProcessor = this.createOpenGaussSwitchoverSubProcessor(action, clusterUser, OpenGaussEumDefine.ClusterRunMode.CLUSTER_STANDBY);
                subProcessors.add((RecoveryProcessor)subProcessor);
            }
        }
        List disasterActionList = context.getObjects("StandbyActionList", OpenGaussAction.class);
        for (OpenGaussAction action : disasterActionList) {
            subProcessor = this.createOpenGaussSwitchoverSubProcessor(action, clusterUser, OpenGaussEumDefine.ClusterRunMode.CLUSTER_PRIMARY);
            subProcessors.add((RecoveryProcessor)subProcessor);
        }
        return subProcessors;
    }

    protected OpenGaussSwitchoverSubProcessor createOpenGaussSwitchoverSubProcessor(OpenGaussAction action, String clusterUser, OpenGaussEumDefine.ClusterRunMode runMode) {
        OpenGaussSwitchoverSubProcessor processor = new OpenGaussSwitchoverSubProcessor();
        processor.setProcName(processor.getName());
        processor.setProcType(this.getProcType());
        processor.setPlanId(this.getPlanId());
        processor.setProcessId(this.getProcessId());
        processor.setParentProc((RecoveryProcessor)this);
        processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        processor.setAction(action);
        processor.setClusterUser(clusterUser);
        processor.setRunMode(runMode);
        return processor;
    }

    private void startupCluster(RecoveryProcessorContext context) {
        String clusterUser = (String)context.getAttribute("clusterUser", String.class);
        try {
            OpenGaussAction primaryAction = (OpenGaussAction)((Object)context.getAttribute("mainStandbyAction", OpenGaussAction.class));
            if (VerifyUtil.isEmpty((Object)((Object)primaryAction))) {
                this.startupStandbyCluster(context);
            } else {
                primaryAction.failoverCluster(clusterUser);
            }
            OpenGaussAction mainStandbyAction = (OpenGaussAction)((Object)context.getAttribute("primaryAction", OpenGaussAction.class));
            mainStandbyAction.startCluster(clusterUser);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Start cluster failed.");
            throw new LegoCheckedException(1073949731L);
        }
    }

    private void startupStandbyCluster(RecoveryProcessorContext context) {
        List actions = context.getObjects("StandbyActionList", OpenGaussAction.class);
        String user = (String)context.getAttribute("clusterUser", String.class);
        for (OpenGaussAction action : actions) {
            try {
                action.startCluster(user);
                return;
            }
            catch (LegoCheckedException e) {
                LOGGER.error((Object)"Start cluster on host:%s failed.", new Object[]{action.getDevSn()});
            }
        }
        LOGGER.error((Object)"Start cluster failed.");
        throw new LegoCheckedException(1073949731L);
    }

    private void initPrimaryAttributes(RecoveryProcessorContext context) {
        if (VerifyUtil.isAnyEmpty((Object[])new Object[]{this.primaryHostSn})) {
            LOGGER.error((Object)"Reentrant error, param error.");
            throw new LegoCheckedException(2117645L);
        }
        INeMgrProtocolExtendService extendService = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
        OpenGaussAction action = new OpenGaussAction(extendService.findBySn(this.primaryHostSn), this.primaryHostSn);
        ProtectObject protectObject = this.getProtectObject(context);
        ArrayList actions = new ArrayList();
        Set<String> primaryHostSns = OpenGaussUtil.getPrimaryHostSns(protectObject);
        primaryHostSns.forEach(sn -> {
            OpenGaussAction primaryHostAction = new OpenGaussAction(extendService.findBySn(sn), (String)sn);
            actions.add(primaryHostAction);
        });
        context.setAttribute("primaryAction", (Object)action);
        context.setAttribute("primaryActionList", actions);
        LOGGER.info((Object)"Init primary attributes success, PRIMARY_ACTION: %s, PRIMARY_ACTION_LIST size: %s.", new Object[]{String.valueOf((Object)action), String.valueOf(actions.size())});
    }
}

