/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.opengauss.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.opengauss.constant.OpenGaussEumDefine;
import com.huawei.ism.drm.opengauss.hostagent.action.OpenGaussAction;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.List;

public class OpenGaussSwitchoverSubProcessor
extends BaseRecoveryProcessor {
    private static final Log LOGGER = LogFactory.getInstance(OpenGaussSwitchoverSubProcessor.class);
    private OpenGaussAction action;
    private String clusterUser;
    private OpenGaussEumDefine.ClusterRunMode runMode;

    protected boolean execute(RecoveryProcessorContext context) {
        if (VerifyUtil.isAnyEmpty((Object[])new Object[]{this.action, context, this.runMode})) {
            LOGGER.error((Object)"Illegal param, exists a null param.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("com.huawei.ism.drm.opengauss.recovery.process.OpenGaussSwitchoverSubProcessor.error", new String[0]);
            return false;
        }
        try {
            this.updateProcessNameParams(new String[]{this.getHostName(this.action.getDevSn())});
            this.action.switchoverCluster(this.clusterUser, this.runMode);
        }
        catch (LegoCheckedException ex) {
            LOGGER.error((Object)"Switchover cluster error, dev sn: %s, cluster name: %s.", new Object[]{this.action.getDevSn(), this.clusterUser});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail(ex);
            return true;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }

    private String getHostName(String hostSn) {
        List sNs = DrHostUtil.getDrHostBySNs((String[])new String[]{hostSn});
        if (VerifyUtil.isEmpty((Collection)sNs)) {
            LOGGER.error((Object)"Can not find host by sn:%s", new Object[]{hostSn});
            throw new LegoCheckedException(2117645L);
        }
        return ((DrHost)sNs.get(0)).getName();
    }

    public void setAction(OpenGaussAction action) {
        this.action = action;
    }

    public void setClusterUser(String clusterUser) {
        this.clusterUser = clusterUser;
    }

    public void setRunMode(OpenGaussEumDefine.ClusterRunMode runMode) {
        this.runMode = runMode;
    }

    public OpenGaussAction getAction() {
        return this.action;
    }

    public String getClusterUser() {
        return this.clusterUser;
    }

    public OpenGaussEumDefine.ClusterRunMode getRunMode() {
        return this.runMode;
    }
}

