/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.opengauss.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.opengauss.hostagent.action.OpenGaussAction;
import com.huawei.ism.drm.opengauss.recovery.process.OpenGaussBaseProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;

public class StartupOpenGaussProcessor
extends OpenGaussBaseProcessor {
    private static final Log LOGGER = LogFactory.getInstance(StartupOpenGaussProcessor.class);
    private static final long serialVersionUID = -3597243824470815574L;

    protected boolean execute(RecoveryProcessorContext context) {
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        LOGGER.debug((Object)"Begin execute startup openGauss processor.");
        String clusterUser = (String)context.getAttribute("clusterUser", String.class);
        OpenGaussAction action = DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == this.getProcType() ? (OpenGaussAction)((Object)context.getAttribute("mainStandbyAction", OpenGaussAction.class)) : (OpenGaussAction)((Object)context.getAttribute("primaryAction", OpenGaussAction.class));
        try {
            action.startCluster(clusterUser);
            LOGGER.info((Object)"Success to startup openGaussCluster, hostSn: %s, clusterUser: %s.", new Object[]{action.getDevSn(), clusterUser});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Failed to startup openGaussCluster, hostSn: %s, clusterUser: %s, errorMsg: %s", new Object[]{action.getDevSn(), clusterUser, ExceptionUtil.getErrorMessage((Throwable)e)});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073949731", new String[0]);
            return false;
        }
    }
}

