/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.opengauss.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.opengauss.hostagent.action.OpenGaussAction;
import com.huawei.ism.drm.opengauss.recovery.process.OpenGaussBaseProcessor;
import com.huawei.ism.drm.opengauss.recovery.process.TestOpenGaussAppSubProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class TestOpenGaussAppProcessor
extends OpenGaussBaseProcessor {
    private static final long serialVersionUID = -3597243824470815573L;
    private static final Log LOGGER = LogFactory.getInstance(TestOpenGaussAppProcessor.class);

    public boolean execute(RecoveryProcessorContext context) {
        LOGGER.info((Object)"Begin execute test open gauss processor.");
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        try {
            this.testConnection(context);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Exec to test cluster status failed, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("lego.err." + e.getErrorCode(), new String[0]);
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return true;
    }

    protected boolean calcProcessResultBySubProc() {
        DrmEnumDefine.RecoveryPlanExecuteResultE procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() != procStatus.getValue()) {
            LOGGER.error((Object)"Failed to switchover cluster, executing status: %s", new Object[]{DrmEnumDefine.RecoveryPlanExecuteResultE.getType((int)procStatus.getValue()).toString()});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        return true;
    }

    private void testConnection(RecoveryProcessorContext context) {
        Set<RecoveryProcessor> subProcessors = this.buildSubProcessors(context);
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.setChildProc(subProcessors);
        } else {
            this.updateSubProcessors(subProcessors);
        }
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(new ArrayList(this.getChildProc()));
        recoveryTemplate.process(context);
        if (!this.calcProcessResultBySubProc()) {
            String clusterUser = (String)context.getAttribute("clusterUser", String.class);
            LOGGER.error((Object)"Failed to test cluster, cluster user: %s", new Object[]{clusterUser});
            throw new LegoCheckedException(1073949741L);
        }
    }

    private Set<RecoveryProcessor> buildSubProcessors(RecoveryProcessorContext context) {
        TestOpenGaussAppSubProcessor testSubProcessor;
        OpenGaussAction action;
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        String clusterUser = (String)context.getAttribute("clusterUser", String.class);
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == this.getProcType() || DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() == this.getProcType()) {
            action = (OpenGaussAction)((Object)context.getAttribute("primaryAction", OpenGaussAction.class));
            testSubProcessor = this.createTestSubProcessor(action, clusterUser);
            subProcessors.add((RecoveryProcessor)testSubProcessor);
        }
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() == this.getProcType()) {
            return subProcessors;
        }
        action = (OpenGaussAction)((Object)context.getAttribute("mainStandbyAction", OpenGaussAction.class));
        testSubProcessor = this.createTestSubProcessor(action, clusterUser);
        subProcessors.add((RecoveryProcessor)testSubProcessor);
        return subProcessors;
    }

    private TestOpenGaussAppSubProcessor createTestSubProcessor(OpenGaussAction action, String clusterUser) {
        TestOpenGaussAppSubProcessor processor = new TestOpenGaussAppSubProcessor();
        processor.setProcName(processor.getName());
        processor.setProcType(this.getProcType());
        processor.setPlanId(this.getPlanId());
        processor.setProcessId(this.getProcessId());
        processor.setParentProc((RecoveryProcessor)this);
        processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        processor.setAction(action);
        processor.setClusterUser(clusterUser);
        return processor;
    }
}

