/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.opengauss.recovery.provider;

import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.opengauss.util.OpenGaussUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupExtendUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.recovery.framework.provider.BaseRecoveryProcessProvider;
import com.huawei.ism.drm.recovery.sdk.model.MountConfiguration;
import com.huawei.ism.drm.recovery.task.ICallBackExcuteRecoveryTask;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.storage.manager.proxy.StorageReplicationManagerProxy;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class OpenGaussRecoveryProcessProvider
extends BaseRecoveryProcessProvider {
    private static final Log LOGGER = LogFactory.getInstance(OpenGaussRecoveryProcessProvider.class);

    public Map<String, Object> checkRecoveryContext(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, Map<String, String> recoveryContext, User operator) {
        DrResource standbyResource;
        String standbyHostGroupSN;
        if (recoveryContext == null || procType == null || planId == null) {
            throw new LegoCheckedException(1073947393L);
        }
        String remoteSiteId = recoveryContext.get("remoteSiteId");
        if (VerifyUtil.isEmpty((String)remoteSiteId)) {
            LOGGER.error((Object)"Remote site id is null.");
            throw new LegoCheckedException(1073947393L);
        }
        HashMap<String, Object> setting = new HashMap<String, Object>();
        setting.put("DISASTER_SITE_ID", remoteSiteId);
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        String disasterHostSn = recoveryContext.get("disasterHostSn");
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.equals((Object)procType) && disasterHostSn.equals(standbyHostGroupSN = (standbyResource = recoveryService.getDrResourceByID(this.getProtectObjectDisasterHostSn(planId))).getParentDrResource().getDeviceSn())) {
            LOGGER.error((Object)"Param error. disasterHostSn cannot be the same as standbyHostSN.");
            throw new LegoCheckedException(1073947789L);
        }
        DrResource drResource = recoveryService.getDrResourceByID(disasterHostSn);
        if (!(drResource instanceof DrHostGroup)) {
            LOGGER.error((Object)"Param error. disasterHostSn is must hostGroup Id.");
            throw new LegoCheckedException(1073947393L);
        }
        setting.put("PG_DISASTER_HOST", disasterHostSn);
        this.checkXlogPairStatus(planId, procType);
        return setting;
    }

    private void checkXlogPairStatus(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE procType) {
        if (procType == DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION) {
            IRecoveryPlanService recoveryPlanService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
            RecoveryPlan recoveryPlan = recoveryPlanService.getRecoveryPlanWithProcess(planId);
            if (recoveryPlan.getPlanStatus() != DrmEnumDefine.RecoveryPlanStatusE.READY.getValue()) {
                return;
            }
            ProtectGroup protectGroup = recoveryPlan.getProtectGroup();
            String replicationId = (String)ProtectGroupExtendUtil.getAllRemoteStorageReplica((ProtectGroup)protectGroup).stream().map(RemoteStorageReplica::getReplicationPairId).collect(Collectors.toList()).stream().findFirst().orElseThrow(() -> new LegoCheckedException(1073947393L));
            StorageReplicationManagerProxy srmProxy = StorageReplicationManagerProxy.getInstance();
            ReplicationPair replicationPair = srmProxy.getReplicationPair(this.getProductArray(protectGroup), replicationId);
            ReplicationTargetLun targetLun = (ReplicationTargetLun)replicationPair.getRepTgtLuns().stream().findFirst().orElseThrow(() -> new LegoCheckedException(1073947393L));
            if (XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue() != targetLun.getPairStatus().intValue() && XveEuumDefineParent.RUNNING_STATUS_E.SYNCHRONIZING.getValue() != targetLun.getPairStatus().intValue()) {
                LOGGER.error((Object)"The pair(%s) status is %s, not in the normal or synchronizing.", new Object[]{targetLun.getReplicationPairId(), targetLun.getPairStatus()});
                throw new LegoCheckedException(1073948729L);
            }
        }
    }

    private String getProductArray(ProtectGroup protectGroup) {
        Optional optional = protectGroup.getReplicaList().stream().findFirst();
        if (!optional.isPresent()) {
            LOGGER.error((Object)"Protect group replica list is empty,protect group name:%s", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(1073947393L);
        }
        return ((ProtectGroupReplica)optional.get()).getProductArray();
    }

    private String getProtectObjectDisasterHostSn(String planId) {
        IRecoveryPlanService planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        RecoveryPlan recoveryPlan = planService.queryRecoveryPlan(planId, true);
        ProtectGroup protectGroup = recoveryPlan.getProtectGroup();
        ProtectObject po = OpenGaussUtil.getProtectObject(protectGroup);
        Optional optional = OpenGaussUtil.getDisasterHost(po).stream().findFirst();
        if (!optional.isPresent()) {
            LOGGER.error((Object)"Get protectObject DisasterHostSn failed.");
            throw new LegoCheckedException(1073947393L);
        }
        return (String)optional.get();
    }

    public List<String> getAppType() {
        return Collections.singletonList(DrmEnumDefine.AppType.OPEN_GAUSS.name());
    }

    public void resetRecoveryProcessDefinition(RecoveryPlan recoveryPlan, RecoveryProcessDefinition rpDefinition, boolean isNeedSaveToDb) {
        super.resetRecoveryProcessDefinition(recoveryPlan, rpDefinition, isNeedSaveToDb);
    }

    public ICallBackExcuteRecoveryTask getRecoveryCallbackTask(DrmEnumDefine.RecoveryPlanExecuteTypeE executeTypeE) {
        return super.getRecoveryCallbackTask(executeTypeE);
    }

    public Set<RecoverySetting> getMountRecoverySettings(RecoveryPlan plan, ProtectGroupReplica protectGroupReplica, MountConfiguration mountConfigs) {
        return super.getMountRecoverySettings(plan, protectGroupReplica, mountConfigs);
    }

    public String getRecoverySiteId(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, Map<String, String> recoveryContext) {
        String disasterSiteId = "";
        RecoveryPlan plan = ((IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class)).getRecoveryPlan(planId);
        if (VerifyUtil.isEmpty((Object)plan)) {
            throw new LegoCheckedException(201L);
        }
        Set protectGroups = plan.getProtectGroups();
        for (ProtectGroup protectGroup : protectGroups) {
            disasterSiteId = protectGroup.getAnyoneReplicationReplica().getRecoverySite();
        }
        return disasterSiteId;
    }
}

