/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.opengauss.recovery.provider;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.database.opengauss.sdk.model.OpenGaussCluster;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.opengauss.adapter.service.impl.OpenGaussProvider;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.recovery.framework.provider.BaseRefactorConfigurationProvider;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.util.CastUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OpenGaussRefactorConfigurationProvider
extends BaseRefactorConfigurationProvider {
    private static final Log LOG = LogFactory.getInstance(OpenGaussRefactorConfigurationProvider.class);

    public List<String> getAppType() {
        ArrayList<String> appTypes = new ArrayList<String>();
        appTypes.add(DrmEnumDefine.AppType.OPEN_GAUSS.name());
        return appTypes;
    }

    protected void refactorProtectObjectStorageInfos(ProtectObject protectObject, Map<String, Object> params) {
    }

    protected void reverseProtectObjectAttributes(ProtectObject protectObject, Map<String, Object> params) {
        ProtectGroup protectGroup = protectObject.getProtectGroup();
        String providerSn = protectGroup.getPoProviderSN();
        protectObject.setProviderSN(providerSn);
        DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(providerSn);
        protectObject.setProviderName(drResource.getName());
        OpenGaussProvider provider = (OpenGaussProvider)((Object)ServiceLocator.getInstance().getService(OpenGaussProvider.class));
        provider.offerLoadAppStorageInfo(new ArrayList<ProtectObject>(protectGroup.getPolist()));
        Map props = protectObject.getProps();
        this.reverseNodeConfig(props);
        String user = (String)props.get("USERNAME");
        ArrayList<DrResource> hostList = new ArrayList<DrResource>();
        if (drResource instanceof DrHostGroup) {
            Set childResources = drResource.getChildResources();
            hostList.addAll(childResources);
        } else {
            hostList.add(drResource);
        }
        this.updateClusterInfo(hostList, user, protectObject);
    }

    private void reverseNodeConfig(Map<String, String> props) {
        String nodeConfig = props.get("nodeConfig");
        if (VerifyUtil.isEmpty((String)nodeConfig)) {
            LOG.error((Object)"Cant get 'nodeConfig' property.");
            throw new LegoCheckedException(1073947394L);
        }
        JSONObject jsonObject = JSONObject.fromObject((Object)nodeConfig);
        JSONArray primary = jsonObject.getJSONArray("PRIMARY");
        JSONArray standby = jsonObject.getJSONArray("STANDBY");
        jsonObject.clear();
        jsonObject.put((Object)"PRIMARY", (Object)standby);
        jsonObject.put((Object)"STANDBY", (Object)primary);
        props.put("nodeConfig", jsonObject.toString());
    }

    private void updateClusterInfo(List<DrResource> hostList, String clusterUser, ProtectObject po) {
        for (DrResource drResource : hostList) {
            String sn = drResource.getDeviceSn();
            HashMap<String, Object> opcProps = new HashMap<String, Object>();
            opcProps.put("hostSN", sn);
            opcProps.put("clusterUser", clusterUser);
            opcProps.put("isPrimary", true);
            List clusters = CommonDAOLocator.getMoDao().findMoBy(OpenGaussCluster.class, "name", true, opcProps);
            if (clusters.isEmpty()) continue;
            OpenGaussCluster cluster = (OpenGaussCluster)clusters.get(0);
            po.setMoUuid(cluster.getUuid());
            po.setName(cluster.getClusterName());
            po.getProps().put("remoteIp", cluster.getProps().get("remoteIp"));
            break;
        }
    }

    protected void reverseProtectGroupAttributes(ProtectGroup protectGroup, Map<String, Object> params) {
        RecoveryPlan recoveryPlan = (RecoveryPlan)CastUtil.castTo((Object)params.get("RecoveryPlan"), RecoveryPlan.class);
        String disasterHostSn = (String)recoveryPlan.getGlobalSettings().get("PG_DISASTER_HOST");
        protectGroup.setPoProviderSN(disasterHostSn);
    }

    public void afterRefactorConfiguration(Set<ProtectGroup> protectGroups) {
        String[] pgIds = (String[])protectGroups.stream().map(DRMObject::getUuid).toArray(String[]::new);
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        for (String pgId : pgIds) {
            pgService.resetProtectGroupStatus(pgId);
        }
    }

    public void afterRefactorConfiguration(RecoveryProcessorContext context) {
        super.afterRefactorConfiguration(context);
        context.removeAttribute("LockProtectGroup");
    }

    protected void refactorPolicyTemplate(ProtectGroup pg) {
    }
}

