/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.opengauss.template.filter;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.drm.app.constants.DrmAppEnumDefine;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.opengauss.adapter.service.impl.OpenGaussManagerImpl;
import com.huawei.ism.drm.opengauss.util.OpenGaussUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.protection.template.filter.ArraySyncReplicationFilter;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.util.CastUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.core.system.context.ExecutionContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class OpenGaussClusterSyncFilter
extends ArraySyncReplicationFilter {
    private static final Log LOG = LogFactory.getInstance(OpenGaussClusterSyncFilter.class);
    private static final String PAIRS_BY_ID = "PAIRS_BY_ID";
    private static final String PROTECT_OBJECTS = "PROTECT_OBJECTS";
    private static final int RECOVERY_POLICY_AUTO = 1;
    private static final String PRIMARY_HOST = "PRIMARY_HOST";
    private OpenGaussManagerImpl openGaussManager;

    protected void arrayFilterRule(int type, int locationType, List<ProtectObject> protectObjects, int templateType, ExecutionContext context) {
        super.arrayFilterRule(type, locationType, protectObjects, templateType, context);
        this.getFilterContext().put(PROTECT_OBJECTS, protectObjects);
        this.checkPrimaryCluster();
        this.initOpenGaussLunInfo(protectObjects);
        this.checkXlogPair();
        this.checkDataDevice();
        this.checkStandbyCluster(protectObjects);
        this.checkDataDevice();
    }

    private void initOpenGaussLunInfo(List<ProtectObject> protectObjects) {
        Object obj = this.getFilterContext().get(PRIMARY_HOST);
        DrResource drResource = (DrResource)CastUtil.castTo(obj, DrResource.class);
        for (ProtectObject protectObject : protectObjects) {
            String oldProviderSn = protectObject.getProviderSN();
            protectObject.setProviderSN(drResource.getDeviceSn());
            this.openGaussManager.generateLUNDetail(protectObject);
            protectObject.setProviderSN(oldProviderSn);
        }
    }

    protected Map<String, List<ReplicationPair>> getClassifiedPairMap(Set<String> resourceIdSet, List<Lun> lunList) {
        Map classifiedPairMap = super.getClassifiedPairMap(resourceIdSet, lunList);
        this.getFilterContext().put(PAIRS_BY_ID, classifiedPairMap);
        return classifiedPairMap;
    }

    private void checkPrimaryCluster() {
        ProtectObject protectObject = this.getProtectObjectFromContext();
        String hostGroupSn = protectObject.getProviderSN();
        DrResource drResource = this.getResourceService().getDrResourceBySn(hostGroupSn);
        if (!(drResource instanceof DrHostGroup)) {
            LOG.error((Object)"OpenGauss only support host group: %s", new Object[]{drResource});
            throw new LegoCheckedException(1073948191L);
        }
        this.getFilterContext().put("HOST_GROUP_SN", drResource.getDeviceSn());
        DrHostGroup drHostGroup = (DrHostGroup)drResource;
        int clusterType = drHostGroup.getClusterType();
        if (clusterType != DrmAppEnumDefine.CLUSTER_TYPE_E.OPENGAUSS.getValue()) {
            LOG.error((Object)"Not support cluster type: %s", new Object[]{String.valueOf(clusterType)});
            throw new LegoCheckedException(1073948191L);
        }
        String clusterUser = (String)protectObject.getProps().get("USERNAME");
        Set childResources = drHostGroup.getChildResources();
        ArrayList<DrResource> primaryHosts = new ArrayList<DrResource>();
        for (DrResource drHost : childResources) {
            ProtectObject tmpPo = new ProtectObject();
            tmpPo.setProviderSN(drHost.getDeviceSn());
            tmpPo.getProps().put("USERNAME", clusterUser);
            if (!this.openGaussManager.isPrimary(drHost.getDeviceSn(), clusterUser)) continue;
            this.openGaussManager.testConnecting(tmpPo);
            LOG.info((Object)"Primary node host sn: %s, cluster user: %s.", new Object[]{drHost.getDeviceSn(), clusterUser});
            primaryHosts.add(drHost);
        }
        if (primaryHosts.size() != 1) {
            LOG.error((Object)"Primary node of cluster must be unique but there are %s.", (long)primaryHosts.size());
            throw new LegoCheckedException(1073948191L);
        }
        this.getFilterContext().put(PRIMARY_HOST, CommonUtil.getFirstElement(primaryHosts));
    }

    private void checkXlogPair() {
        Object obj = this.getFilterContext().get(PAIRS_BY_ID);
        Map lunAndPairMap = (Map)CastUtil.castTo(obj, Map.class);
        if (VerifyUtil.isEmpty((Map)lunAndPairMap)) {
            LOG.error((Object)"Cant find resource id set");
            throw new LegoCheckedException(1073947393L);
        }
        List pairs = lunAndPairMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        VerifyUtil.checkObject(pairs);
        if (lunAndPairMap.size() != 1 && pairs.size() != 1) {
            LOG.error((Object)"Number of pairs should be just one, actual: %s", new Object[]{String.valueOf(lunAndPairMap.size())});
            throw new LegoCheckedException(1073948191L);
        }
        ProtectObject protectObject = this.getProtectObjectFromContext();
        List siteBHostSns = (List)((Map)JSONObject.toBean((String)((String)protectObject.getProps().get("nodeConfig")), Map.class)).get("STANDBY");
        String siteBHostGroupSn = (String)siteBHostSns.iterator().next();
        DrResource siteBDrResource = this.getResourceService().getDrResourceBySn(siteBHostGroupSn);
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        Site siteBySIteBDrResource = siteService.getSiteById(siteBDrResource.getSiteId());
        Site siteByPairSn = siteService.getSiteByDeviceSn(((ReplicationPair)pairs.get(0)).getTgtDevSN());
        boolean isSiteAMatch = ((ProtectObjectStorageInfo)protectObject.getUsedStorageResourceSet().iterator().next()).getResourceProviderSN().equals(((ReplicationPair)pairs.get(0)).getSrcDevSN());
        boolean isSiteBMatch = siteByPairSn.getSiteId().equals(siteBySIteBDrResource.getSiteId());
        if (!isSiteBMatch || !isSiteAMatch) {
            LOG.error((Object)"SiteA or siteB is not match. IsSiteAMatch:%s, IsSiteBMatch:%s", new Object[]{String.valueOf(isSiteAMatch), String.valueOf(isSiteBMatch)});
            throw new LegoCheckedException(1073949753L);
        }
        ReplicationTargetLun targetLun = (ReplicationTargetLun)pairs.stream().map(ReplicationPair::getRepTgtLuns).flatMap(Collection::stream).findFirst().orElseThrow(() -> new LegoCheckedException(1073947393L));
        if (targetLun.getResumePolicy() != 1) {
            LOG.error((Object)"Recovery policy of pair(%s) should be auto", new Object[]{targetLun.getReplicationPairId()});
            throw new LegoCheckedException(1073949736L);
        }
        if (XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue() != targetLun.getPairStatus().intValue() && XveEuumDefineParent.RUNNING_STATUS_E.SYNCHRONIZING.getValue() != targetLun.getPairStatus().intValue()) {
            LOG.error((Object)"The pair(%s) status is %s, not in the normal or synchronizing.", new Object[]{targetLun.getReplicationPairId(), targetLun.getPairStatus()});
            throw new LegoCheckedException(1073948729L);
        }
    }

    private void checkDataDevice() {
        ProtectObject protectObject = this.getProtectObjectFromContext();
        VerifyUtil.checkObject((Object)protectObject);
        Map props = protectObject.getProps();
        Map<String, JSONArray> diskArrayMap = this.parseStrToJsonArray(props, Arrays.asList("DATA_DISKS", "SHARED_DISKS", "VOTING_DISKS"));
        this.checkPairAndDevice(diskArrayMap.get("DATA_DISKS"));
        this.checkPairAndDevice(diskArrayMap.get("SHARED_DISKS"));
        this.checkPairAndDevice(diskArrayMap.get("VOTING_DISKS"));
    }

    private ProtectObject getProtectObjectFromContext() {
        Object obj = this.getFilterContext().get(PROTECT_OBJECTS);
        List poList = (List)CastUtil.castTo(obj, List.class);
        return (ProtectObject)CommonUtil.getFirstElement((Collection)poList);
    }

    private void checkPairAndDevice(JSONArray dataDisks) {
        ArrayList<String> resourceIds = new ArrayList<String>();
        String devSn = "";
        for (Object dataDisk : dataDisks) {
            ProtectObjectStorageInfo info = (ProtectObjectStorageInfo)JSONObject.toBean((JSONObject)((JSONObject)CastUtil.castTo(dataDisk, JSONObject.class)), ProtectObjectStorageInfo.class);
            resourceIds.add(info.getResourceId());
            devSn = info.getResourceProviderSN();
            if (info.getStorageType().intValue() != DrmEnumDefine.StorageTypeE.NORMAL.getValue()) {
                LOG.error((Object)"Storage is not of HUAWEI: %s", new Object[]{String.valueOf(info.getStorageType())});
                throw new LegoCheckedException(1073949737L);
            }
            VerifyUtil.checkStrs((String[])new String[]{info.getAlias()});
            String protocol = info.getAlias().substring(0, info.getAlias().indexOf(":"));
            if (OpenGaussUtil.isSupportProtocol(protocol)) continue;
            LOG.error((Object)"Not supported protocol: %s", new Object[]{protocol});
            throw new LegoCheckedException(1073949738L);
        }
        List pairList = this.getStorageService().getReplicationPairsByResourceIds(devSn, resourceIds, Integer.valueOf(DrmEnumDefine.ResourceTypeE.LUN.getValue()));
        if (!VerifyUtil.isEmpty((Collection)pairList)) {
            LOG.error((Object)"Data disk must not has pairs: %s", new Object[]{String.valueOf(pairList.size())});
            throw new LegoCheckedException(1073948191L);
        }
    }

    private void checkStandbyCluster(List<ProtectObject> protectObjects) {
        ProtectObject protectObject = (ProtectObject)CommonUtil.getFirstElement(protectObjects);
        String clusterUser = OpenGaussUtil.getClusterUser(protectObject);
        String nodeConfigJson = (String)protectObject.getProps().get("nodeConfig");
        JSONObject nodeConfigObj = JSONObject.fromObject((Object)nodeConfigJson);
        Object jsonObj = nodeConfigObj.get("STANDBY");
        JSONArray remoteHostSnArr = (JSONArray)CastUtil.castTo((Object)jsonObj, JSONArray.class);
        ArrayList<ProtectObject> mainStandbyPoList = new ArrayList<ProtectObject>();
        for (Object hostSnObj : remoteHostSnArr) {
            String hostSn = (String)CastUtil.castTo(hostSnObj, String.class);
            ProtectObject tmpPo = new ProtectObject();
            tmpPo.setProviderSN(hostSn);
            tmpPo.getProps().put("USERNAME", clusterUser);
            if (!this.openGaussManager.isMainStandby(hostSn, clusterUser)) continue;
            this.openGaussManager.testConnecting(tmpPo);
            LOG.info((Object)"Main standby node host sn: %s, cluster user: %s.", new Object[]{hostSn, clusterUser});
            this.openGaussManager.generateLUNDetail(tmpPo);
            mainStandbyPoList.add(tmpPo);
        }
        if (mainStandbyPoList.size() != 1) {
            LOG.error((Object)"Main standby node of cluster must be unique but there are %s.", (long)mainStandbyPoList.size());
            throw new LegoCheckedException(1073948191L);
        }
        this.getFilterContext().put(PROTECT_OBJECTS, mainStandbyPoList);
    }

    private Map<String, JSONArray> parseStrToJsonArray(Map<String, String> props, List<String> list) {
        HashMap<String, JSONArray> result = new HashMap<String, JSONArray>();
        for (String diskKey : list) {
            String diskJsonStr = props.get(diskKey);
            VerifyUtil.checkObject((Object)diskJsonStr);
            JSONArray jsonArray = JSONArray.fromObject((Object)diskJsonStr);
            result.put(diskKey, jsonArray);
        }
        return result;
    }

    public int getType() {
        return 57;
    }

    public void setOpenGaussManager(OpenGaussManagerImpl openGaussManager) {
        this.openGaussManager = openGaussManager;
    }
}

