/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.opengauss.topology;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.database.opengauss.sdk.model.OpenGaussCluster;
import com.huawei.ism.database.sdk.model.ClusterInstance;
import com.huawei.ism.drm.application.adapter.sdk.service.IApplicationManager;
import com.huawei.ism.drm.application.manager.proxy.ApplicationAdapterProxy;
import com.huawei.ism.drm.db.topology.DataBaseTopoBuilder;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.host.sdk.service.IHostService;
import com.huawei.ism.drm.host.topology.element.ClusterElement;
import com.huawei.ism.drm.host.topology.element.ClusterNodeElement;
import com.huawei.ism.drm.host.topology.element.DiskElement;
import com.huawei.ism.drm.host.topology.skin.HostGroupSkin;
import com.huawei.ism.drm.host.topology.skin.HostSkin;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.opengauss.constant.OpenGaussEumDefine;
import com.huawei.ism.drm.opengauss.hostagent.action.OpenGaussAction;
import com.huawei.ism.drm.opengauss.util.OpenGaussUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.topology.ReplicaRelation;
import com.huawei.ism.drm.topo.element.SiteElement;
import com.huawei.ism.drm.topo.sdk.context.TopoBaseContext;
import com.huawei.ism.drm.topo.sdk.manager.ITopoResourceManager;
import com.huawei.ism.drm.topo.sdk.topology.Skin;
import com.huawei.ism.drm.topo.topology.TopoElement;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.ism.drm.util.CastUtil;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.topology.IData;
import com.huawei.topology.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

@ServiceBoundInfo(methodName="onBind", targetBeanName="topoBuilderManager", properties="type:ProtectGroup-19")
public class OpenGaussHostTopoBuilder
extends DataBaseTopoBuilder {
    private static final Log LOGGER = LogFactory.getInstance(OpenGaussHostTopoBuilder.class);
    private static final String DATA = "DATA_DISK";
    private static final String XLOG = "XLOG_DISK";
    private static final String SHARED = "SHARED_DISK";
    private static final String VOTING = "VOTING_DISK";
    private static final Map<String, String> KEYMAP = new HashMap<String, String>();
    private static final List<String> KEYLIST = Arrays.asList("DATA_DISKS", "VOTING_DISKS", "SHARED_DISKS");

    public void buildTopo(TopoBaseContext context) {
        if (context == null) {
            LOGGER.error((Object)"Context is null.");
            return;
        }
        this.initialize(context);
        this.buildProductSiteTopo(context);
        this.buildDisasterSiteTopo(context);
    }

    private void buildProductSiteTopo(TopoBaseContext context) {
        ProtectGroup protectGroup = context.getProtectGroup();
        String productSiteId = protectGroup.getProductSiteId();
        Site productSite = context.getSiteService().getSiteById(productSiteId);
        SiteElement productSiteNode = new SiteElement(productSite);
        context.addChild((IData)context.getRootNode(), (IData)productSiteNode);
        this.buildHostNode(context, (Node)productSiteNode);
    }

    private void buildHostNode(TopoBaseContext context, Node siteNode) {
        ProtectGroup protectGroup = context.getProtectGroup();
        String poHostSn = protectGroup.getPoProviderSN();
        DrResource resource = this.getDrResource(poHostSn);
        ProtectObject po = OpenGaussUtil.getProtectObject(protectGroup);
        OpenGaussCluster cluster = this.getCluster(OpenGaussUtil.getClusterUser(po), OpenGaussUtil.getPrimaryHostSns(po));
        ClusterElement clusterNode = new ClusterElement((ClusterInstance)cluster);
        clusterNode.setName(cluster.getClusterName());
        context.addChild((IData)siteNode, (IData)clusterNode);
        if (resource instanceof DrHost) {
            String hostKey = resource.getDeviceSn() + ":hostStyleNode";
            TopoElement hostStyleNode = new TopoElement((Object)hostKey).use(new Skin[]{new HostSkin()});
            context.addChild((IData)clusterNode, (IData)hostStyleNode);
            this.buildOpenGaussHostTopo(context, (DrHost)resource, (Node)hostStyleNode, true, cluster.getClusterUser());
        } else if (resource instanceof DrHostGroup) {
            DrHostGroup hostGroup = (DrHostGroup)resource;
            String hostGroupKey = hostGroup.getDeviceSn() + ":hostGroup";
            TopoElement hostGroupStyleNode = new TopoElement((Object)hostGroupKey).use(new Skin[]{new HostGroupSkin()});
            context.addChild((IData)clusterNode, (IData)hostGroupStyleNode);
            Set drHosts = hostGroup.getChildResources();
            List<DrResource> drResources = this.sortHost(drHosts, cluster, true);
            drResources.forEach(arg_0 -> this.lambda$buildHostNode$0(context, (Node)hostGroupStyleNode, drResources, cluster, arg_0));
        } else {
            LOGGER.error((Object)"Not support type:%s.", new Object[]{resource.getClass().getName()});
            throw new LegoCheckedException(-1L);
        }
    }

    private List<DrResource> sortHost(Set<DrResource> drHosts, OpenGaussCluster cluster, boolean isPrimary) {
        ArrayList<DrResource> list = new ArrayList<DrResource>();
        INeMgrProtocolExtendService neMgr = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
        for (DrResource drHost : drHosts) {
            String sn = drHost.getDeviceSn();
            NeMgrProtocolExtend ne = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)neMgr, (String)sn);
            OpenGaussAction action = new OpenGaussAction(ne, sn);
            if (isPrimary && action.isPrimary(cluster.getClusterUser()) || !isPrimary && action.isMainStandby(cluster.getClusterUser())) {
                list.add(0, drHost);
                continue;
            }
            list.add(drHost);
        }
        return list;
    }

    private void buildOpenGaussHostTopo(TopoBaseContext context, DrHost resource, Node root, boolean isPrimary, String clusterUser) {
        ProtectGroup protectGroup = context.getProtectGroup();
        String hostSn = resource.getDeviceSn();
        OpenGaussEumDefine.ClusterNodeState state = this.reloadNodeState(resource, clusterUser);
        Node hostNode = (Node)context.addChild((IData)root, (IData)new ClusterNodeElement(resource, state.getValue()));
        this.setHostNodeName(hostNode, isPrimary);
        ProtectObject po = OpenGaussUtil.getProtectObject(protectGroup);
        this.createRedoLogNode(context, hostNode, po, hostSn);
        KEYLIST.forEach(key -> this.createNodeByKey(context, hostNode, po, (String)key, hostSn));
    }

    private OpenGaussEumDefine.ClusterNodeState reloadNodeState(DrHost resource, String clusterUser) {
        INeMgrProtocolExtendService neMgr = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
        NeMgrProtocolExtend ne = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)neMgr, (String)resource.getDeviceSn());
        OpenGaussAction action = new OpenGaussAction(ne, resource.getDeviceSn());
        return action.queryClusterNodeState(clusterUser);
    }

    private void setHostNodeName(Node hostNode, boolean isPrimary) {
        ITopoResourceManager resourceManager = TopoBaseContext.getTopoResourceManager();
        String name = isPrimary ? resourceManager.getText("ism.drm.topo.host.role.primary") : resourceManager.getText("ism.drm.topo.host.role.standby");
        hostNode.setName(hostNode.getName() + name);
    }

    private void setDisasterHostNodeName(Node hostNode, boolean isMainStandby) {
        ITopoResourceManager resourceManager = TopoBaseContext.getTopoResourceManager();
        String name = isMainStandby ? resourceManager.getText("ism.drm.topo.host.role.mainstandby") : resourceManager.getText("ism.drm.topo.host.role.standby");
        hostNode.setName(hostNode.getName() + name);
    }

    private void createRedoLogNode(TopoBaseContext context, Node root, ProtectObject po, String hostSn) {
        Set storages = po.getUsedStorageResourceSet();
        for (ProtectObjectStorageInfo storage : storages) {
            Node diskGroupStyleNode = TopoServiceUtil.createDiskGroupStyleNode((TopoBaseContext)context, (String)hostSn);
            context.addChild((IData)root, (IData)diskGroupStyleNode);
            DiskElement diskNode = new DiskElement((Object)(hostSn + ":" + storage.getId()));
            diskNode.setName(XLOG);
            context.addChild((IData)diskGroupStyleNode, (IData)diskNode);
            Node diskStyleNode = TopoServiceUtil.createDiskStyleNode((TopoBaseContext)context, (String)hostSn);
            context.addChild((IData)root, (IData)diskStyleNode);
            String id = hostSn + ":" + storage.getDeviceName();
            DiskElement mountNode = new DiskElement((Object)id);
            mountNode.setName(storage.getDeviceName());
            context.addChild((IData)diskStyleNode, (IData)mountNode);
            context.linkTo((Node)diskNode, (Node)mountNode, new Skin[0]);
        }
    }

    private void createNodeByKey(TopoBaseContext context, Node root, ProtectObject po, String key, String hostSn) {
        Map props = po.getProps();
        String json = (String)props.get(key);
        JSONArray array = JSONArray.fromObject((Object)json);
        List poStorageInfos = JSONArray.toCollection((JSONArray)array, ProtectObjectStorageInfo.class);
        for (ProtectObjectStorageInfo poStorageInfo : poStorageInfos) {
            Node diskGroupStyleNode = TopoServiceUtil.createDiskGroupStyleNode((TopoBaseContext)context, (String)hostSn);
            context.addChild((IData)root, (IData)diskGroupStyleNode);
            Node diskStyleNode = TopoServiceUtil.createDiskStyleNode((TopoBaseContext)context, (String)hostSn);
            context.addChild((IData)root, (IData)diskStyleNode);
            DiskElement diskNode = new DiskElement((Object)(hostSn + ":" + poStorageInfo.getId()));
            diskNode.setName(KEYMAP.get(key));
            context.addChild((IData)diskGroupStyleNode, (IData)diskNode);
            String id = hostSn + ":" + poStorageInfo.getDeviceName();
            DiskElement mountNode = new DiskElement((Object)id);
            mountNode.setName(poStorageInfo.getDeviceName());
            context.addChild((IData)diskStyleNode, (IData)mountNode);
            context.linkTo((Node)diskNode, (Node)mountNode, new Skin[0]);
        }
    }

    private void buildDisasterSiteTopo(TopoBaseContext context) {
        ProtectGroup pg = context.getProtectGroup();
        Set pgReplicas = pg.getReplicaList();
        List<ReplicaRelation> relations = this.transform(pg, pgReplicas);
        ReplicaRelation replicaRelation = relations.get(0);
        Site recoverySite = context.getSiteService().getSiteById(replicaRelation.getRecoverySite());
        context.getSiteMaps().put("DisasterSite", recoverySite);
        SiteElement recoverySiteNode = new SiteElement(recoverySite);
        context.addChild((IData)context.getRootNode(), (IData)recoverySiteNode);
        this.buildDisasterHostNode(context, (Node)recoverySiteNode);
    }

    private void buildDisasterHostNode(TopoBaseContext context, Node siteNode) {
        ProtectGroup protectGroup = context.getProtectGroup();
        ProtectObject po = OpenGaussUtil.getProtectObject(protectGroup);
        Set<String> disasterHostSn = OpenGaussUtil.getDisasterHost(po);
        OpenGaussCluster cluster = this.getCluster(OpenGaussUtil.getClusterUser(po), disasterHostSn);
        ClusterElement clusterNode = new ClusterElement((ClusterInstance)cluster);
        clusterNode.setName(cluster.getClusterName());
        context.addChild((IData)siteNode, (IData)clusterNode);
        DrHostGroup hostGroup = this.getDisasterHostGroup(disasterHostSn);
        String hostGroupKey = hostGroup.getDeviceSn() + ":hostGroup";
        TopoElement hostGroupStyleNode = new TopoElement((Object)hostGroupKey).use(new Skin[]{new HostGroupSkin()});
        context.addChild((IData)clusterNode, (IData)hostGroupStyleNode);
        IApplicationManager appManager = ApplicationAdapterProxy.getInstance().getAppManager(po.getPoType());
        ProtectObject tmpPo = null;
        for (String sn : disasterHostSn) {
            tmpPo = this.getTmpProtectObject(cluster.getClusterUser(), sn);
            try {
                appManager.generateLUNDetail(tmpPo);
                this.refreshProtectObject(po, tmpPo);
                break;
            }
            catch (LegoCheckedException e) {
                LOGGER.error((Object)"Query lun info by topo failed.");
            }
        }
        if (VerifyUtil.isEmpty(tmpPo)) {
            LOGGER.error((Object)"Temp po is null.");
            throw new LegoCheckedException(1073947393L);
        }
        Set drHosts = hostGroup.getChildResources();
        List<DrResource> drResources = this.sortHost(drHosts, cluster, false);
        for (DrResource host : drResources) {
            this.buildOpenGaussDisasterHostTopo(context, (DrHost)CastUtil.castTo((Object)host, DrHost.class), (Node)hostGroupStyleNode, tmpPo, host.getDeviceSn().equals(drResources.get(0).getDeviceSn()));
        }
    }

    private void buildOpenGaussDisasterHostTopo(TopoBaseContext context, DrHost resource, Node root, ProtectObject po, boolean isMainStandby) {
        String hostSn = resource.getDeviceSn();
        OpenGaussEumDefine.ClusterNodeState state = this.reloadNodeState(resource, OpenGaussUtil.getClusterUser(po));
        Node hostNode = (Node)context.addChild((IData)root, (IData)new ClusterNodeElement(resource, state.getValue()));
        this.setDisasterHostNodeName(hostNode, isMainStandby);
        this.createDisasterRedoLogNode(context, hostNode, po, hostSn);
        KEYLIST.forEach(key -> this.createDisasterNodeByKey(context, hostNode, po, (String)key, hostSn));
    }

    private void refreshProtectObject(ProtectObject srcPo, ProtectObject tmpPo) {
        srcPo.getUsedStorageResourceSet().addAll(tmpPo.getUsedStorageResourceSet());
        Set keys = tmpPo.getProps().keySet();
        for (String key : keys) {
            srcPo.getProps().put("Disaster:" + key, tmpPo.getProps().get(key));
        }
    }

    private void createDisasterRedoLogNode(TopoBaseContext context, Node root, ProtectObject po, String hostSn) {
        Set storages = po.getUsedStorageResourceSet();
        for (ProtectObjectStorageInfo storage : storages) {
            Node diskStyleNode = TopoServiceUtil.createDiskStyleNode((TopoBaseContext)context, (String)hostSn);
            context.addChild((IData)root, (IData)diskStyleNode);
            String id = hostSn + ":" + storage.getDeviceName();
            DiskElement mountNode = new DiskElement((Object)id);
            mountNode.setName(storage.getDeviceName());
            context.addChild((IData)diskStyleNode, (IData)mountNode);
            Node diskGroupStyleNode = TopoServiceUtil.createDiskGroupStyleNode((TopoBaseContext)context, (String)hostSn);
            context.addChild((IData)root, (IData)diskGroupStyleNode);
            DiskElement diskNode = new DiskElement((Object)(hostSn + ":" + storage.getId()));
            diskNode.setName(XLOG);
            context.addChild((IData)diskGroupStyleNode, (IData)diskNode);
            context.linkTo((Node)diskNode, (Node)mountNode, new Skin[0]);
        }
    }

    private ProtectObject getTmpProtectObject(String user, String sn) {
        ProtectObject po = new ProtectObject();
        po.setPoType(19);
        po.getProps().put("USERNAME", user);
        po.setProviderSN(sn);
        return po;
    }

    private void createDisasterNodeByKey(TopoBaseContext context, Node root, ProtectObject po, String key, String hostSn) {
        Map props = po.getProps();
        String json = (String)props.get(key);
        JSONArray array = JSONArray.fromObject((Object)json);
        List poStorageInfos = JSONArray.toCollection((JSONArray)array, ProtectObjectStorageInfo.class);
        for (ProtectObjectStorageInfo poStorageInfo : poStorageInfos) {
            Node diskStyleNode = TopoServiceUtil.createDiskStyleNode((TopoBaseContext)context, (String)hostSn);
            context.addChild((IData)root, (IData)diskStyleNode);
            Node diskGroupStyleNode = TopoServiceUtil.createDiskGroupStyleNode((TopoBaseContext)context, (String)hostSn);
            context.addChild((IData)root, (IData)diskGroupStyleNode);
            String id = hostSn + ":" + poStorageInfo.getDeviceName();
            DiskElement mountNode = new DiskElement((Object)id);
            mountNode.setName(poStorageInfo.getDeviceName());
            context.addChild((IData)diskStyleNode, (IData)mountNode);
            DiskElement diskNode = new DiskElement((Object)(hostSn + ":" + poStorageInfo.getId()));
            diskNode.setName(KEYMAP.get(key));
            context.addChild((IData)diskGroupStyleNode, (IData)diskNode);
            context.linkTo((Node)mountNode, (Node)diskNode, new Skin[0]);
        }
    }

    private OpenGaussCluster getCluster(String user, Set<String> hostSns) {
        HashMap<String, String> params = new HashMap<String, String>();
        OpenGaussCluster newCluster = new OpenGaussCluster();
        for (String sn : hostSns) {
            params.put("clusterUser", user);
            params.put("hostSN", sn);
            List clusters = CommonDAOLocator.getMoDao().findMoBy(OpenGaussCluster.class, params);
            Optional cluster = clusters.stream().findFirst();
            if (!cluster.isPresent()) {
                LOGGER.error((Object)"Not find cluster on host:%s:", new Object[]{sn});
                throw new LegoCheckedException(2117645L);
            }
            OpenGaussCluster oldCluster = (OpenGaussCluster)cluster.get();
            try {
                newCluster = this.getNewCluster(oldCluster);
                newCluster.setUuid(oldCluster.getUuid());
                return newCluster;
            }
            catch (LegoCheckedException e) {
                newCluster.setClusterUser(oldCluster.getClusterUser());
                newCluster.setClusterName(oldCluster.getClusterName());
                newCluster.setUuid(oldCluster.getUuid());
                LOGGER.error((Object)"Query status on host:%s failed.", new Object[]{sn});
            }
        }
        newCluster.setClusterState(ClusterInstance.ClusterState.UNKNOWN.getDesc());
        return newCluster;
    }

    private OpenGaussCluster getNewCluster(OpenGaussCluster oldCluster) {
        INeMgrProtocolExtendService neMgr = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
        NeMgrProtocolExtend ne = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)neMgr, (String)oldCluster.getHostSN());
        OpenGaussAction action = new OpenGaussAction(ne, oldCluster.getHostSN());
        return action.queryOneCluster(oldCluster.getClusterUser());
    }

    private DrHostGroup getDisasterHostGroup(Set<String> disasterHostSn) {
        String sn = (String)disasterHostSn.stream().iterator().next();
        IHostService service = (IHostService)ServiceLocator.getInstance().getService(IHostService.class);
        List drHostsBySns = service.getDrHostsBySns(new String[]{sn});
        Optional hostOptional = drHostsBySns.stream().findFirst();
        if (!hostOptional.isPresent()) {
            LOGGER.error((Object)"Not find host by sn:%s:", new Object[]{sn});
            throw new LegoCheckedException(2117645L);
        }
        DrHost drHost = (DrHost)hostOptional.get();
        DrResource drResource = drHost.getParentDrResource();
        if (drResource instanceof DrHostGroup) {
            return (DrHostGroup)drResource;
        }
        LOGGER.error((Object)"Error type of drResource.");
        throw new LegoCheckedException(1073947393L);
    }

    private List<ReplicaRelation> transform(ProtectGroup pg, Set<ProtectGroupReplica> replicas) {
        ArrayList<ReplicaRelation> relations = new ArrayList<ReplicaRelation>();
        for (ProtectGroupReplica replica : replicas) {
            ReplicaRelation relation;
            replica.setPg(pg);
            if (!replica.isStorageReplicationReplica() || (relation = new ReplicaRelation(pg, replica)).isEmpty()) continue;
            relations.add(relation);
        }
        Collections.sort(relations);
        return relations;
    }

    private /* synthetic */ void lambda$buildHostNode$0(TopoBaseContext context, Node hostGroupStyleNode, List drResources, OpenGaussCluster cluster, DrResource host) {
        this.buildOpenGaussHostTopo(context, (DrHost)CastUtil.castTo((Object)host, DrHost.class), hostGroupStyleNode, host.getDeviceSn().equals(((DrResource)drResources.get(0)).getDeviceSn()), cluster.getClusterUser());
    }

    static {
        KEYMAP.put("DATA_DISKS", DATA);
        KEYMAP.put("VOTING_DISKS", VOTING);
        KEYMAP.put("SHARED_DISKS", SHARED);
    }
}

