/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.opengauss.topology;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.drm.opengauss.util.OpenGaussUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.storage.topology.ArrayReplicationTopoBuilder;
import com.huawei.ism.drm.topo.element.LunElement;
import com.huawei.ism.drm.topo.sdk.context.TopoBaseContext;
import com.huawei.ism.drm.topo.sdk.topology.Skin;
import com.huawei.ism.drm.util.CastUtil;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.topology.IData;
import com.huawei.topology.IElement;
import com.huawei.topology.Node;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@ServiceBoundInfo(methodName="onBind", targetBeanName="topoBuilderManager", properties="type:PolicyTemplate-57")
public class OpenGaussTopoBuilder
extends ArrayReplicationTopoBuilder {
    private static final Log LOGGER = LogFactory.getInstance(OpenGaussTopoBuilder.class);
    private static final List<String> KEYLIST = Arrays.asList("DATA_DISKS", "VOTING_DISKS", "SHARED_DISKS");

    public void buildTopo(TopoBaseContext context) {
        super.buildTopo(context);
        this.buildProductSiteDiskLunTopo(context);
        this.buildDisasterSiteDiskLunTopo(context);
        this.reSortNode(context);
    }

    private void reSortNode(TopoBaseContext context) {
        Site site = (Site)context.getSiteMaps().get("DisasterSite");
        IElement siteElement = context.getElementBox().getElementByID((Object)site.getSiteId());
        List list = siteElement.getChildren();
        Collections.swap(list, 0, 1);
    }

    private void buildProductSiteDiskLunTopo(TopoBaseContext context) {
        ProtectGroup protectGroup = context.getProtectGroup();
        ProtectObject po = OpenGaussUtil.getProtectObject(protectGroup);
        Set<String> primaryHostSns = OpenGaussUtil.getPrimaryHostSns(po);
        ProtectObjectStorageInfo usedStorageInfo = this.getUsedStorageInfo(po, primaryHostSns);
        for (String primaryHostSn : primaryHostSns) {
            KEYLIST.forEach(key -> this.createLunNodeAndLinkToDisk(context, po, (String)key, primaryHostSn));
            this.linkRedoLunAndDisk(context, primaryHostSn, usedStorageInfo);
        }
    }

    private void buildDisasterSiteDiskLunTopo(TopoBaseContext context) {
        ProtectGroup protectGroup = context.getProtectGroup();
        ProtectObject po = OpenGaussUtil.getProtectObject(protectGroup);
        Set<String> disasterHostSns = OpenGaussUtil.getDisasterHost(po);
        ProtectObjectStorageInfo usedStorageInfo = this.getUsedStorageInfo(po, disasterHostSns);
        for (String disasterHostSn : disasterHostSns) {
            KEYLIST.forEach(key -> this.createLunNodeAndLinkToDisk(context, po, "Disaster:" + key, disasterHostSn));
            this.linkRedoLunAndDisk(context, disasterHostSn, usedStorageInfo);
        }
    }

    private ProtectObjectStorageInfo getUsedStorageInfo(ProtectObject po, Set<String> hostSns) {
        Map<String, ProtectObjectStorageInfo> snAndInfoMap = po.getUsedStorageResourceSet().stream().collect(Collectors.toMap(ProtectObjectStorageInfo::getHostSN, protectObjectStorageInfo -> protectObjectStorageInfo));
        for (String hostSn : hostSns) {
            if (!snAndInfoMap.containsKey(hostSn)) continue;
            return snAndInfoMap.get(hostSn);
        }
        LOGGER.error((Object)"Not find storage info.");
        throw new LegoCheckedException(2117645L);
    }

    private void linkRedoLunAndDisk(TopoBaseContext context, String hostSn, ProtectObjectStorageInfo info) {
        String mountNodeId = hostSn + ":" + info.getDeviceName();
        Node lunNode = this.createLunNode(context, info.getResourceProviderSN(), info.getResourceId());
        Node mountNode = (Node)CastUtil.castTo((Object)context.getElementBox().getElementByID((Object)mountNodeId), Node.class);
        context.linkTo(lunNode, mountNode, new Skin[0]);
    }

    private void createLunNodeAndLinkToDisk(TopoBaseContext context, ProtectObject po, String key, String hostSn) {
        Map props = po.getProps();
        String json = (String)props.get(key);
        JSONArray array = JSONArray.fromObject((Object)json);
        List poStorageInfos = JSONArray.toCollection((JSONArray)array, ProtectObjectStorageInfo.class);
        for (ProtectObjectStorageInfo poStorageInfo : poStorageInfos) {
            if (VerifyUtil.isEmpty((String)poStorageInfo.getId())) continue;
            Node lunNode = this.createLunNode(context, poStorageInfo.getResourceProviderSN(), poStorageInfo.getResourceId());
            IElement storageNode = context.getElementBox().getElementByID((Object)(poStorageInfo.getResourceProviderSN() + ":storage"));
            context.addChild((IData)storageNode, (IData)lunNode);
            String mountNodeId = hostSn + ":" + poStorageInfo.getDeviceName();
            Node mountNode = (Node)CastUtil.castTo((Object)context.getElementBox().getElementByID((Object)mountNodeId), Node.class);
            context.linkTo(lunNode, mountNode, new Skin[0]);
        }
    }

    private Node createLunNode(TopoBaseContext context, String sn, String id) {
        IElement lunNode = context.getElementBox().getElementByID((Object)(sn + id));
        if (VerifyUtil.isEmpty((Object)lunNode)) {
            Lun lun = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getLunBySnAndLunId(sn, id);
            return new LunElement((Object)(sn + id), lun);
        }
        return (Node)CastUtil.castTo((Object)lunNode, Node.class);
    }
}

