/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import io.fabric8.kubernetes.client.utils.Serialization;
import org.springframework.stereotype.Component;

@Component
public class KubeSerializeInitializer
implements SystemStatusChangedListener {
    private static final Log LOGGER = LogFactory.getInstance(KubeSerializeInitializer.class);

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getStatus() == Status.STATUS_INIT) {
            LOGGER.info((Object)"Execute the kube serialize initializer");
            ObjectMapper objectMapper = Serialization.jsonMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        }
    }
}

