/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.protection.refresh;

import com.huawei.ism.drm.kube.model.CheckDomainChangedResult;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.kube.sdk.model.Domain;
import com.huawei.ism.drm.kube.sdk.model.KubeProtectionPlan;
import com.huawei.ism.drm.kube.sdk.model.constants.KubeEnumDefine;
import com.huawei.ism.drm.kube.service.KubeHyperMetroProtectGroupRefreshWatcher;
import com.huawei.ism.drm.kube.util.KubeUtil;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import io.fabric8.kubernetes.client.Watch;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

@Service(name="com.huawei.ism.drm.kube.service.IKubeHyperMetroProtectGroupRefreshWatcher", desc="", interfaceClass=KubeHyperMetroProtectGroupRefreshWatcher.class)
public class KubeHyperMetroProtectGroupRefreshWatcherImpl
extends BaseService
implements KubeHyperMetroProtectGroupRefreshWatcher,
SystemStatusChangedListener {
    private static final Log LOGGER = LogFactory.getInstance(KubeHyperMetroProtectGroupRefreshWatcherImpl.class);
    private static final Long ADMIN_USER_ID = 1L;
    private static final Map<String, Watch> WATCHER = new ConcurrentHashMap<String, Watch>();
    private static final LinkedBlockingQueue<String> WATCH_TASK = new LinkedBlockingQueue();
    private static final int SCHEDULE_DELAY = 5;
    private static final int SCHEDULE_INITIAL_DELAY = 10;
    private static final int WATCH_RETRY_TIMES = 5;
    private static final int WATCH_RETRY_DURATION = 1;
    private IKubeHandler kubeHandler;
    private IProtectGroupService protectGroupService;

    public void setProtectGroupService(IProtectGroupService protectGroupService) {
        this.protectGroupService = protectGroupService;
    }

    public void setKubeHandler(IKubeHandler kubeHandler) {
        this.kubeHandler = kubeHandler;
    }

    public void register(String protectGroupId, String domainName) {
        VerifyUtil.checkStrs((String[])new String[]{protectGroupId, domainName});
        if (WATCHER.containsKey(protectGroupId)) {
            LOGGER.warn((Object)"Current protectGroup has already registered, please don't register repetitively. protectGroupId: %s, domainName: %s", new Object[]{protectGroupId, domainName});
            return;
        }
        ProtectGroup protectGroup = this.protectGroupService.getProtectGroupByID(protectGroupId);
        if (protectGroup == null) {
            LOGGER.error((Object)"Current protectGroup ( %s ) is not present, could not register.", new Object[]{protectGroupId});
            return;
        }
        LOGGER.info((Object)"Start register hyper metro domain watcher. protectGroupId: %s, domainName: %s", new Object[]{protectGroupId, domainName});
        for (int retryTime = 0; retryTime < 5; ++retryTime) {
            Watch watcher = this.kubeHandler.watchHyperMetroDomain(protectGroup.getPoProviderSN(), domainName, (action, domain) -> {
                LOGGER.info((Object)"Watched hyper metro domain ( %s ) changed, action: ", new Object[]{domainName, action.name()});
                ProtectGroup currentProtectGroup = this.getProtectGroupIdByDomain(domain.getName());
                this.doRefresh(currentProtectGroup);
            });
            if (watcher != null) {
                WATCHER.put(protectGroupId, watcher);
                break;
            }
            if (retryTime == 4) {
                LOGGER.error((Object)"Register hyper metro domain watcher failed, cause watcher is empty after %s retries. domainName: %s", new Object[]{5, domainName});
                throw new LegoCheckedException(-1L);
            }
            CommonUtil.sleep((long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    private ProtectGroup getProtectGroupIdByDomain(String domainName) {
        List protectGroups = this.protectGroupService.getProtectGroupByType(21, ADMIN_USER_ID, true);
        for (ProtectGroup protectGroup : protectGroups) {
            if (!domainName.equals(protectGroup.getProperty("domainName"))) continue;
            return protectGroup;
        }
        LOGGER.error((Object)"Could not find ProtectGroup by domain ( %s )", new Object[]{domainName});
        throw new LegoCheckedException(1073947394L);
    }

    private boolean isProtectionPlanRebuilding(ProtectGroup protectGroup) {
        String planName = protectGroup.getProperty("kube_protection_plan");
        Optional protectionPlanOpt = this.kubeHandler.getProtectionPlan(protectGroup.getPoProviderSN(), planName);
        if (!protectionPlanOpt.isPresent()) {
            LOGGER.error((Object)"Protection plan ( %s ) is not present", new Object[]{planName});
            throw new LegoCheckedException(1073947394L);
        }
        KubeProtectionPlan kubeProtectionPlan = (KubeProtectionPlan)protectionPlanOpt.get();
        return KubeEnumDefine.CDRProtectGroupStatus.REBUILDING.equals((Object)kubeProtectionPlan.getStatus());
    }

    public void deregister(String protectGroupId) {
        LOGGER.info((Object)"Start deregister hyper metro domain watcher. protectGroupId: %s", new Object[]{protectGroupId});
        Watch cachedWatch = WATCHER.get(protectGroupId);
        if (cachedWatch != null) {
            cachedWatch.close();
            WATCHER.remove(protectGroupId);
        }
    }

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getStatus() == Status.STATUS_STARTED) {
            LOGGER.info((Object)"Initialize the kubernetes hyper metro protect group refresh watcher");
            List protectGroups = this.protectGroupService.getProtectGroupByType(21, ADMIN_USER_ID, true);
            for (ProtectGroup protectGroup : protectGroups) {
                String domainName = protectGroup.getProperty("domainName");
                if (StringUtils.isEmpty((CharSequence)domainName)) continue;
                this.register(protectGroup.getUuid(), domainName);
            }
            ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
            executor.scheduleWithFixedDelay(new ConsumeWatcherTask(), 10L, 5L, TimeUnit.SECONDS);
        }
    }

    private void doRefresh(ProtectGroup protectGroup) {
        if (ProtectionJobUtil.getInstance().isPgLocked(protectGroup.getUuid()) || this.isProtectionPlanRebuilding(protectGroup)) {
            LOGGER.warn((Object)"The PP ( %s ) of protect group ( %s )  is rebuilding, or the protect group  is locked. cancel refresh, put into queue", new Object[]{protectGroup.getProperty("kube_protection_plan"), protectGroup.getName()});
            this.addWatchTask(protectGroup.getUuid());
            return;
        }
        String domainName = protectGroup.getProperty("domainName");
        Optional opt = this.kubeHandler.getHyperMetroDomain(protectGroup.getPoProviderSN(), domainName);
        if (!opt.isPresent()) {
            LOGGER.warn((Object)"Refresh hyper metro protect group ( %s ) canceled, cause target domain( %s ) is not exist", new Object[]{protectGroup.getName(), domainName});
            return;
        }
        Domain domain = (Domain)opt.get();
        CheckDomainChangedResult changedResult = KubeUtil.checkDomainChange(protectGroup, domain);
        if (!changedResult.hasChanged()) {
            LOGGER.info((Object)"Refresh hyper metro protect group ( %s ) canceled, cause there's no volumes changed, domain :%s", new Object[]{protectGroup.getName(), domainName});
            return;
        }
        LOGGER.info((Object)"Start refresh ProtectGroup( %s )", new Object[]{protectGroup.getName()});
        this.protectGroupService.refreshProtectGroup(protectGroup.getUuid());
    }

    private void addWatchTask(String protectGroupId) {
        if (!WATCH_TASK.contains(protectGroupId)) {
            try {
                WATCH_TASK.put(protectGroupId);
            }
            catch (InterruptedException e) {
                throw new LegoCheckedException(0x300001L);
            }
        }
    }

    private String consumeWatchTask() {
        return WATCH_TASK.poll();
    }

    private class ConsumeWatcherTask
    implements Runnable {
        private ConsumeWatcherTask() {
        }

        @Override
        public void run() {
            try {
                String protectGroupId = KubeHyperMetroProtectGroupRefreshWatcherImpl.this.consumeWatchTask();
                if (StringUtils.isEmpty((CharSequence)protectGroupId)) {
                    return;
                }
                ProtectGroup protectGroup = KubeHyperMetroProtectGroupRefreshWatcherImpl.this.protectGroupService.getProtectGroupByID(protectGroupId);
                LOGGER.info((Object)"Start consume queue and try refresh protect group ( %s ).", new Object[]{protectGroup.getName()});
                KubeHyperMetroProtectGroupRefreshWatcherImpl.this.doRefresh(protectGroup);
            }
            catch (Throwable e) {
                LOGGER.error((Object)"Consume kube protect group watcher error.", e);
            }
        }
    }
}

