/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.protection.refresh;

import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.kube.model.CheckDomainChangedResult;
import com.huawei.ism.drm.kube.protection.task.RebuildHyperMetroProtectionPlanTask;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.kube.sdk.model.Domain;
import com.huawei.ism.drm.kube.sdk.model.KubeHyperMetroDomainBackend;
import com.huawei.ism.drm.kube.sdk.model.KubeHyperMetroDomainPvc;
import com.huawei.ism.drm.kube.sdk.model.KubeStorage;
import com.huawei.ism.drm.kube.sdk.model.KubeVolumeSet;
import com.huawei.ism.drm.kube.sdk.model.MetadataPairInfo;
import com.huawei.ism.drm.kube.sdk.model.PersistentVolumeClaimInfo;
import com.huawei.ism.drm.kube.sdk.model.StorageClassInfo;
import com.huawei.ism.drm.kube.sdk.model.bo.NamespaceBO;
import com.huawei.ism.drm.kube.sdk.model.constants.KubeEnumDefine;
import com.huawei.ism.drm.kube.sdk.utils.KubeCommonUtils;
import com.huawei.ism.drm.kube.service.KubeRefreshHyperMetroProtectGroupService;
import com.huawei.ism.drm.kube.util.KubeUtil;
import com.huawei.ism.drm.license.sdk.ILicenseControl;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

@Service(name="com.huawei.ism.drm.kube.service.KubeRefreshHyperMetroProtectGroupService", desc="", interfaceClass=KubeRefreshHyperMetroProtectGroupService.class)
public class KubeRefreshHyperMetroProtectGroupServiceImpl
extends BaseService
implements KubeRefreshHyperMetroProtectGroupService {
    private static final Log LOGGER = LogFactory.getInstance(KubeRefreshHyperMetroProtectGroupServiceImpl.class);
    private static final int WAIT_TARGET_PVC_TIME_OUT = 20;
    private static final int WAIT_TARGET_PVC_DURATION = 1;
    private static final int WAIT_HYPER_METRO_DOMAIN_DURATION = 5;
    private IKubeHandler kubeHandler;
    private IProtectGroupService protectGroupService;

    public void setKubeHandler(IKubeHandler kubeHandler) {
        this.kubeHandler = kubeHandler;
    }

    public void setProtectGroupService(IProtectGroupService protectGroupService) {
        this.protectGroupService = protectGroupService;
    }

    public void refreshHyperMetroProtectGroup(ProtectGroup protectGroup) {
        LOGGER.info((Object)"Start refresh hyper metro protect group ( %s )", new Object[]{protectGroup.getName()});
        String domainName = protectGroup.getProperty("domainName");
        if (VerifyUtil.isEmpty((String)domainName)) {
            LOGGER.error((Object)"Hyper metro domain name is empty, could not refresh, it seems that protect group ( %s ) is not hyper metro type", new Object[]{protectGroup.getName()});
            return;
        }
        CommonUtil.sleep((long)5L, (TimeUnit)TimeUnit.SECONDS);
        Optional hyperMetroDomain = this.kubeHandler.getHyperMetroDomain(protectGroup.getPoProviderSN(), domainName);
        if (!hyperMetroDomain.isPresent()) {
            LOGGER.error((Object)"Hyper metro domain ( %s ) is not exist, could not refresh", new Object[]{domainName});
            throw new LegoCheckedException(2117645L);
        }
        this.refreshHyperMetroProtectGroup(protectGroup, (Domain)hyperMetroDomain.get());
    }

    public void refreshHyperMetroProtectGroup(ProtectGroup protectGroup, Domain domain) {
        LOGGER.info((Object)"Start refresh hyper metro protect group ( %s ), domian :%s", new Object[]{protectGroup.getName(), domain.getName()});
        this.checkRefreshAvailable(protectGroup);
        CheckDomainChangedResult changedResult = KubeUtil.checkDomainChange(protectGroup, domain);
        if (!changedResult.hasChanged()) {
            LOGGER.info((Object)"Refresh hyper metro protect group ( %s ) canceled, cause there's no volumes changed, domain :%s", new Object[]{protectGroup.getName(), domain.getName()});
            this.rebuildProductionProtectionPlan(protectGroup);
            return;
        }
        this.checkLicenseCapacity(changedResult.getChangedCapacity());
        List<MetadataPairInfo> newVolumePairs = this.getUpdatedVolumePairs(protectGroup, changedResult);
        Schedule schedule = (Schedule)protectGroup.getTemplate().getSchedules().iterator().next();
        KubeVolumeSet volumeSet = this.kubeHandler.getVolumeSet(protectGroup.getPoProviderSN(), protectGroup.getProperty("kube_volume_set_name"));
        volumeSet.setVolumePairs(newVolumePairs);
        this.kubeHandler.rebuildVolumeSet(schedule.getSourceSn(), volumeSet);
        volumeSet.setRoleType(KubeEnumDefine.RoleType.RECOVERY);
        this.kubeHandler.rebuildVolumeSet(schedule.getTargetSn(), volumeSet);
        this.updateProtectObjects(protectGroup, domain, changedResult);
        this.rebuildProductionProtectionPlan(protectGroup);
    }

    private void checkLicenseCapacity(double changedCapacity) {
        ILicenseControl licenseControl = (ILicenseControl)ServiceLocator.getInstance().getService(ILicenseControl.class);
        licenseControl.checkLicenseEnableWithCapacity("BOMBCMREPSWTB", new Double(changedCapacity).intValue());
    }

    private void checkRefreshAvailable(ProtectGroup protectGroup) {
        Schedule schedule = (Schedule)protectGroup.getTemplate().getSchedules().iterator().next();
        this.kubeHandler.checkClusterStatus(schedule.getSourceSn());
        this.kubeHandler.checkClusterStatus(schedule.getTargetSn());
        String protectionPlanName = protectGroup.getProperty("kube_protection_plan");
        this.checkProtectionPlanExist(schedule.getSourceSn(), protectionPlanName);
        this.checkProtectionPlanExist(schedule.getTargetSn(), protectionPlanName);
        String domainName = protectGroup.getProperty("domainName");
        String domainIp = protectGroup.getProperty("domainIp");
        KubeUtil.checkHyperMetroDomainNormal(schedule.getSourceSn(), domainName, domainIp);
        KubeUtil.checkHyperMetroDomainNormal(schedule.getTargetSn(), domainName, domainIp);
    }

    private void checkProtectionPlanExist(String kubeSn, String protectionPlanName) {
        Optional protectionPlan = this.kubeHandler.getProtectionPlan(kubeSn, protectionPlanName);
        if (!protectionPlan.isPresent()) {
            LOGGER.error((Object)"Refresh protect group failed, cause the protection plan %s is not exist", new Object[]{protectionPlanName});
            throw new LegoCheckedException(1073947394L);
        }
    }

    private List<MetadataPairInfo> getUpdatedVolumePairs(ProtectGroup protectGroup, CheckDomainChangedResult changedResult) {
        String volumeSetName = protectGroup.getProperty("kube_volume_set_name");
        KubeVolumeSet volumeSet = this.kubeHandler.getVolumeSet(protectGroup.getPoProviderSN(), volumeSetName);
        List volumePairs = volumeSet.getVolumePairs();
        ArrayList<MetadataPairInfo> newVolumePairs = new ArrayList<MetadataPairInfo>(volumePairs);
        this.checkAddedPvcList(protectGroup, changedResult.getAddedPvcs(), newVolumePairs);
        this.checkRemovedPvcList(protectGroup, changedResult.getRemovedPvcs(), newVolumePairs);
        return newVolumePairs;
    }

    private void rebuildProductionProtectionPlan(ProtectGroup protectGroup) {
        String protectionPlanName = protectGroup.getProperty("kube_protection_plan");
        String[] params = new String[]{protectionPlanName, protectGroup.getName(), protectGroup.getName()};
        AlarmReporter.restoreAlarm((String)"0x3230087", (String[])params);
        ExecutionService.submit((Runnable)new RebuildHyperMetroProtectionPlanTask(protectGroup));
    }

    private void updateProtectObjects(ProtectGroup protectGroup, Domain domain, CheckDomainChangedResult changedResult) {
        Set latestProtectObjects = protectGroup.getPolist();
        List backends = domain.getBackends();
        for (KubeHyperMetroDomainBackend backend : backends) {
            List pvcList = backend.getPvcList();
            if (VerifyUtil.isEmpty((Collection)pvcList)) continue;
            for (KubeHyperMetroDomainPvc pvc : pvcList) {
                if ("xuanwu".equals(pvc.getNamespace()) || this.isProtectObjectAlreadyExist(latestProtectObjects, pvc)) continue;
                PersistentVolumeClaimInfo productionPvc = (PersistentVolumeClaimInfo)this.kubeHandler.getPersistentVolumeClaimInfo(protectGroup.getPoProviderSN(), pvc.getPvcName(), pvc.getNamespace()).orElseThrow(() -> new LegoCheckedException(2117645L));
                ProtectObject protectObject = KubeCommonUtils.transHyperMetroProtectObject((String)protectGroup.getPoProviderSN(), (Domain)domain, (String)backend.getName(), (PersistentVolumeClaimInfo)productionPvc);
                protectObject.setUuid(UUIDGenerator.getUUID());
                protectObject.setProtectGroup(protectGroup);
                Schedule schedule = (Schedule)protectGroup.getTemplate().getSchedules().iterator().next();
                PersistentVolumeClaimInfo targetPvc = (PersistentVolumeClaimInfo)this.kubeHandler.getPersistentVolumeClaimInfo(schedule.getTargetSn(), pvc.getPvcName(), pvc.getNamespace()).get();
                protectObject.setProperty("kube_remote_persistent_volume", (Object)targetPvc.getVolumeName());
                Optional pvOpt = this.kubeHandler.getKubePersistentVolume(protectGroup.getPoProviderSN(), pvc.getPvName());
                pvOpt.ifPresent(kubePersistentVolume -> protectObject.setProperty("capacity", (Object)String.valueOf(kubePersistentVolume.getCapacity())));
                latestProtectObjects.add(protectObject);
            }
        }
        List<MetadataPairInfo> removedPvcs = changedResult.getRemovedPvcs();
        latestProtectObjects.removeIf(po -> this.isProtectObjectRemoved(removedPvcs, (ProtectObject)po));
    }

    private boolean isProtectObjectAlreadyExist(Set<ProtectObject> latestProtectObject, KubeHyperMetroDomainPvc pvc) {
        return latestProtectObject.stream().anyMatch(po -> StringUtils.equals((CharSequence)po.getName(), (CharSequence)pvc.getPvcName()) && StringUtils.equals((CharSequence)po.getProperty("namespace"), (CharSequence)pvc.getNamespace()));
    }

    private boolean isProtectObjectRemoved(List<MetadataPairInfo> removedNamesPvcs, ProtectObject po) {
        return removedNamesPvcs.stream().anyMatch(pair -> {
            String[] namespaceAndName = pair.getPvcMeta().split("/");
            return StringUtils.equals((CharSequence)namespaceAndName[0], (CharSequence)po.getProperty("namespace")) && StringUtils.equals((CharSequence)namespaceAndName[1], (CharSequence)po.getName());
        });
    }

    private void checkAddedPvcList(ProtectGroup protectGroup, List<KubeHyperMetroDomainPvc> addedPvcs, List<MetadataPairInfo> newVolumePairs) {
        for (KubeHyperMetroDomainPvc domainPvc : addedPvcs) {
            Optional productionPvcOpt = this.kubeHandler.getPersistentVolumeClaimInfo(protectGroup.getPoProviderSN(), domainPvc.getPvcName(), domainPvc.getNamespace());
            if (!productionPvcOpt.isPresent()) {
                LOGGER.error((Object)"Production PVC ( %s ) in namespace( %s ) is not exist, could not create target PVC", new Object[]{domainPvc.getPvcName(), domainPvc.getNamespace()});
                throw new LegoCheckedException(1073947394L);
            }
            PersistentVolumeClaimInfo productionPvc = (PersistentVolumeClaimInfo)productionPvcOpt.get();
            Optional<PersistentVolumeClaimInfo> targetPvcOpt = this.createTargetPvc(protectGroup, productionPvc);
            if (!targetPvcOpt.isPresent()) continue;
            MetadataPairInfo addedPair = new MetadataPairInfo();
            addedPair.setPvcMeta(productionPvc.getNameSpace() + "/" + productionPvc.getName());
            addedPair.setPrimaryPVName(productionPvc.getFileSystemName());
            addedPair.setSecondaryPVName(productionPvc.getFileSystemName());
            newVolumePairs.add(addedPair);
        }
    }

    private void checkRemovedPvcList(ProtectGroup protectGroup, List<MetadataPairInfo> removedPvcs, List<MetadataPairInfo> newVolumePairs) {
        for (MetadataPairInfo pair : removedPvcs) {
            Schedule schedule = (Schedule)protectGroup.getTemplate().getSchedules().iterator().next();
            this.deleteTargetPvc(schedule.getTargetSn(), pair);
            newVolumePairs.removeIf(e -> StringUtils.equals((CharSequence)e.getPrimaryPVName(), (CharSequence)pair.getPrimaryPVName()) && StringUtils.equals((CharSequence)e.getSecondaryPVName(), (CharSequence)pair.getSecondaryPVName()));
        }
    }

    private void deleteTargetPvc(String targetSn, MetadataPairInfo pair) {
        String pvcMeta = pair.getPvcMeta();
        String[] pvcNameAndNamespace = pvcMeta.split("/");
        PersistentVolumeClaimInfo pvc = new PersistentVolumeClaimInfo();
        pvc.setName(pvcNameAndNamespace[1]);
        pvc.setNameSpace(pvcNameAndNamespace[0]);
        this.kubeHandler.deletePersistentVolumeClaim(targetSn, Collections.singletonList(pvc));
    }

    private Optional<PersistentVolumeClaimInfo> createTargetPvc(ProtectGroup protectGroup, PersistentVolumeClaimInfo productionPvc) {
        Schedule schedule = (Schedule)protectGroup.getTemplate().getSchedules().iterator().next();
        String targetSn = schedule.getTargetSn();
        Optional targetPvcOpt = this.kubeHandler.getPersistentVolumeClaimInfo(targetSn, productionPvc.getName(), productionPvc.getNameSpace());
        if (targetPvcOpt.isPresent()) {
            return targetPvcOpt;
        }
        Optional productionStorageClassOpt = this.kubeHandler.getStorageClassByName(protectGroup.getPoProviderSN(), productionPvc.getStorageClassName());
        if (!productionStorageClassOpt.isPresent()) {
            LOGGER.error((Object)"Production StorageClass ( %s ) is not exist, could not create target PVC", new Object[]{productionPvc.getStorageClassName()});
            throw new LegoCheckedException(1073947394L);
        }
        StorageClassInfo productionStorageClass = (StorageClassInfo)productionStorageClassOpt.get();
        this.createTargetStorageClass(protectGroup, targetSn, productionStorageClass);
        this.createTargetNamespace(targetSn, productionPvc.getNameSpace());
        this.createPersistentVolumeClaim(schedule.getSourceSn(), targetSn, productionPvc);
        return this.kubeHandler.getPersistentVolumeClaimInfo(targetSn, productionPvc.getName(), productionPvc.getNameSpace());
    }

    private void createTargetNamespace(String targetSn, String nameSpaceName) {
        Optional namespaceOpt = this.kubeHandler.getNamespace(targetSn, nameSpaceName);
        if (namespaceOpt.isPresent()) {
            return;
        }
        NamespaceBO namespace = new NamespaceBO();
        namespace.setName(nameSpaceName);
        LOGGER.info((Object)"Start create target namespace ( %s )", new Object[]{nameSpaceName});
        this.kubeHandler.createNamespace(targetSn, namespace);
    }

    private void createPersistentVolumeClaim(String sourceSn, String targetSn, PersistentVolumeClaimInfo productionPvc) {
        KubeUtil.buildHyperMetroPvcFileSystem(sourceSn, productionPvc);
        this.kubeHandler.createPersistentVolumeClaim(targetSn, productionPvc);
        long startTime = System.currentTimeMillis();
        PersistentVolumeClaimInfo targetPvc;
        Optional targetPvcOpt;
        while (!(targetPvcOpt = this.kubeHandler.getPersistentVolumeClaimInfo(targetSn, productionPvc.getName(), productionPvc.getNameSpace())).isPresent() || !"Bound".equals((targetPvc = (PersistentVolumeClaimInfo)targetPvcOpt.get()).getStatus())) {
            if (System.currentTimeMillis() - startTime > TimeUnit.MINUTES.toMillis(20L)) {
                LOGGER.error((Object)"Wait for target PVC Bound timeout");
                throw new LegoCheckedException(1073947433L);
            }
            CommonUtil.sleep((long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        return;
    }

    private void createTargetStorageClass(ProtectGroup protectGroup, String targetSn, StorageClassInfo productionStorageClass) {
        Optional disasterStorageClassOptional = this.kubeHandler.getStorageClassByName(targetSn, productionStorageClass.getName());
        if (disasterStorageClassOptional.isPresent()) {
            KubeUtil.checkHyperMetroStorageClass(protectGroup, productionStorageClass, (StorageClassInfo)disasterStorageClassOptional.get());
            return;
        }
        ProtectObject protectObject = (ProtectObject)protectGroup.getPolist().iterator().next();
        String sourceBackend = protectObject.getProperty("storageBackend");
        Optional<KubeStorage> targetSbcOptional = KubeUtil.matchHyperMetroBackend(protectGroup.getPoProviderSN(), targetSn, sourceBackend);
        if (!targetSbcOptional.isPresent()) {
            LOGGER.error((Object)"Could not find remote backend by source backend %s", new Object[]{sourceBackend});
            throw new LegoCheckedException(1073947393L);
        }
        productionStorageClass.getParameters().put("backend", targetSbcOptional.get().getName());
        this.kubeHandler.createStorageClass(targetSn, productionStorageClass);
    }
}

