/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.protection.replica.builder;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.kube.protection.replica.builder.BaseResourceSetBackupBuilder;
import com.huawei.ism.drm.kube.protection.replica.builder.KubeBuilderUtil;
import com.huawei.ism.drm.kube.protection.replica.builder.task.BackupLocationRollBackTask;
import com.huawei.ism.drm.kube.protection.replica.builder.task.ResourceRollBackTask;
import com.huawei.ism.drm.kube.protection.replica.builder.task.SchedulePolicyRollBackTask;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.kube.sdk.model.AbstractKubeBackupModel;
import com.huawei.ism.drm.kube.sdk.model.BackupInstanceInfo;
import com.huawei.ism.drm.kube.sdk.model.BackupLocationInfo;
import com.huawei.ism.drm.kube.sdk.model.KubePersistentVolume;
import com.huawei.ism.drm.kube.sdk.model.KubeResourceSetPVC;
import com.huawei.ism.drm.kube.sdk.model.KubeSchedulePolicy;
import com.huawei.ism.drm.kube.sdk.model.PodResource;
import com.huawei.ism.drm.kube.sdk.model.ResourceSetInfo;
import com.huawei.ism.drm.kube.sdk.model.constants.KubeEnumDefine;
import com.huawei.ism.drm.kube.sdk.model.enums.KubeBackTaskProcessDefine;
import com.huawei.ism.drm.kube.sdk.utils.KubeResourceNameGenerator;
import com.huawei.ism.drm.kube.service.IKubeService;
import com.huawei.ism.drm.kube.util.KubeUtil;
import com.huawei.ism.drm.protection.framework.service.group.context.CreateProtectGroupContext;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.schedule.sdk.model.ReplicationSpeedPolicy;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.lego.cbb.resource.rollback.DefaultResourceRollbackTask;
import com.huawei.lego.cbb.resource.rollback.IRollbackItem;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;

public abstract class AbstractResourceBackupInstanceBuilder {
    private static final Log LOGGER = LogFactory.getInstance(BaseResourceSetBackupBuilder.class);
    private static final int MONITOR_BACKUP_INSTANCE_DURATION = 5;
    protected final IKubeHandler iKubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
    private final DefaultResourceRollbackTask rollbackTask = new DefaultResourceRollbackTask();
    private Map<String, String> extParameters;

    protected abstract Optional<BackupLocationInfo> createBackupLocation(ProtectGroup var1);

    protected boolean isContainsExtParameter(String paramKey) {
        return this.extParameters.containsKey(paramKey);
    }

    protected String getExtParameter(String paramKey) {
        return this.getExtParameter(paramKey, false);
    }

    protected String getExtParameter(String paramKey, boolean isNecessary) {
        String extParameter = this.extParameters.get(paramKey);
        if (isNecessary && VerifyUtil.isEmpty((String)extParameter)) {
            LOGGER.error((Object)"Create kubernetes backup protection group failed, cause the parameter [ %s ] is necessary", new Object[]{paramKey});
            throw new LegoCheckedException(1073947393L);
        }
        return extParameter;
    }

    protected Optional<String> getSourceStorageBackend(String kubeSn, ProtectObject protectObject) {
        String resourceDetailName = (String)protectObject.getProps().get("resourceDetailName");
        List pvcList = this.iKubeHandler.getResourceSetPVCs(kubeSn, resourceDetailName);
        for (KubeResourceSetPVC pvc : pvcList) {
            KubePersistentVolume pv = pvc.getKubePV();
            if (!"csi.huawei.com".equals(pv.getDriver())) continue;
            return Optional.of("huawei-csi/" + pv.getBackend());
        }
        return Optional.empty();
    }

    protected String getTargetBackendName() {
        return "huawei-csi/" + this.getExtParameter("kubeTargetStorage", true);
    }

    public void createBackupInstance(ProtectGroup protectGroup) {
        KubeUtil.checkParam(protectGroup);
        this.checkResourceSet(protectGroup.getPoProviderSN(), ((ProtectObject)protectGroup.getPolist().iterator().next()).getName());
        this.initExtParameters(protectGroup);
        String kubeSn = protectGroup.getPoProviderSN();
        try {
            Optional<BackupLocationInfo> locationInfoOptional = this.createBackupLocation(protectGroup);
            BackupLocationInfo locationInfo = null;
            if (locationInfoOptional.isPresent()) {
                locationInfo = locationInfoOptional.get();
                protectGroup.getProps().put("kube_backup_location", locationInfo.getName());
                this.rollbackTask.addItem((IRollbackItem)new BackupLocationRollBackTask(kubeSn, locationInfoOptional.get()));
            }
            CreateProtectGroupContext.updateProgress((int)KubeBackTaskProcessDefine.CreateBackupProtectGroup.CREATE_BACKUP_LOCATION.getProgress());
            List<KubeSchedulePolicy> policies = this.createPolicy(protectGroup);
            if (!VerifyUtil.isEmpty(policies)) {
                protectGroup.getProps().put("kube_policy", policies.stream().map(AbstractKubeBackupModel::getName).collect(Collectors.toList()).toString());
                for (KubeSchedulePolicy policy : policies) {
                    this.rollbackTask.addItem((IRollbackItem)new SchedulePolicyRollBackTask(protectGroup.getPoProviderSN(), policy));
                }
            }
            CreateProtectGroupContext.updateProgress((int)KubeBackTaskProcessDefine.CreateBackupProtectGroup.CREATE_BACKUP_POLICY.getProgress());
            BackupInstanceInfo backupInstance = this.createInstance(protectGroup, locationInfo, policies);
            this.rollbackTask.addItem((IRollbackItem)new ResourceRollBackTask(protectGroup.getPoProviderSN(), backupInstance.getName(), KubeEnumDefine.RollBackType.BACKUP_INSTANCE));
            CreateProtectGroupContext.updateProgress((int)KubeBackTaskProcessDefine.CreateBackupProtectGroup.CREATE_BACKUP_INSTANCE.getProgress());
            this.monitorBackupInstanceStatus(protectGroup.getPoProviderSN(), backupInstance.getName());
            CreateProtectGroupContext.updateProgress((int)KubeBackTaskProcessDefine.CreateBackupProtectGroup.CHECK_BACKUP_INSTANCE.getProgress());
            protectGroup.getProps().put("kube_backup_instance", backupInstance.getName());
            Map poProps = ((ProtectObject)protectGroup.getPolist().iterator().next()).getProps();
            if (!VerifyUtil.isEmpty((Map)poProps) && poProps.containsKey("namespace")) {
                protectGroup.getProps().put("namespace", poProps.get("namespace"));
            }
            String sourceIp = KubeUtil.getKubernetes(protectGroup.getPoProviderSN()).getIpAddress();
            protectGroup.getProps().put("sourceKubeClusterIp", sourceIp);
        }
        catch (LegoCheckedException exception) {
            LOGGER.error((Object)"Create backup instance failed. error:%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)exception)});
            this.rollbackTask.execute();
            throw exception;
        }
    }

    private void checkResourceSet(String sn, String resourceSetName) {
        this.checkAndGetResourceSetInfo(sn, resourceSetName);
        IKubeService kubeService = (IKubeService)ServiceLocator.getInstance().getService(IKubeService.class);
        this.iKubeHandler.refreshKubeResourceSet(sn, resourceSetName, arg_0 -> ((IKubeService)kubeService).saveOrUpdateResourceSet(arg_0));
        ResourceSetInfo resourceSet = this.checkAndGetResourceSetInfo(sn, resourceSetName);
        List resources = JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)resourceSet.getProtectResources()), PodResource.class);
        if (VerifyUtil.isEmpty((Collection)resources)) {
            LOGGER.error((Object)"Create backup instance failed, could not find any resource in target resource set (%s).", new Object[]{resourceSetName});
            throw new LegoCheckedException(2117645L);
        }
    }

    private ResourceSetInfo checkAndGetResourceSetInfo(String sn, String resourceSetName) {
        Optional optional = this.iKubeHandler.getResourceSetInfo(sn, resourceSetName);
        if (!optional.isPresent()) {
            LOGGER.error((Object)"Create backup instance failed, cause target resource set (%s) is not exist.", new Object[]{resourceSetName});
            throw new LegoCheckedException(2117645L);
        }
        return (ResourceSetInfo)optional.get();
    }

    private void initExtParameters(ProtectGroup protectGroup) {
        Schedule schedule = (Schedule)protectGroup.getTemplate().getSchedules().iterator().next();
        this.extParameters = schedule.getExtParameters();
    }

    private List<KubeSchedulePolicy> createPolicy(ProtectGroup protectGroup) {
        Set scheduleSet = protectGroup.getTemplate().getSchedules();
        String kubeSn = protectGroup.getPoProviderSN();
        ArrayList policies = Lists.newArrayList();
        for (Schedule schedule : scheduleSet) {
            if (schedule.getScheduleMode() == 1) continue;
            KubeSchedulePolicy policy = KubeBuilderUtil.buildSchedulePolicy(schedule);
            this.iKubeHandler.createKubeSchedulePolicy(kubeSn, policy);
            this.rollbackTask.addItem((IRollbackItem)new SchedulePolicyRollBackTask(kubeSn, policy));
            policies.add(policy);
        }
        return policies;
    }

    private BackupInstanceInfo createInstance(ProtectGroup protectGroup, BackupLocationInfo locationInfo, List<KubeSchedulePolicy> policies) {
        Schedule schedule;
        List speedPolicies;
        BackupInstanceInfo backupInstance = new BackupInstanceInfo();
        backupInstance.setName(KubeResourceNameGenerator.generate());
        backupInstance.setBackupPolicyNames(policies.stream().map(AbstractKubeBackupModel::getName).collect(Collectors.toList()));
        backupInstance.setMetadataBackupLocation("metadata-backup-location");
        Optional.ofNullable(locationInfo).ifPresent(location -> backupInstance.setVolumeBackupLocation(location.getName()));
        backupInstance.setResourceSetName(((ProtectObject)protectGroup.getPolist().iterator().next()).getName());
        if (this.isContainsExtParameter("preHook")) {
            backupInstance.setPreHookName(this.getExtParameter("preHook"));
        }
        if (this.isContainsExtParameter("postHook")) {
            backupInstance.setPostHookName(this.getExtParameter("postHook"));
        }
        if (!VerifyUtil.isEmpty((Collection)(speedPolicies = (schedule = (Schedule)protectGroup.getTemplate().getSchedules().iterator().next()).getReplicationSpeedPolicies()))) {
            backupInstance.setBackupSpeed(((ReplicationSpeedPolicy)speedPolicies.get(0)).getSyncRateLevel());
        }
        backupInstance.setEnableConsistentSnapshot(schedule.isAppConsistent().booleanValue());
        return this.iKubeHandler.createBackupInstance(protectGroup.getPoProviderSN(), backupInstance);
    }

    private void monitorBackupInstanceStatus(String kubeSn, String backupInstanceName) {
        BackupInstanceInfo instance;
        long startTime = System.currentTimeMillis();
        do {
            CommonUtil.sleep((long)5L, (TimeUnit)TimeUnit.SECONDS);
            instance = this.iKubeHandler.getBackupInstanceInfo(kubeSn, backupInstanceName);
            if (!KubeEnumDefine.BackupInstanceStatus.NORMAL.getValue().equals(instance.getStatus())) continue;
            LOGGER.info((Object)"Create backup instance (%s) succeed on kube cluster (%s)", new Object[]{backupInstanceName, kubeSn});
            return;
        } while (System.currentTimeMillis() - startTime <= TimeUnit.MINUTES.toMillis(5L));
        throw new LegoCheckedException(1073947754L, new String[]{instance.getName(), instance.getStatus()});
    }
}

