/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.protection.replica.builder;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.kube.protection.replica.builder.IReplicationBuilder;
import com.huawei.ism.drm.kube.protection.replica.builder.KubeBuilderUtil;
import com.huawei.ism.drm.kube.protection.replica.builder.task.ClusterRollBackTask;
import com.huawei.ism.drm.kube.protection.replica.builder.task.ProtectionPlanRollbackTask;
import com.huawei.ism.drm.kube.protection.replica.builder.task.ResourceRollBackTask;
import com.huawei.ism.drm.kube.protection.replica.builder.task.SchedulePolicyRollBackTask;
import com.huawei.ism.drm.kube.protection.replica.monitor.MonitorProtectionPlanTask;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.kube.sdk.model.ClusterInfo;
import com.huawei.ism.drm.kube.sdk.model.KubeProtectionPlan;
import com.huawei.ism.drm.kube.sdk.model.KubeSchedulePolicy;
import com.huawei.ism.drm.kube.sdk.model.KubeStorage;
import com.huawei.ism.drm.kube.sdk.model.KubeVolumeSet;
import com.huawei.ism.drm.kube.sdk.model.Kubernetes;
import com.huawei.ism.drm.kube.sdk.model.MetadataPairInfo;
import com.huawei.ism.drm.kube.sdk.model.PersistentVolumeClaimInfo;
import com.huawei.ism.drm.kube.sdk.model.ResourceSetInfo;
import com.huawei.ism.drm.kube.sdk.model.StorageClassInfo;
import com.huawei.ism.drm.kube.sdk.model.bo.NamespaceBO;
import com.huawei.ism.drm.kube.sdk.model.constants.KubeEnumDefine;
import com.huawei.ism.drm.kube.sdk.utils.KubeCommonUtils;
import com.huawei.ism.drm.kube.sdk.utils.KubeResourceNameGenerator;
import com.huawei.ism.drm.kube.service.IKubeService;
import com.huawei.ism.drm.kube.util.KubeUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.schedule.sdk.model.ReplicationSpeedPolicy;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.cbb.resource.rollback.DefaultResourceRollbackTask;
import com.huawei.lego.cbb.resource.rollback.IRollbackItem;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;

public abstract class BaseDisasterProtectionHandler {
    private static final Log LOGGER = LogFactory.getInstance(BaseDisasterProtectionHandler.class);
    protected static final long VOLUME_SET_WAIT_TIME = 6000L;
    private static final long QUERY_TARGET_PVC_DURATION = 1000L;
    protected final DefaultResourceRollbackTask rollbackTask = new DefaultResourceRollbackTask();
    protected final IKubeHandler iKubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);

    public abstract void createKubeProtectPlan(ProtectGroup var1);

    protected abstract IReplicationBuilder getBuilder();

    protected void postCreateProtectPlan(ProtectGroup protectGroup, KubeProtectionPlan protectionPlan) {
        LOGGER.info((Object)"Execute default postCreateProtectPlan, nothing to do");
    }

    protected void postCreateTargetPVC(String devSn, PersistentVolumeClaimInfo pvc, ProtectGroup protectGroup) {
        LOGGER.info((Object)"Execute default postCreateTargetPVC, nothing to do");
    }

    protected void postCreateTargetMetaPVC(String sourceSn, PersistentVolumeClaimInfo pvc) {
        LOGGER.info((Object)"Execute default postCreateTargetMetaPVC, nothing to do");
    }

    protected void createVolumeSet(ProtectGroup protectGroup, String targetSn) {
        String name = KubeResourceNameGenerator.generate();
        KubeVolumeSet volumeSet = new KubeVolumeSet();
        volumeSet.setName(name);
        CommUtil.pauseThread((long)6000L);
        MetadataPairInfo pairInfo = this.getMetadataPairInfo(protectGroup, targetSn);
        volumeSet.setMetadataPairInfo(pairInfo);
        List<PersistentVolumeClaimInfo> pvcInfoList = this.getBuilder().getPVC(protectGroup);
        String providerSn = protectGroup.getPoProviderSN();
        List pairInfoList = pvcInfoList.stream().map(item -> this.transToVolumePair((PersistentVolumeClaimInfo)item, providerSn, targetSn)).collect(Collectors.toList());
        volumeSet.setVolumePairs(pairInfoList);
        volumeSet.setRoleType(KubeEnumDefine.RoleType.PROTECTED);
        LOGGER.info((Object)"Begin to create VolumeSet for name: %s", new Object[]{name});
        this.createVolumeSet(protectGroup, volumeSet, providerSn);
        volumeSet.setRoleType(KubeEnumDefine.RoleType.RECOVERY);
        this.createVolumeSet(protectGroup, volumeSet, targetSn);
        LOGGER.info((Object)"Create VolumeSet success for name: %s", new Object[]{name});
        protectGroup.setProperty("kube_volume_set_name", (Object)volumeSet.getName());
    }

    private void createVolumeSet(ProtectGroup protectGroup, KubeVolumeSet volumeSet, String kubeSn) {
        if (this.isReprotectBuildScene(protectGroup)) {
            String name = protectGroup.getProperty("kube_volume_set_name");
            volumeSet.setName(name);
            this.iKubeHandler.updateVolumeSet(kubeSn, volumeSet);
        } else {
            this.iKubeHandler.createVolumeSet(kubeSn, volumeSet);
            this.rollbackTask.addItem((IRollbackItem)new ResourceRollBackTask(kubeSn, volumeSet.getName(), KubeEnumDefine.RollBackType.VOLUME_SET));
        }
    }

    protected MetadataPairInfo transToVolumePair(PersistentVolumeClaimInfo claimInfo, String providerSn, String targetSn) {
        MetadataPairInfo pairInfo = new MetadataPairInfo();
        pairInfo.setPvcMeta(claimInfo.getNameSpace() + "/" + claimInfo.getName());
        Optional priOpt = this.iKubeHandler.getPersistentVolumeClaimInfo(providerSn, claimInfo.getName(), claimInfo.getNameSpace());
        Optional targetOpt = this.iKubeHandler.getPersistentVolumeClaimInfo(targetSn, claimInfo.getName(), claimInfo.getNameSpace());
        priOpt.ifPresent(item -> pairInfo.setPrimaryPVName(item.getVolumeName()));
        targetOpt.ifPresent(item -> pairInfo.setSecondaryPVName(item.getVolumeName()));
        return pairInfo;
    }

    protected MetadataPairInfo getMetadataPairInfo(ProtectGroup protectGroup, String targetSn) {
        MetadataPairInfo pairInfo = new MetadataPairInfo();
        Map props = protectGroup.getProps();
        String pvcMeta = (String)props.get("kube_metadata_pvc_name");
        String[] array = pvcMeta.split("/");
        int retryTime = 0;
        int maxTime = 60;
        while (retryTime < maxTime) {
            CommUtil.pauseThread((long)5000L);
            Optional priOpt = this.iKubeHandler.getPersistentVolumeClaimInfo(protectGroup.getPoProviderSN(), array[1], array[0]);
            Optional targetOpt = this.iKubeHandler.getPersistentVolumeClaimInfo(targetSn, array[1], array[0]);
            if (!priOpt.isPresent() || !targetOpt.isPresent()) {
                LOGGER.warn((Object)"No volumeName in pvc:%s at retryTime:%s.", new Object[]{array[1], retryTime});
                ++retryTime;
                continue;
            }
            if (VerifyUtil.isEmpty((String)((PersistentVolumeClaimInfo)priOpt.get()).getVolumeName()) || VerifyUtil.isEmpty((String)((PersistentVolumeClaimInfo)targetOpt.get()).getVolumeName())) {
                LOGGER.warn((Object)"No volumeName in pvc:%s at retryTime:%s.", new Object[]{array[1], retryTime});
                ++retryTime;
                continue;
            }
            pairInfo.setPrimaryPVName(((PersistentVolumeClaimInfo)priOpt.get()).getVolumeName());
            pairInfo.setSecondaryPVName(((PersistentVolumeClaimInfo)targetOpt.get()).getVolumeName());
            break;
        }
        if (VerifyUtil.isEmpty((String)pairInfo.getPrimaryPVName()) || VerifyUtil.isEmpty((String)pairInfo.getSecondaryPVName())) {
            LOGGER.error((Object)"No volumeName in pvc:%s.", new Object[]{array[1]});
            throw new LegoCheckedException(1073937958L);
        }
        pairInfo.setPvcMeta(pvcMeta);
        return pairInfo;
    }

    protected void createProtectPlan(ProtectGroup protectGroup, Schedule schedule) {
        if (this.isReprotectBuildScene(protectGroup)) {
            return;
        }
        KubeProtectionPlan protectionPlan = this.buildKubeProtectionPlan(protectGroup, schedule);
        this.postCreateProtectPlan(protectGroup, protectionPlan);
        this.createProtectionPlan(protectGroup.getPoProviderSN(), protectionPlan);
        KubeUtil.checkProtectPlanStatusNormalOrPending(protectGroup.getPoProviderSN(), protectionPlan.getName());
        this.setRecoveryProtectPlan(protectionPlan);
        this.postCreateProtectPlan(protectGroup, protectionPlan);
        this.createProtectionPlan(schedule.getTargetSn(), protectionPlan);
        this.setProtectionPlanStatus(protectGroup, protectionPlan.getName());
        ExecutionService.submit((Runnable)new MonitorProtectionPlanTask(protectGroup, protectionPlan));
        protectGroup.getProps().put("kube_protection_plan", protectionPlan.getName());
        protectGroup.setStatus(DrmEnumDefine.ProtectGroupStatus.NORMAL.getStatus());
    }

    private KubeProtectionPlan buildKubeProtectionPlan(ProtectGroup protectGroup, Schedule schedule) {
        String name = BaseDisasterProtectionHandler.generateProtectPlanName(protectGroup);
        KubeProtectionPlan protectionPlan = new KubeProtectionPlan();
        protectionPlan.setName(name);
        Map props = protectGroup.getProps();
        if (props.containsKey("kube_policy")) {
            protectionPlan.setProtectionPolicies(JSONArray.toCollection((JSONArray)JSONArray.fromObject(props.get("kube_policy")), String.class));
        }
        protectionPlan.setLocalCluster((String)props.get("localCluster"));
        protectionPlan.setRemoteCluster((String)props.get("remoteCluster"));
        protectionPlan.setVolumeSet((String)props.get("kube_volume_set_name"));
        ProtectObject protectObject = (ProtectObject)protectGroup.getPolist().iterator().next();
        if (protectObject.getPoType() != 21) {
            protectionPlan.setResourceSet(protectObject.getName());
        }
        Optional.ofNullable(schedule.isAppConsistent()).ifPresent(arg_0 -> ((KubeProtectionPlan)protectionPlan).setEnableVolumeConsistency(arg_0));
        protectionPlan.setRoleType(KubeEnumDefine.RoleType.PROTECTED);
        KubeStorage storage = this.getBuilder().getSBC(protectGroup, protectObject);
        protectionPlan.setLocalSBCName(storage.getNamespace() + "/" + storage.getName());
        protectionPlan.setLocalSBCSn(storage.getDeviceSn());
        Optional<KubeStorage> targetOpt = this.getTargetKubeStorage(protectGroup, schedule);
        if (!targetOpt.isPresent()) {
            LOGGER.error((Object)"Not find target kube storage.");
            throw new LegoCheckedException(2117645L);
        }
        KubeStorage targetStorage = targetOpt.get();
        protectGroup.setProperty("sourceStorageBackendName", (Object)storage.getName());
        protectGroup.setProperty("targetStorageBackendName", (Object)targetStorage.getName());
        protectionPlan.setRemoteSBCName(targetStorage.getNamespace() + "/" + targetStorage.getName());
        protectionPlan.setRemoteSBCSn(targetStorage.getDeviceSn());
        if (schedule.getExtParameters().containsKey("preHook")) {
            protectionPlan.setPreHook((String)schedule.getExtParameters().get("preHook"));
        }
        if (schedule.getExtParameters().containsKey("postHook")) {
            protectionPlan.setPostHook((String)schedule.getExtParameters().get("postHook"));
        }
        if (!VerifyUtil.isEmpty((Collection)schedule.getReplicationSpeedPolicies())) {
            int speedNum = ((ReplicationSpeedPolicy)schedule.getReplicationSpeedPolicies().iterator().next()).getSyncRateLevel();
            protectionPlan.setVolumeSpeed(KubeEnumDefine.VolumeSpeed.getVolumeSpeed((int)speedNum));
        }
        return protectionPlan;
    }

    private void setProtectionPlanStatus(ProtectGroup protectGroup, String name) {
        Optional srcProtectionPlanOpt = this.iKubeHandler.getProtectionPlan(protectGroup.getPoProviderSN(), name);
        protectGroup.setProperty("sourceProtectionPlanStatus", (Object)(srcProtectionPlanOpt.isPresent() && !VerifyUtil.isEmpty((Object)((KubeProtectionPlan)srcProtectionPlanOpt.get()).getStatus()) ? ((KubeProtectionPlan)srcProtectionPlanOpt.get()).getStatus().getValue() : "--"));
        Optional trgProtectionPlanOpt = this.iKubeHandler.getProtectionPlan(((Schedule)protectGroup.getTemplate().getSchedules().iterator().next()).getTargetSn(), name);
        protectGroup.setProperty("targetProtectionPlanStatus", (Object)(trgProtectionPlanOpt.isPresent() && !VerifyUtil.isEmpty((Object)((KubeProtectionPlan)trgProtectionPlanOpt.get()).getStatus()) ? ((KubeProtectionPlan)srcProtectionPlanOpt.get()).getStatus().getValue() : "--"));
    }

    private void createProtectionPlan(String kubeSn, KubeProtectionPlan protectionPlan) {
        this.iKubeHandler.rebuildProtectionPlan(kubeSn, protectionPlan);
        this.rollbackTask.addItem((IRollbackItem)new ProtectionPlanRollbackTask(kubeSn, protectionPlan.getName()));
    }

    private static String generateProtectPlanName(ProtectGroup protectGroup) {
        String name = protectGroup.hasProperty("kube_protection_plan") ? protectGroup.getProperty("kube_protection_plan") : KubeResourceNameGenerator.generate();
        return name;
    }

    protected static void refreshKubeResourceSet(ProtectGroup protectGroup) {
        if (protectGroup.getPoType() != 20) {
            return;
        }
        for (ProtectObject protectObject : protectGroup.getPolist()) {
            IKubeHandler kubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
            kubeHandler.refreshKubeResourceSet(protectObject.getProviderSN(), protectObject.getName());
        }
    }

    private void setRecoveryProtectPlan(KubeProtectionPlan protectionPlan) {
        protectionPlan.setRoleType(KubeEnumDefine.RoleType.RECOVERY);
        String localSBCName = protectionPlan.getLocalSBCName();
        String localSBCSn = protectionPlan.getLocalSBCSn();
        String remoteSBCName = protectionPlan.getRemoteSBCName();
        String remoteSBCSn = protectionPlan.getRemoteSBCSn();
        protectionPlan.setLocalSBCName(remoteSBCName);
        protectionPlan.setLocalSBCSn(remoteSBCSn);
        protectionPlan.setRemoteSBCName(localSBCName);
        protectionPlan.setRemoteSBCSn(localSBCSn);
    }

    protected Optional<KubeStorage> getTargetKubeStorage(ProtectGroup protectGroup, Schedule schedule) {
        String backendName = this.getTargetBackendName(schedule);
        DetachedCriteria criteria = DetachedCriteria.forClass(KubeStorage.class);
        criteria.add((Criterion)Restrictions.eq((String)"name", (Object)backendName));
        criteria.add((Criterion)Restrictions.eq((String)"kubeId", (Object)schedule.getTargetSn()));
        List objects = CommonDAOLocator.getBaseDao().getHibernateTemplate().findByCriteria(criteria);
        if (VerifyUtil.isEmpty((Collection)objects)) {
            return Optional.empty();
        }
        return objects.stream().filter(item -> item instanceof KubeStorage).map(item -> (KubeStorage)item).findAny();
    }

    protected String getTargetBackendName(Schedule schedule) {
        Map extParameters = schedule.getExtParameters();
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Map)extParameters) || !extParameters.containsKey("kubeTargetStorage")) {
            LOGGER.error((Object)"Not find kubeTargetStorage info by schedule: %s.", new Object[]{schedule.getName()});
            throw new LegoCheckedException(2117645L);
        }
        return (String)extParameters.get("kubeTargetStorage");
    }

    protected void createPVC(ProtectGroup protectGroup, Schedule schedule) {
        String targetSn = schedule.getTargetSn();
        this.createTargetNamespace(protectGroup, targetSn);
        this.createTargetSC(protectGroup, schedule);
        this.createTargetPVC(protectGroup, targetSn);
        this.createMetaPVC(protectGroup, targetSn);
    }

    private void createMetaPVC(ProtectGroup protectGroup, String targetSn) {
        if (protectGroup.hasProperty("kube_metadata_pvc_name")) {
            return;
        }
        Set<String> storageClassSet = this.getBuilder().getStorageClass(protectGroup);
        if (VerifyUtil.isEmpty(storageClassSet)) {
            LOGGER.error((Object)"StorageClass is not exist.");
            throw new LegoCheckedException(1073947749L);
        }
        String scName = storageClassSet.iterator().next();
        this.doCreateMetaPVC(protectGroup, targetSn, scName);
    }

    private void doCreateMetaPVC(ProtectGroup protectGroup, String targetSn, String scName) {
        String name = KubeResourceNameGenerator.generate();
        PersistentVolumeClaimInfo metaPVCInfo = new PersistentVolumeClaimInfo();
        metaPVCInfo.setName(name);
        metaPVCInfo.setNameSpace("xuanwu");
        metaPVCInfo.setStorageClassName(scName);
        ArrayList<String> accessModes = new ArrayList<String>();
        accessModes.add("ReadWriteMany");
        metaPVCInfo.setAccessModes(accessModes);
        metaPVCInfo.setVolumeMode("Filesystem");
        metaPVCInfo.setAmount("1");
        metaPVCInfo.setFormat("Gi");
        String providerSn = protectGroup.getPoProviderSN();
        this.iKubeHandler.createPersistentVolumeClaim(providerSn, metaPVCInfo);
        this.rollbackTask.addItem((IRollbackItem)new ResourceRollBackTask(providerSn, metaPVCInfo.getName(), metaPVCInfo.getNameSpace(), KubeEnumDefine.RollBackType.PVC));
        this.postCreateTargetMetaPVC(providerSn, metaPVCInfo);
        this.iKubeHandler.createPersistentVolumeClaim(targetSn, metaPVCInfo);
        this.rollbackTask.addItem((IRollbackItem)new ResourceRollBackTask(targetSn, metaPVCInfo.getName(), metaPVCInfo.getNameSpace(), KubeEnumDefine.RollBackType.PVC));
        protectGroup.getProps().put("kube_metadata_pvc_name", "xuanwu/" + name);
    }

    protected void createTargetResourceSet(ProtectGroup protectGroup, String targetSn) {
        List resourceSets = this.iKubeHandler.getResourceSetInfos(protectGroup.getPoProviderSN());
        if (VerifyUtil.isEmpty((Collection)resourceSets)) {
            LOGGER.warn((Object)"The provider resourceSet is empty.");
            throw new LegoCheckedException(2117645L);
        }
        List targetResourceSets = this.iKubeHandler.getResourceSetInfos(targetSn);
        for (ProtectObject protectObject : protectGroup.getPolist()) {
            String name = protectObject.getName();
            Optional<ResourceSetInfo> opt = resourceSets.stream().filter(item -> Objects.equals(item.getName(), name)).findFirst();
            if (!opt.isPresent()) {
                LOGGER.error((Object)"Not find resourceSet with name: %s.", new Object[]{name});
                throw new LegoCheckedException(2117645L);
            }
            boolean isNeedCreate = targetResourceSets.stream().noneMatch(item -> Objects.equals(item.getName(), name));
            if (isNeedCreate) {
                ResourceSetInfo targetInfo = opt.get();
                targetInfo.setSkipValidation(true);
                this.iKubeHandler.createKubeResourceSets(targetSn, targetInfo);
                this.rollbackTask.addItem((IRollbackItem)new ResourceRollBackTask(targetSn, name, KubeEnumDefine.RollBackType.RESOURCE_SET));
            } else {
                LOGGER.info((Object)"target resource set(%s) is exist.", new Object[]{name});
            }
            IKubeService kubeService = (IKubeService)ServiceLocator.getInstance().getService(IKubeService.class);
            this.iKubeHandler.refreshKubeResourceSet(targetSn, name, arg_0 -> ((IKubeService)kubeService).saveOrUpdateResourceSet(arg_0));
        }
    }

    private void createTargetPVC(ProtectGroup protectGroup, String targetSn) {
        List<PersistentVolumeClaimInfo> pvcInfoList = this.getBuilder().getPVC(protectGroup);
        boolean isReprotectBuildScene = this.isReprotectBuildScene(protectGroup);
        if (!isReprotectBuildScene) {
            this.checkTargetPvcNotExist(targetSn, pvcInfoList);
        }
        protectGroup.setProperty("kube_persistent_volume_claims", (Object)pvcInfoList.stream().map(PersistentVolumeClaimInfo::getName).collect(Collectors.toList()).toString());
        List<PersistentVolumeClaimInfo> pvcs = pvcInfoList.stream().map(item -> this.createPersistentVolumeClaim(isReprotectBuildScene, protectGroup, (PersistentVolumeClaimInfo)item)).collect(Collectors.toList());
        this.initTargetPvName(targetSn, pvcs, protectGroup.getPolist(), protectGroup.getPoType());
    }

    private void checkTargetPvcNotExist(String targetSn, List<PersistentVolumeClaimInfo> pvcInfoList) {
        List alreadyExistPvcList = pvcInfoList.stream().filter(item -> this.isTargetPvcExist(targetSn, (PersistentVolumeClaimInfo)item)).map(PersistentVolumeClaimInfo::getName).collect(Collectors.toList());
        if (!alreadyExistPvcList.isEmpty()) {
            throw new LegoCheckedException(1073947747L, "duplicated target pvc: " + alreadyExistPvcList);
        }
    }

    private boolean isTargetPvcExist(String targetSn, PersistentVolumeClaimInfo item) {
        return this.iKubeHandler.getPersistentVolumeClaimInfo(targetSn, item.getName(), item.getNameSpace()).isPresent();
    }

    private boolean isReprotectBuildScene(ProtectGroup protectGroup) {
        return protectGroup.hasProperty("kube_protection_plan");
    }

    private PersistentVolumeClaimInfo createPersistentVolumeClaim(boolean isReprotectBuildScene, ProtectGroup protectGroup, PersistentVolumeClaimInfo item) {
        Optional optional;
        Schedule schedule = (Schedule)protectGroup.getTemplate().getSchedules().iterator().next();
        if (isReprotectBuildScene && (optional = this.iKubeHandler.getPersistentVolumeClaimInfo(schedule.getTargetSn(), item.getName(), item.getNameSpace())).isPresent()) {
            return (PersistentVolumeClaimInfo)optional.get();
        }
        Optional pvcOpt = this.iKubeHandler.getPersistentVolumeClaimInfo(schedule.getSourceSn(), item.getName(), item.getNameSpace());
        if (!pvcOpt.isPresent()) {
            LOGGER.warn((Object)"Not find pvc with name: %s and namespace: %s", new Object[]{item.getName(), item.getNameSpace()});
            throw new LegoCheckedException(201L, "not find pvc: " + item.getName());
        }
        this.postCreateTargetPVC(schedule.getSourceSn(), (PersistentVolumeClaimInfo)pvcOpt.get(), protectGroup);
        PersistentVolumeClaimInfo pvc = this.iKubeHandler.createPersistentVolumeClaim(schedule.getTargetSn(), (PersistentVolumeClaimInfo)pvcOpt.get());
        this.rollbackTask.addItem((IRollbackItem)new ResourceRollBackTask(schedule.getTargetSn(), item.getName(), item.getNameSpace(), KubeEnumDefine.RollBackType.PVC));
        return pvc;
    }

    private void initTargetPvName(String targetSn, List<PersistentVolumeClaimInfo> pvcs, Set<ProtectObject> protectObjects, int poType) {
        int index = 0;
        int limit = pvcs.size();
        while (index < limit) {
            PersistentVolumeClaimInfo pvc = pvcs.get(index);
            String pvcName = pvc.getName();
            PersistentVolumeClaimInfo realPvc = (PersistentVolumeClaimInfo)this.iKubeHandler.getPersistentVolumeClaimInfo(targetSn, pvcName, pvc.getNameSpace()).orElseThrow(() -> new LegoCheckedException(201L, "not find target pvc:" + pvcName));
            String volumeName = realPvc.getVolumeName();
            if (volumeName != null) {
                LOGGER.info((Object)"volume name: %s", new Object[]{volumeName});
                if (poType == 21) {
                    ProtectObject protectObject = this.getProtectObjectByPvcName(protectObjects, pvcName);
                    protectObject.setProperty("kube_remote_persistent_volume", (Object)volumeName);
                }
                ++index;
                continue;
            }
            LOGGER.info((Object)"sleep for pvc %s", new Object[]{pvcName});
            KubeCommonUtils.sleepAndCatchInterrupt((long)1000L);
        }
    }

    private ProtectObject getProtectObjectByPvcName(Set<ProtectObject> protectObjects, String pvcName) {
        return protectObjects.stream().filter(po -> Objects.equals(po.getName(), pvcName)).findFirst().orElseThrow(() -> new LegoCheckedException(201L, "not find protect object: " + pvcName));
    }

    private void createTargetSC(ProtectGroup protectGroup, Schedule schedule) {
        String targetSn = schedule.getTargetSn();
        List scNamesInTarget = this.iKubeHandler.getStorageClasses(targetSn).stream().map(StorageClassInfo::getName).collect(Collectors.toList());
        String providerSn = protectGroup.getPoProviderSN();
        Set<String> storageClassSet = this.getBuilder().getStorageClass(protectGroup);
        ArrayList<String> scNames = new ArrayList<String>(storageClassSet);
        protectGroup.getProps().put("storage_class", ((Object)scNames).toString());
        for (String scName : storageClassSet) {
            Optional opt = this.iKubeHandler.getStorageClassByName(providerSn, scName);
            if (!opt.isPresent()) {
                LOGGER.warn((Object)"The sc: %s not in provider kube.", new Object[]{scName});
                throw new LegoCheckedException(2117645L);
            }
            StorageClassInfo storageClassInfo = (StorageClassInfo)opt.get();
            if (scNamesInTarget.contains(scName)) {
                LOGGER.info((Object)"The sc: %s already in target kube.", new Object[]{scName});
                this.checkTargetSCBackend(protectGroup, schedule, storageClassInfo);
                continue;
            }
            this.doCreateTargetSC(protectGroup, targetSn, storageClassInfo);
        }
    }

    protected void checkTargetSCBackend(ProtectGroup protectGroup, Schedule schedule, StorageClassInfo storageClassInfo) {
        Map extParameters = schedule.getExtParameters();
        if (VerifyUtil.isEmpty((Map)extParameters) || !extParameters.containsKey("kubeTargetStorage")) {
            LOGGER.error((Object)"Not find kubeTargetStorage info by schedule: %s.", new Object[]{schedule.getScheduleId()});
            throw new LegoCheckedException(2117645L);
        }
        String targetBackend = (String)extParameters.get("kubeTargetStorage");
        Optional opt = this.iKubeHandler.getStorageClassByName(schedule.getTargetSn(), storageClassInfo.getName());
        if (!opt.isPresent()) {
            return;
        }
        Map parameters = ((StorageClassInfo)opt.get()).getParameters();
        String realBackend = (String)parameters.get("backend");
        if (!targetBackend.equals(realBackend)) {
            LOGGER.error((Object)"The backend: %s does not match the selected target backend: %s.", new Object[]{realBackend, targetBackend});
            throw new LegoCheckedException(1073947758L, new String[]{targetBackend, realBackend});
        }
    }

    protected void doCreateTargetSC(ProtectGroup protectGroup, String targetSn, StorageClassInfo storageClassInfo) {
        String backendName = this.getTargetBackendName(protectGroup);
        if (VerifyUtil.isEmpty((String)backendName)) {
            LOGGER.error((Object)"Not find target backendName.");
            throw new LegoCheckedException(2117645L);
        }
        Map map = storageClassInfo.getParameters();
        map.put("backend", backendName);
        this.iKubeHandler.createStorageClass(targetSn, storageClassInfo);
        this.rollbackTask.addItem((IRollbackItem)new ResourceRollBackTask(targetSn, storageClassInfo.getName(), KubeEnumDefine.RollBackType.SC));
    }

    private String getTargetBackendName(ProtectGroup protectGroup) {
        Schedule schedule = (Schedule)protectGroup.getTemplate().getSchedules().iterator().next();
        Map extParameters = schedule.getExtParameters();
        if (VerifyUtil.isEmpty((Map)extParameters) || !extParameters.containsKey("kubeTargetStorage")) {
            LOGGER.error((Object)"Not find kubeTargetStorage info by pg:%s.", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(2117645L);
        }
        return (String)extParameters.get("kubeTargetStorage");
    }

    private void createTargetNamespace(ProtectGroup protectGroup, String targetSn) {
        protectGroup.getPolist().forEach(po -> this.doCreateNamespace(targetSn, (String)po.getProps().get("namespace")));
    }

    private void doCreateNamespace(String targetSn, String targetNamespace) {
        if (VerifyUtil.isEmpty((String)targetNamespace)) {
            LOGGER.error((Object)"The input namespace is null.");
            throw new LegoCheckedException(2117645L);
        }
        Optional namespaceOptional = this.iKubeHandler.getNamespace(targetSn, targetNamespace);
        if (namespaceOptional.isPresent()) {
            LOGGER.info((Object)"The namespace: %s already in target K8S", new Object[]{targetNamespace});
            return;
        }
        NamespaceBO namespaceBO = new NamespaceBO();
        namespaceBO.setName(targetNamespace);
        this.iKubeHandler.createNamespace(targetSn, namespaceBO);
        this.rollbackTask.addItem((IRollbackItem)new ResourceRollBackTask(targetSn, targetNamespace, KubeEnumDefine.RollBackType.NAMESPACE));
    }

    protected void createPolicy(ProtectGroup protectGroup, Schedule schedule) {
        if (schedule.getScheduleMode() == 1) {
            return;
        }
        if (protectGroup.hasProperty("kube_policy")) {
            return;
        }
        KubeSchedulePolicy policy = KubeBuilderUtil.buildSchedulePolicy(schedule);
        this.iKubeHandler.createKubeSchedulePolicy(schedule.getSourceSn(), policy);
        this.rollbackTask.addItem((IRollbackItem)new SchedulePolicyRollBackTask(schedule.getSourceSn(), policy));
        this.iKubeHandler.createKubeSchedulePolicy(schedule.getTargetSn(), policy);
        this.rollbackTask.addItem((IRollbackItem)new SchedulePolicyRollBackTask(schedule.getTargetSn(), policy));
        protectGroup.setProperty("kube_policy", (Object)JSONArray.fromObject(Collections.singletonList(policy.getName())).toString());
    }

    protected void createCluster(ProtectGroup protectGroup, String sourceSn, String targetSn) {
        Kubernetes sourceKube = KubeUtil.getKubernetes(sourceSn);
        Kubernetes targetKube = KubeUtil.getKubernetes(targetSn);
        this.createCluster(protectGroup, "localCluster", sourceKube, targetKube, true);
        this.createCluster(protectGroup, "remoteCluster", sourceKube, targetKube, false);
    }

    private void createCluster(ProtectGroup protectGroup, String clusterKey, Kubernetes sourceKube, Kubernetes targetKube, boolean isLocale) {
        if (protectGroup.hasProperty(clusterKey)) {
            return;
        }
        String clusterName = KubeResourceNameGenerator.generate();
        String[] urls = isLocale ? new String[]{sourceKube.getUrl(), targetKube.getUrl()} : new String[]{targetKube.getUrl(), sourceKube.getUrl()};
        this.createCluster(clusterName, sourceKube.getDeviceSn(), urls[0], isLocale);
        this.createCluster(clusterName, targetKube.getDeviceSn(), urls[1], isLocale);
        protectGroup.setProperty(clusterKey, (Object)clusterName);
    }

    private void createCluster(String name, String kubeSn, String url, boolean isLocale) {
        ClusterInfo clusterInfo = ClusterInfo.builder().name(name).url(url).local(isLocale).build();
        this.iKubeHandler.createCluster(kubeSn, clusterInfo);
        this.rollbackTask.addItem((IRollbackItem)new ClusterRollBackTask(kubeSn, name));
    }
}

