/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.protection.replica.builder;

import com.huawei.ism.drm.kube.protection.replica.builder.BaseDisasterProtectionHandler;
import com.huawei.ism.drm.kube.protection.replica.builder.IReplicationBuilder;
import com.huawei.ism.drm.kube.protection.replica.builder.PersistentVolumeBuilder;
import com.huawei.ism.drm.kube.sdk.model.enums.KubeBackTaskProcessDefine;
import com.huawei.ism.drm.kube.util.KubeUtil;
import com.huawei.ism.drm.protection.framework.service.group.context.CreateProtectGroupContext;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;

public class PersistentVolumeReplicationHandler
extends BaseDisasterProtectionHandler {
    private static final Log LOGGER = LogFactory.getInstance(BaseDisasterProtectionHandler.class);

    @Override
    public void createKubeProtectPlan(ProtectGroup protectGroup) {
        KubeUtil.checkParam(protectGroup);
        Schedule schedule = (Schedule)protectGroup.getTemplate().getSchedules().iterator().next();
        try {
            this.createCluster(protectGroup, schedule.getSourceSn(), schedule.getTargetSn());
            this.createPolicy(protectGroup, schedule);
            CreateProtectGroupContext.updateProgress((int)KubeBackTaskProcessDefine.CreateReplicationVolumeProtectGroup.CREATE_CLUSTER_AND_POLICY.getProgress());
            this.createPVC(protectGroup, schedule);
            CreateProtectGroupContext.updateProgress((int)KubeBackTaskProcessDefine.CreateReplicationVolumeProtectGroup.CREATE_TARGET_PVC.getProgress());
            this.createVolumeSet(protectGroup, schedule.getTargetSn());
            CreateProtectGroupContext.updateProgress((int)KubeBackTaskProcessDefine.CreateReplicationVolumeProtectGroup.CREATE_VOLUME_SET.getProgress());
            this.createProtectPlan(protectGroup, schedule);
            CreateProtectGroupContext.updateProgress((int)KubeBackTaskProcessDefine.CreateReplicationVolumeProtectGroup.CREATE_PROTECT_PLAN.getProgress());
        }
        catch (LegoCheckedException exception) {
            LOGGER.error((Object)"Create protect plan failed. error:%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)exception)});
            this.rollbackTask.execute();
            throw exception;
        }
    }

    @Override
    protected IReplicationBuilder getBuilder() {
        return new PersistentVolumeBuilder();
    }
}

