/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.protection.replica.builder;

import com.huawei.ism.drm.kube.protection.replica.builder.AbstractResourceBackupInstanceBuilder;
import com.huawei.ism.drm.kube.sdk.model.BackupLocationInfo;
import com.huawei.ism.drm.kube.sdk.model.constants.KubeEnumDefine;
import com.huawei.ism.drm.kube.sdk.utils.KubeResourceNameGenerator;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import java.util.Optional;

public class ResourceSetBackupInstanceRemoteBuilder
extends AbstractResourceBackupInstanceBuilder {
    @Override
    protected Optional<BackupLocationInfo> createBackupLocation(ProtectGroup protectGroup) {
        BackupLocationInfo backupLocationInfo = new BackupLocationInfo();
        backupLocationInfo.setName(KubeResourceNameGenerator.generate());
        backupLocationInfo.setBackupType(KubeEnumDefine.BackupType.REPLICATION);
        String kubeSn = protectGroup.getPoProviderSN();
        Optional<String> sourceBackendOptional = this.getSourceStorageBackend(kubeSn, (ProtectObject)protectGroup.getPolist().iterator().next());
        if (!sourceBackendOptional.isPresent()) {
            return Optional.empty();
        }
        String sourceBackend = sourceBackendOptional.get();
        String targetBackend = this.getTargetBackendName();
        backupLocationInfo.setSourceBackendName(sourceBackend);
        backupLocationInfo.setBackupBackendName(targetBackend);
        backupLocationInfo.setRestoreBackendName(targetBackend);
        BackupLocationInfo backupLocation = this.iKubeHandler.createBackupLocation(kubeSn, backupLocationInfo);
        return Optional.of(backupLocation);
    }
}

