/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.protection.replica.builder.task;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.kube.sdk.model.BackupLocationInfo;
import com.huawei.lego.cbb.resource.rollback.IRollbackItem;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collections;

public class BackupLocationRollBackTask
implements IRollbackItem {
    private static final Log LOGGER = LogFactory.getInstance(BackupLocationRollBackTask.class);
    private final BackupLocationInfo location;
    private final String kubeSn;

    public BackupLocationRollBackTask(String kubeSn, BackupLocationInfo locationInfo) {
        this.location = locationInfo;
        this.kubeSn = kubeSn;
    }

    public boolean execute() {
        if (VerifyUtil.isEmpty((String)this.kubeSn) || VerifyUtil.isEmpty((Object)this.location) || VerifyUtil.isEmpty((String)this.location.getName())) {
            LOGGER.error((Object)"Roll back location failed. Param invalid.");
            return false;
        }
        LOGGER.warn((Object)"Roll back location %s,", new Object[]{this.location.getName()});
        IKubeHandler iKubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        return iKubeHandler.deleteBackupLocations(this.kubeSn, Collections.singletonList(this.location));
    }
}

