/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.protection.replica.builder.task;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.kube.sdk.model.KubeSchedulePolicy;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.cbb.resource.rollback.IRollbackItem;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collections;

public class SchedulePolicyRollBackTask
implements IRollbackItem {
    private static final Log LOGGER = LogFactory.getInstance(SchedulePolicyRollBackTask.class);
    private final KubeSchedulePolicy policy;
    private final String kubeSn;

    public SchedulePolicyRollBackTask(String kubeSn, KubeSchedulePolicy policy) {
        this.kubeSn = kubeSn;
        this.policy = policy;
    }

    public boolean execute() {
        if (VerifyUtil.isEmpty((String)this.kubeSn) || VerifyUtil.isEmpty((Object)this.policy) || VerifyUtil.isEmpty((String)this.policy.getName())) {
            LOGGER.error((Object)"Roll back policy failed. Param invalid.");
            return false;
        }
        LOGGER.warn((Object)"Roll back schedule policy %s,", new Object[]{this.policy.getName()});
        IKubeHandler iKubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        boolean isSchedulePolicyDelete = false;
        int maxTime = 10;
        for (int retryTime = 0; retryTime < maxTime && !isSchedulePolicyDelete; ++retryTime) {
            long millis = 5000L;
            CommUtil.pauseThread((long)millis);
            isSchedulePolicyDelete = iKubeHandler.deleteSchedulePolicy(this.kubeSn, Collections.singletonList(this.policy));
        }
        return isSchedulePolicyDelete;
    }
}

