/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.protection.replica.monitor;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.kube.sdk.model.KubeProtectionPlan;
import com.huawei.ism.drm.kube.sdk.model.constants.KubeEnumDefine;
import com.huawei.ism.drm.kube.service.KubeHyperMetroProtectGroupRefreshWatcher;
import com.huawei.ism.drm.kube.util.KubeUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;

public class MonitorProtectionPlanTask
implements Runnable {
    private static final Log LOGGER = LogFactory.getInstance(MonitorProtectionPlanTask.class);
    private ProtectGroup protectGroup;
    private final IKubeHandler kubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
    private final KubeHyperMetroProtectGroupRefreshWatcher hyperMetroWatcher = (KubeHyperMetroProtectGroupRefreshWatcher)ServiceLocator.getInstance().getService(KubeHyperMetroProtectGroupRefreshWatcher.class);
    private KubeProtectionPlan plan;

    public MonitorProtectionPlanTask(ProtectGroup protectGroup, KubeProtectionPlan plan) {
        this.protectGroup = protectGroup;
        this.plan = plan;
    }

    @Override
    public void run() {
        try {
            KubeProtectionPlan curTrgProtectionPlan;
            LOGGER.info((Object)"Begin check src protection plan status.");
            KubeUtil.checkProtectPlanStatusNormalOrError(this.protectGroup, this.protectGroup.getPoProviderSN(), this.plan.getName());
            LOGGER.info((Object)"Begin rebuild trg protection plan.");
            String trgSn = ((Schedule)this.protectGroup.getTemplate().getSchedules().iterator().next()).getTargetSn();
            do {
                CommUtil.pauseThread((long)10000L);
                curTrgProtectionPlan = (KubeProtectionPlan)this.kubeHandler.getProtectionPlan(trgSn, this.plan.getName()).get();
                if (!curTrgProtectionPlan.getStatus().getValue().equals(this.protectGroup.getProperty("targetProtectionPlanStatus"))) {
                    KubeUtil.updateProtectionPlanStatusInProps(this.protectGroup, trgSn, curTrgProtectionPlan);
                }
                if (curTrgProtectionPlan.getStatus() != KubeEnumDefine.CDRProtectGroupStatus.NORMAL) continue;
                this.registerHyperMetroWatcher(this.protectGroup);
                return;
            } while (curTrgProtectionPlan.getStatus() != KubeEnumDefine.CDRProtectGroupStatus.ERROR);
            LOGGER.error((Object)"ProtectionPlan:%s status is error.", new Object[]{this.plan.getName()});
            this.kubeHandler.rebuildProtectionPlan(trgSn, this.plan.getName());
            LOGGER.info((Object)"Begin check trg protection plan status.");
            KubeUtil.checkProtectPlanStatusNormalOrError(this.protectGroup, trgSn, this.protectGroup.getProperty("kube_protection_plan"));
            this.registerHyperMetroWatcher(this.protectGroup);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Monitor protection plan status failed. ProtectGroup name:%s.", new Object[]{this.protectGroup.getName()});
            ProtectGroup curProtectGroup = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(this.protectGroup.getUuid());
            curProtectGroup.setStatus(DrmEnumDefine.ProtectGroupStatus.INVALID.getStatus());
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)curProtectGroup);
            this.sendAlarm(this.protectGroup);
            throw e;
        }
    }

    private void registerHyperMetroWatcher(ProtectGroup protectGroup) {
        String domainName = protectGroup.getProperty("domainName");
        if (!VerifyUtil.isEmpty((String)domainName)) {
            this.hyperMetroWatcher.register(protectGroup.getUuid(), domainName);
        }
    }

    private void sendAlarm(ProtectGroup protectGroup) {
        String[] alarmParams = new String[]{this.plan.getName(), protectGroup.getName(), protectGroup.getUuid()};
        AlarmReporter.sendAlarm((String)"0x3230087", (String)protectGroup.getUuid(), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.CRITICAL, (String[])alarmParams);
    }
}

