/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.protection.template.filter;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.kube.protection.template.filter.ResourceSetLocalBackupFilter;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class ResourceSetRemoteBackupFilter
extends ResourceSetLocalBackupFilter {
    private static final Log LOGGER = LogFactory.getInstance(ResourceSetRemoteBackupFilter.class);

    public boolean isMatch(List<ProtectObject> protectObjects, PolicyTemplate policyTemplate) {
        if (VerifyUtil.isEmpty(protectObjects)) {
            LOGGER.warn((Object)"The parameter protectObjects is empty!");
            throw new LegoCheckedException(1073948191L);
        }
        ResourceSetRemoteBackupFilter.checkResourcesExist(protectObjects);
        Optional<String> localBackendOptional = this.checkAndGetLocalBackendStorage(protectObjects);
        localBackendOptional.ifPresent(s -> this.checkRemoteBackendStorage((String)s, policyTemplate));
        return true;
    }

    @Override
    public int getType() {
        return 50;
    }

    private void checkRemoteBackendStorage(String localBackend, PolicyTemplate policyTemplate) {
        Schedule schedule = (Schedule)policyTemplate.getSchedules().iterator().next();
        Map extParameters = schedule.getExtParameters();
        if (VerifyUtil.isEmpty((Map)extParameters)) {
            LOGGER.error((Object)"Parameter error, can not find extParameters from policy template");
            throw new LegoCheckedException(1073947393L);
        }
        String remoteBackend = (String)extParameters.get("kubeTargetStorage");
        if (StringUtils.equals((CharSequence)localBackend, (CharSequence)remoteBackend)) {
            LOGGER.error((Object)"Local backend can not be same as remote backend, both: %s", new Object[]{localBackend});
            throw new LegoCheckedException(1073947752L);
        }
    }
}

