/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.util;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.kube.model.CheckDomainChangedResult;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.kube.sdk.model.Domain;
import com.huawei.ism.drm.kube.sdk.model.KubeHyperMetroDomainBackend;
import com.huawei.ism.drm.kube.sdk.model.KubeHyperMetroDomainPvc;
import com.huawei.ism.drm.kube.sdk.model.KubePersistentVolume;
import com.huawei.ism.drm.kube.sdk.model.KubeProtectionPlan;
import com.huawei.ism.drm.kube.sdk.model.KubeStorage;
import com.huawei.ism.drm.kube.sdk.model.KubeVolumeSet;
import com.huawei.ism.drm.kube.sdk.model.Kubernetes;
import com.huawei.ism.drm.kube.sdk.model.MetadataPairInfo;
import com.huawei.ism.drm.kube.sdk.model.PersistentVolumeClaimInfo;
import com.huawei.ism.drm.kube.sdk.model.StorageClassInfo;
import com.huawei.ism.drm.kube.sdk.model.constants.KubeEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.dao.DataAccessException;

public class KubeUtil {
    private static final Log LOGGER = LogFactory.getInstance(KubeUtil.class);
    private static final int QUERY_PVC_MAX_RETRY_TIMES = 60;
    private static final long QUERY_PVC_DURATION = 1L;
    private static final int REFRESH_DOMAIN_QUERY_TIMES = 60;
    private static final int REFRESH_DOMAIN_QUERY_DURATION = 5;

    public static Kubernetes getKubernetes(String sn) {
        List kubeList;
        VerifyUtil.checkStrs((String[])new String[]{sn});
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(Kubernetes.class);
            criteria.add((Criterion)Restrictions.eq((String)"dbId", (Object)sn));
            kubeList = criteria.list();
        }
        catch (DataAccessException e) {
            try {
                LOGGER.error((Object)"Failed to query kubernetes by sn:%s", new Object[]{sn});
                throw new LegoCheckedException(201L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession((Session)session);
        return (Kubernetes)kubeList.stream().findAny().orElseThrow(() -> new LegoCheckedException(201L));
    }

    public static void buildServerReplica(ProtectGroup protectGroup) {
        KubeUtil.checkParam(protectGroup);
        ProtectGroupReplica replica = new ProtectGroupReplica();
        replica.setId(UUIDGenerator.getUUID());
        replica.setName("REMOTEREPLICA-" + protectGroup.getName());
        replica.setPg(protectGroup);
        replica.setStatus(DrmEnumDefine.ReplicaStatus.ACTIVE_STATUS.getValue());
        replica.setProtectLocation(DrmEnumDefine.ProtectLocation.A_B.getValue());
        replica.setType(13);
        Schedule schedule = (Schedule)protectGroup.getTemplate().getSchedules().iterator().next();
        replica.setRecoverySite(schedule.getTargetSiteId());
        replica.setProductArray(schedule.getSourceSn());
        replica.setRecoveryArray(schedule.getTargetSn());
        protectGroup.getReplicaList().add(replica);
        String sourceIp = KubeUtil.getKubernetes(schedule.getSourceSn()).getIpAddress();
        String targetIp = KubeUtil.getKubernetes(schedule.getTargetSn()).getIpAddress();
        protectGroup.getProps().put("sourceKubeClusterIp", sourceIp);
        protectGroup.getProps().put("targetKubeClusterIp", targetIp);
    }

    public static void checkParam(ProtectGroup protectGroup) {
        if (VerifyUtil.isEmpty((Object)protectGroup) || VerifyUtil.isEmpty((Collection)protectGroup.getPolist()) || VerifyUtil.isEmpty((Collection)protectGroup.getTemplate().getSchedules())) {
            LOGGER.error((Object)"Invalid pg param.");
            throw new LegoCheckedException(1073947393L);
        }
    }

    public static void checkProtectPlanStatusNormalOrPending(String devSn, String name) {
        block3: {
            Optional opt;
            long curTime;
            long startTime = System.currentTimeMillis();
            do {
                CommUtil.pauseThread((long)30000L);
                opt = ((IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class)).getProtectionPlan(devSn, name);
                if (!opt.isPresent()) {
                    LOGGER.error((Object)"Not find the protect protectPlan: %s", new Object[]{name});
                    throw new LegoCheckedException(2117645L);
                }
                if (((KubeProtectionPlan)opt.get()).getStatus() == KubeEnumDefine.CDRProtectGroupStatus.ERROR) {
                    LOGGER.error((Object)"The protect cdr PP is Error, can not create recovery.");
                    throw new LegoCheckedException(1073947751L, new String[]{name, ((KubeProtectionPlan)opt.get()).getStatus().getValue()});
                }
                if (((KubeProtectionPlan)opt.get()).getStatus() == KubeEnumDefine.CDRProtectGroupStatus.NORMAL || ((KubeProtectionPlan)opt.get()).getStatus() == KubeEnumDefine.CDRProtectGroupStatus.PENDING) break block3;
            } while ((curTime = System.currentTimeMillis()) - startTime < 360000L);
            LOGGER.error((Object)"Get PP status: %s by max wait time on %s.", new Object[]{((KubeProtectionPlan)opt.get()).getStatus().getValue(), devSn});
            throw new LegoCheckedException(1073947433L);
        }
        LOGGER.info((Object)"The protect cdr protection plan is normal or pending.");
    }

    public static void checkProtectPlanStatusNormalOrError(ProtectGroup protectGroup, String devSn, String name) {
        KubeProtectionPlan plan;
        IKubeHandler kubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        do {
            String planStatusInProtectGroup;
            CommUtil.pauseThread((long)10000L);
            Optional opt = kubeHandler.getProtectionPlan(devSn, name);
            if (!opt.isPresent()) {
                LOGGER.error((Object)"Not find the protect protectPlan: %s", new Object[]{name});
                throw new LegoCheckedException(2117645L);
            }
            plan = (KubeProtectionPlan)opt.get();
            String string = planStatusInProtectGroup = protectGroup.getPoProviderSN().equals(devSn) ? (String)protectGroup.getProps().get("sourceProtectionPlanStatus") : (String)protectGroup.getProps().get("targetProtectionPlanStatus");
            if (!plan.getStatus().getValue().equals(planStatusInProtectGroup)) {
                KubeUtil.updateProtectionPlanStatusInProps(protectGroup, devSn, plan);
            }
            if (plan.getStatus() != KubeEnumDefine.CDRProtectGroupStatus.ERROR) continue;
            LOGGER.error((Object)"The protect cdr PP on %s is Error, can not create recovery.", new Object[]{devSn});
            throw new LegoCheckedException(1073947751L, new String[]{name, ((KubeProtectionPlan)opt.get()).getStatus().getValue()});
        } while (plan.getStatus() != KubeEnumDefine.CDRProtectGroupStatus.NORMAL);
        LOGGER.info((Object)"The protect cdr PP is normal, can create recovery.");
    }

    public static void updateProtectionPlanStatusInProps(ProtectGroup protectGroup, String devSn, KubeProtectionPlan plan) {
        ProtectGroup curProtectGroup = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(protectGroup.getUuid());
        IKubeHandler kubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        protectGroup.setProperty(protectGroup.getPoProviderSN().equals(devSn) ? "sourceProtectionPlanStatus" : "targetProtectionPlanStatus", (Object)plan.getStatus().getValue());
        curProtectGroup.setProperty(protectGroup.getPoProviderSN().equals(devSn) ? "sourceProtectionPlanStatus" : "targetProtectionPlanStatus", (Object)plan.getStatus().getValue());
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)curProtectGroup);
    }

    public static String parseResourceVersion(String src) {
        if (VerifyUtil.isEmpty((String)src)) {
            return "";
        }
        if (src.contains("/")) {
            String[] arr = src.split("/");
            return arr[arr.length - 1];
        }
        return src;
    }

    public static Optional<String> queryVolumeName(String devSn, String pvcName, String namespace) {
        IKubeHandler kubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        for (int retryTime = 0; retryTime < 60; ++retryTime) {
            PersistentVolumeClaimInfo pvc;
            String volumeName;
            Optional opt = kubeHandler.getPersistentVolumeClaimInfo(devSn, pvcName, namespace);
            if (opt.isPresent() && !VerifyUtil.isEmpty((String)(volumeName = (pvc = (PersistentVolumeClaimInfo)opt.get()).getVolumeName()))) {
                return Optional.of(volumeName);
            }
            CommonUtil.sleep((long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        return Optional.empty();
    }

    public static void checkHyperMetroStorageClass(ProtectGroup protectGroup, StorageClassInfo productionStorageClass, StorageClassInfo disasterStorageClass) {
        Map productionParameters = productionStorageClass.getParameters();
        String productionBackend = (String)productionParameters.get("backend");
        String productionPairId = KubeUtil.getStorePairId(protectGroup.getPoProviderSN(), productionStorageClass.getName(), productionBackend);
        Schedule schedule = (Schedule)protectGroup.getTemplate().getSchedules().iterator().next();
        Map disasterParameters = disasterStorageClass.getParameters();
        String disasterBackend = (String)disasterParameters.get("backend");
        String disasterPairId = KubeUtil.getStorePairId(schedule.getTargetSn(), productionStorageClass.getName(), disasterBackend);
        if (!StringUtils.equals((CharSequence)productionPairId, (CharSequence)disasterPairId)) {
            LOGGER.error((Object)"The same name StorageClass (%s) has already exist in target cluster, but vStorePairId is different. productionPairId: %s, disasterPairId: %s", new Object[]{productionStorageClass.getName(), productionPairId, disasterPairId});
            throw new LegoCheckedException(1073947763L, new String[]{productionStorageClass.getName(), disasterBackend});
        }
    }

    public static Optional<KubeStorage> matchHyperMetroBackend(String sourceSn, String targetSn, String sourceBackend) {
        IKubeHandler kubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        Optional srcSbcOptional = kubeHandler.getStorageBackendClaims(sourceSn, sourceBackend);
        if (!srcSbcOptional.isPresent()) {
            LOGGER.error((Object)"Could not find source StorageBackendClaims of Backend (%s)", new Object[]{sourceBackend});
            throw new LegoCheckedException(1073947393L);
        }
        KubeStorage srcStorage = (KubeStorage)srcSbcOptional.get();
        String vStorePairId = srcStorage.getPairId();
        if (VerifyUtil.isEmpty((String)vStorePairId)) {
            LOGGER.error((Object)"Could not find the VStorePairId in StorageBackendClaims of Backend (%s)", new Object[]{sourceBackend});
            throw new LegoCheckedException(1073947393L);
        }
        List remoteDeviceSNs = srcStorage.getRemoteDeviceSNs();
        if (VerifyUtil.isEmpty((Collection)remoteDeviceSNs)) {
            LOGGER.error((Object)"Could not find the remoteDeviceSN in StorageBackendClaims of Backend (%s)", new Object[]{sourceBackend});
            throw new LegoCheckedException(1073947393L);
        }
        List targetStorage = kubeHandler.getStorageBackendClaims(targetSn);
        return targetStorage.stream().filter(e -> vStorePairId.equals(e.getPairId()) && remoteDeviceSNs.contains(e.getDeviceSn())).findFirst();
    }

    public static void buildHyperMetroPvcFileSystem(String kubeSn, PersistentVolumeClaimInfo pvc) {
        HashMap<String, String> annotations = new HashMap<String, String>();
        annotations.put("csi.huawei.com/fileSystemMode", "HyperMetro");
        IKubeHandler kubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        KubePersistentVolume persistentVolume = (KubePersistentVolume)kubeHandler.getKubePersistentVolume(kubeSn, pvc.getVolumeName()).get();
        annotations.put("csi.huawei.com/volumeName", VerifyUtil.isEmpty((String)persistentVolume.getVolumeHandle()) || persistentVolume.getVolumeHandle().split("\\.").length != 2 ? pvc.getVolumeName() : persistentVolume.getVolumeHandle().split("\\.")[1]);
        pvc.setAnnotations(annotations);
        HashMap<String, String> labelMap = new HashMap<String, String>();
        labelMap.put("provisioner", "csi.huawei.com");
        pvc.setLabelMap(labelMap);
    }

    private static String getStorePairId(String kubeSn, String sc, String backend) {
        IKubeHandler kubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        Optional sbcOptional = kubeHandler.getStorageBackendClaims(kubeSn, backend);
        if (!sbcOptional.isPresent()) {
            LOGGER.error((Object)"Could not find the StorageBackendClaims of Backend (%s)", new Object[]{backend});
            throw new LegoCheckedException(1073947763L, new String[]{sc, backend});
        }
        String pairId = ((KubeStorage)sbcOptional.get()).getPairId();
        if (VerifyUtil.isEmpty((String)pairId)) {
            LOGGER.error((Object)"Could not find the VStorePairId in StorageBackendClaims of Backend (%s)", new Object[]{backend});
            throw new LegoCheckedException(1073947763L, new String[]{sc, backend});
        }
        return pairId;
    }

    public static CheckDomainChangedResult checkDomainChange(ProtectGroup protectGroup, Domain domain) {
        IKubeHandler kubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        String volumeSetName = protectGroup.getProperty("kube_volume_set_name");
        KubeVolumeSet volumeSet = kubeHandler.getVolumeSet(protectGroup.getPoProviderSN(), volumeSetName);
        List volumePairs = volumeSet.getVolumePairs();
        CheckDomainChangedResult result = new CheckDomainChangedResult();
        List<KubeHyperMetroDomainPvc> allPvcList = KubeUtil.getDomainPvcList(domain);
        result.setAddedPvcs(KubeUtil.buildAddedPvcList(allPvcList, volumePairs));
        result.setRemovedPvcs(KubeUtil.buildRemovedPvcList(allPvcList, volumePairs));
        KubeUtil.calculateAndCheckCapacity(protectGroup.getPoProviderSN(), result);
        return result;
    }

    private static void calculateAndCheckCapacity(String kubeSn, CheckDomainChangedResult result) {
        double changedCapacity = 0.0;
        changedCapacity += KubeUtil.calculateAddCapacity(kubeSn, result.getAddedPvcs());
        result.setChangedCapacity(changedCapacity -= KubeUtil.calculateRemovedCapacity(result.getRemovedPvcs()));
    }

    private static double calculateAddCapacity(String kubeSn, List<KubeHyperMetroDomainPvc> addPvcList) {
        double addCapacity = 0.0;
        IKubeHandler kubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        for (KubeHyperMetroDomainPvc pvc : addPvcList) {
            Optional addVolumeOpt = kubeHandler.getKubePersistentVolume(kubeSn, pvc.getPvName());
            if (!addVolumeOpt.isPresent()) continue;
            addCapacity += ((KubePersistentVolume)addVolumeOpt.get()).getCapacity();
        }
        return addCapacity;
    }

    private static double calculateRemovedCapacity(List<MetadataPairInfo> removedPvcList) {
        double removedCapacity = 0.0;
        for (MetadataPairInfo pvc : removedPvcList) {
            String[] array = pvc.getPvcMeta().split("/");
            if (array.length != 2) continue;
            DetachedCriteria criteria = DetachedCriteria.forClass(ProtectObject.class);
            criteria.add((Criterion)Restrictions.eq((String)"name", (Object)array[1]));
            List objects = CommonDAOLocator.getBaseDao().getHibernateTemplate().findByCriteria(criteria);
            if (VerifyUtil.isEmpty((Collection)objects) || !(objects.get(0) instanceof ProtectObject)) continue;
            List protectedObjects = objects;
            int capacity = new Double(((ProtectObject)protectedObjects.get(0)).getProperty("capacity")).intValue();
            removedCapacity += (double)capacity;
        }
        return removedCapacity;
    }

    public static void checkHyperMetroDomainNormal(String kubeSn, String domainName, String domainIp) {
        KubeUtil.checkHyperMetroDomainNormal(kubeSn, domainName, domainIp, false, false);
    }

    public static void checkHyperMetroDomainNormal(String kubeSn, String domainName, String domainIp, boolean shouldRetry, boolean shouldRefresh) {
        IKubeHandler kubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        if (shouldRefresh) {
            kubeHandler.refreshHyperMetroDomain(kubeSn, domainName);
        }
        for (int i = 0; i < 60; ++i) {
            CommonUtil.sleep((long)5L, (TimeUnit)TimeUnit.SECONDS);
            Optional opt = kubeHandler.getHyperMetroDomain(kubeSn, domainName);
            if (!opt.isPresent()) {
                LOGGER.error((Object)"The HyperMetroDomain (%s) is not present.", new Object[]{domainName});
                throw new LegoCheckedException(2117645L);
            }
            Domain domain = (Domain)opt.get();
            if (StringUtils.equals((CharSequence)domain.getStatus(), (CharSequence)KubeEnumDefine.DomainStatus.NORMAL.getValue())) {
                return;
            }
            if (shouldRetry) continue;
            LOGGER.error((Object)"Status of the hyper metro domain ( %s ) is not normal", new Object[]{domainName});
            throw new LegoCheckedException(1073947768L, new String[]{domainName, domainIp});
        }
        LOGGER.error((Object)"Status of the hyper metro domain ( %s ) is not normal after %s retries", new Object[]{domainName, 60});
        throw new LegoCheckedException(1073947768L, new String[]{domainName, domainIp});
    }

    private static List<KubeHyperMetroDomainPvc> getDomainPvcList(Domain domain) {
        List backends = domain.getBackends();
        ArrayList<KubeHyperMetroDomainPvc> allPvcList = new ArrayList<KubeHyperMetroDomainPvc>();
        for (KubeHyperMetroDomainBackend backend : backends) {
            List pvcList = backend.getPvcList();
            if (VerifyUtil.isEmpty((Collection)pvcList)) continue;
            allPvcList.addAll(pvcList);
        }
        allPvcList.removeIf(e -> "xuanwu".equals(e.getNamespace()));
        return allPvcList;
    }

    private static List<KubeHyperMetroDomainPvc> buildAddedPvcList(List<KubeHyperMetroDomainPvc> allPvcList, List<MetadataPairInfo> volumePairs) {
        ArrayList<KubeHyperMetroDomainPvc> addPvcs = new ArrayList<KubeHyperMetroDomainPvc>();
        for (KubeHyperMetroDomainPvc domainPvc : allPvcList) {
            Optional<MetadataPairInfo> opt = volumePairs.stream().filter(pair -> {
                String[] namespaceAndName = pair.getPvcMeta().split("/");
                return StringUtils.equals((CharSequence)namespaceAndName[0], (CharSequence)domainPvc.getNamespace()) && StringUtils.equals((CharSequence)namespaceAndName[1], (CharSequence)domainPvc.getPvcName());
            }).findAny();
            if (opt.isPresent()) continue;
            addPvcs.add(domainPvc);
        }
        return addPvcs;
    }

    private static List<MetadataPairInfo> buildRemovedPvcList(List<KubeHyperMetroDomainPvc> allPvcList, List<MetadataPairInfo> volumePairs) {
        ArrayList<MetadataPairInfo> removedPvcs = new ArrayList<MetadataPairInfo>();
        for (MetadataPairInfo pair : volumePairs) {
            Optional<KubeHyperMetroDomainPvc> opt = allPvcList.stream().filter(pvc -> {
                String[] namespaceAndName = pair.getPvcMeta().split("/");
                return StringUtils.equals((CharSequence)namespaceAndName[0], (CharSequence)pvc.getNamespace()) && StringUtils.equals((CharSequence)namespaceAndName[1], (CharSequence)pvc.getPvcName());
            }).findAny();
            if (opt.isPresent()) continue;
            removedPvcs.add(pair);
        }
        return removedPvcs;
    }

    public static void sendAlarm(ProtectGroup protectGroup) {
        String[] alarmParams = new String[]{protectGroup.getProperty("kube_protection_plan"), protectGroup.getName(), protectGroup.getUuid()};
        AlarmReporter.sendAlarm((String)"0x3230087", (String)protectGroup.getUuid(), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.CRITICAL, (String[])alarmParams);
    }
}

