/*
 * Decompiled with CFR 0.152.
 */
package io.huawei.xuanwu.v1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"operation", "recoveryPlanName", "type"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class RecoveryJobSpec
implements KubernetesResource {
    @JsonProperty(value="operation")
    @JsonPropertyDescription(value="Operation is the operation of the recovery job, recovery will be performed according to the recovery operation")
    @JsonSetter(nulls=Nulls.SKIP)
    private Operation operation;
    @JsonProperty(value="recoveryPlanName")
    @JsonPropertyDescription(value="RecoveryPlanName is the name of RecoveryPlan CR, it will be used for this recovery job")
    @JsonSetter(nulls=Nulls.SKIP)
    private String recoveryPlanName;
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Type is the recovery job type, it will be used for recovery")
    @JsonSetter(nulls=Nulls.SKIP)
    private Type type;

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public String getRecoveryPlanName() {
        return this.recoveryPlanName;
    }

    public void setRecoveryPlanName(String recoveryPlanName) {
        this.recoveryPlanName = recoveryPlanName;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public static enum Type {
        PLANMIGRATION("PlanMigration"),
        DISASTERRECOVERY("DisasterRecovery");

        String value;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public static Optional<Type> getRecoveryJobType(String typeStr) {
            for (Type type : Type.values()) {
                if (!type.getValue().equals(typeStr)) continue;
                return Optional.of(type);
            }
            return Optional.empty();
        }
    }

    public static enum Operation {
        DISABLEPROTECTIONPLAN("DisableProtectionPlan"),
        SYNCMETADATAPAIRS("SyncMetadataPairs"),
        DELETERESOURCES("DeleteResources"),
        SYNCVOLUMEPAIRS("SyncVolumePairs"),
        SPLITVOLUMEPAIRS("SplitVolumePairs"),
        SPLITMETADATAPAIRS("SplitMetadataPairs"),
        RECOVERRESOURCES("RecoverResources"),
        FAILOVERDOMAIN("FailOverDomain");

        String value;

        private Operation(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public static Operation getRecoveryJobOperation(String operationStr) {
            for (Operation operation : Operation.values()) {
                if (!operation.getValue().equals(operationStr)) continue;
                return operation;
            }
            throw new LegoCheckedException(1073947393L);
        }
    }
}

