/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.agent.service.impl;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.drm.host.agent.action.RemoteShellAction;
import com.huawei.ism.drm.host.agent.action.Stdin;
import com.huawei.ism.drm.host.sdk.IHostRealizeHandler;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AgentlessHostRealizeImpl
extends RemoteShellAction
implements IHostRealizeHandler {
    private static final Log LOGGER = LogFactory.getInstance(AgentlessHostRealizeImpl.class);
    private static final String KEY_CUSTOM_PARAM = "-v";
    private static final String SENSITIVE_KEY_REGEXP = "password|passwd";

    public AgentlessHostRealizeImpl(NeMgrProtocolExtend extend) {
        super(extend);
    }

    public String getHostInfo() {
        return this.execute("guard host query_host_system", new Object[0]).get();
    }

    public String getInitiatorsInfo() {
        return this.execute("guard host query_initiator", new Object[0]).get();
    }

    public String getDiskInfo() {
        return this.execute("guard host query_disks_info", new Object[0]).get();
    }

    public void scanDisks() {
        this.execute("guard host scan_disk", new Object[0]).get();
    }

    public void batchOnlineDisks(String bodyParams) {
        this.execute("guard host xx", new Object[0]).get();
    }

    public String getPartitions() {
        return this.execute("guard host xx", new Object[0]).get();
    }

    public String getThirdPartScriptFiles() {
        return this.execute("guard custom query", new Object[0]).get();
    }

    public void doExecThirdPartScript(String bodyParams) {
        String scriptName = "";
        try {
            JSONObject bodyParamObj = JSONObject.fromObject((Object)bodyParams);
            scriptName = bodyParamObj.getString("fileName");
            List<Object> paramList = this.buildParams(bodyParamObj);
            LOGGER.warn((Object)"Start to execute the custom script(name: %s)", new Object[]{scriptName});
            this.execute("guard custom call " + scriptName, paramList.toArray(new Object[0])).get();
        }
        catch (LegoCheckedException ex) {
            if (ex.getErrorCode() != -1L) {
                throw ex;
            }
            LOGGER.error((Object)"Failed to execute the custom script(name: %s), errorMsg: %s", new Object[]{scriptName, ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw new LegoCheckedException(1073948724L);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"An error occurred when execute custom script(name: %s), errorMsg: %s", new Object[]{scriptName, ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw new LegoCheckedException(1073948724L);
        }
    }

    private List<Object> buildParams(JSONObject bodyParamObj) {
        ArrayList<Object> paramList = new ArrayList<Object>();
        String isUserDefined = bodyParamObj.getString("isUserDefined");
        JSONObject params = bodyParamObj.getJSONObject("params");
        this.addObjectParam(paramList, "isUserDefined", isUserDefined);
        if (!params.isEmpty()) {
            params.forEach((k, v) -> {
                String value;
                String key = k == null ? "" : k.toString();
                String string = value = v == null ? "" : v.toString();
                if ("BCM_MORPHOLOGICAL".equals(key)) {
                    value = value.replaceAll("->", "-#").replaceAll("<-", "#-");
                }
                this.addObjectParam(paramList, key, value);
            });
        }
        return paramList;
    }

    private void addObjectParam(List<Object> paramList, String key, String value) {
        this.checkParamKey(key);
        this.checkParamValue(value);
        paramList.add(KEY_CUSTOM_PARAM);
        Pattern pattern = Pattern.compile(SENSITIVE_KEY_REGEXP, 2);
        Matcher matcher = pattern.matcher(Normalizer.normalize(key, Normalizer.Form.NFKC));
        if (matcher.find()) {
            paramList.add(Stdin.use(key, value));
            return;
        }
        paramList.add(key + "=" + value);
    }

    private void addParam(List<String> paramList, String key, String value) {
        this.checkParamKey(key);
        this.checkParamValue(value);
        paramList.add(KEY_CUSTOM_PARAM);
        paramList.add(key + "=" + value);
    }

    private void checkParamKey(String key) {
        if (VerifyUtil.isEmpty((String)key) || key.contains(" ")) {
            LOGGER.error((Object)"Param key is invalid, errorKey: %s", new Object[]{key});
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void checkParamValue(String value) {
        if (!VerifyUtil.isEmpty((String)value) && value.contains(" ")) {
            LOGGER.error((Object)"Param value is invalid, errorValue: %s", new Object[]{SecurityUtil.desensitizeId((String)value)});
            throw new LegoCheckedException(1073947393L);
        }
    }

    public void execThirdPartScriptWithUrl(String url, String bodyParams) {
        String type = url.contains("/unfreeze") ? "unfreeze" : "freeze";
        String scriptName = "";
        try {
            JSONObject bodyParamObj = JSONObject.fromObject((Object)bodyParams);
            List<String> paramList = this.buildParamsWithUrl(bodyParamObj);
            this.addParam(paramList, "BCM_freeze", type);
            scriptName = url.contains("/unfreeze") ? bodyParamObj.getString("unfreezeFile") : bodyParamObj.getString("freezeFile");
            LOGGER.warn((Object)"Start to execute %s custom script(name: %s)", new Object[]{type, scriptName});
            this.execute("guard custom call " + scriptName, paramList).get();
        }
        catch (LegoCheckedException ex) {
            if (ex.getErrorCode() != -1L) {
                throw ex;
            }
            LOGGER.error((Object)"Failed to execute the custom script(name: %s), errorMsg: %s", new Object[]{scriptName, ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw new LegoCheckedException(1073948724L);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"An error occurred when execute custom script(name: %s), errorMsg: %s", new Object[]{scriptName, ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw new LegoCheckedException(1073948724L);
        }
    }

    private List<String> buildParamsWithUrl(JSONObject bodyParamObj) {
        ArrayList<String> paramList = new ArrayList<String>();
        String freezeFile = bodyParamObj.getString("freezeFile");
        String unfreezeFile = bodyParamObj.getString("unfreezeFile");
        String queryFile = bodyParamObj.getString("queryFile");
        this.addParam(paramList, "freezeFile", freezeFile);
        this.addParam(paramList, "unfreezeFile", unfreezeFile);
        this.addParam(paramList, "queryFile", queryFile);
        this.addParam(paramList, "freezeTimeout", bodyParamObj.getString("freezeTimeout", "0"));
        this.addExtendParams(bodyParamObj, paramList);
        return paramList;
    }

    private void addExtendParams(JSONObject bodyParamObj, List<String> paramList) {
        JSONObject freezeParams = bodyParamObj.getJSONObject("freezeParams");
        JSONObject unfreezeParam = bodyParamObj.getJSONObject("unfreezeParam");
        JSONObject queryParam = bodyParamObj.getJSONObject("queryParam");
        this.addParam(paramList, "freezeParams", this.getBatchParams(freezeParams));
        this.addParam(paramList, "unfreezeParam", this.getBatchParams(unfreezeParam));
        this.addParam(paramList, "queryParam", this.getBatchParams(queryParam));
    }

    private String getBatchParams(JSONObject params) {
        if (params.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        params.forEach((k, v) -> {
            if (VerifyUtil.isEmpty((Object)k) || VerifyUtil.isEmpty((Object)v)) {
                LOGGER.error((Object)"Param k or v is invalid.");
                throw new LegoCheckedException(1073947393L);
            }
            sb.append(k).append("=").append(v).append("#");
        });
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    public String getDataCollectInfo() {
        return this.execute("guard host xx", new Object[0]).get();
    }

    public String getHostAgentInfo() {
        return null;
    }

    public String getHostBlockClientIp() {
        return this.execute("guard host xx", new Object[0]).get();
    }

    public boolean downloadSystemInfo(String logFileName, String sn) {
        return false;
    }
}

