/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.device;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.util.CommonComparator;
import com.huawei.ism.drm.app.constants.DrmAppEnumDefine;
import com.huawei.ism.drm.app.sdk.model.HostDeviceStorageInfo;
import com.huawei.ism.drm.base.util.NeMgrProtocolExtendServiceUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.host.device.process.IDeviceProcessor;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.util.DBRecoveryTools;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DeviceProcessorManager {
    private static final Log LOGGER = LogFactory.getInstance(DeviceProcessorManager.class);
    private static DeviceProcessorManager instance = new DeviceProcessorManager();
    private List<IDeviceProcessor> deviceProcessList = Collections.synchronizedList(new ArrayList());

    private DeviceProcessorManager() {
    }

    public static DeviceProcessorManager getInstance() {
        return instance;
    }

    public void onBind(IDeviceProcessor deviceProcess, Map<String, String> map) {
        this.deviceProcessList.add(deviceProcess);
    }

    public void onUnBind(IDeviceProcessor deviceProcess, Map<String, String> map) {
        this.deviceProcessList.remove(deviceProcess);
    }

    public void executeMountProcessors(DrHost drHost, List<HostDeviceStorageInfo> hostDeviceStorageInfos, DrmAppEnumDefine.CLUSTER_TYPE_E clusterType, String proProviderType, String vgActiveMode) {
        String disasterProviderType = null != clusterType ? String.valueOf(DrmEnumDefine.ProviderTypeE.HOSTGROUP.getValue()) : String.valueOf(DrmEnumDefine.ProviderTypeE.HOST.getValue());
        int recoverType = DBRecoveryTools.getRecoverType(proProviderType, disasterProviderType);
        NeMgrProtocolExtend extend = DrHostUtil.getNeMgrProtocolExtend(NeMgrProtocolExtendServiceUtil.getNeMgrExtendService(), drHost.getDeviceSn());
        RecoveryProcessorContext context = new RecoveryProcessorContext();
        context.setAttribute("HOST_INFO", (Object)drHost);
        context.setAttribute("HOST_DEVICE_INFO", hostDeviceStorageInfos);
        context.setAttribute("HOST_AUTH_INFO", (Object)extend);
        context.setAttribute("HOST_RECOVERY_TYPE", (Object)recoverType);
        context.setAttribute("VGACTIVEMODE", (Object)vgActiveMode);
        context.setAttribute("CLUSTER_TYPE", (Object)clusterType);
        List<IDeviceProcessor> deviceProcesses = this.filterProcessorList(context, "processOrder");
        for (IDeviceProcessor processor : deviceProcesses) {
            LOGGER.debug((Object)("begin processor:" + processor.getName()), 90160758786988L);
            processor.process(context);
            LOGGER.debug((Object)("end processor:" + processor.getName()), 90160758786988L);
        }
    }

    public void executeUmountProcessors(DrHost drHost, List<HostDeviceStorageInfo> hostDeviceStorageInfos, DrmAppEnumDefine.CLUSTER_TYPE_E clusterType) {
        NeMgrProtocolExtend extend = DrHostUtil.getNeMgrProtocolExtend(NeMgrProtocolExtendServiceUtil.getNeMgrExtendService(), drHost.getDeviceSn());
        RecoveryProcessorContext context = new RecoveryProcessorContext();
        context.setAttribute("HOST_INFO", (Object)drHost);
        context.setAttribute("HOST_DEVICE_INFO", hostDeviceStorageInfos);
        context.setAttribute("HOST_AUTH_INFO", (Object)extend);
        context.setAttribute("CLUSTER_TYPE", (Object)clusterType);
        List<IDeviceProcessor> deviceProcesses = this.filterProcessorList(context, "cleanOrder");
        for (IDeviceProcessor processor : deviceProcesses) {
            LOGGER.debug((Object)("begin clean:" + processor.getName()), 90160758786988L);
            processor.clean(context);
            LOGGER.debug((Object)("end clean:" + processor.getName()), 90160758786988L);
        }
    }

    private List<IDeviceProcessor> filterProcessorList(RecoveryProcessorContext context, String sortField) {
        ArrayList<IDeviceProcessor> deviceProcesses = new ArrayList<IDeviceProcessor>();
        for (IDeviceProcessor process : this.deviceProcessList) {
            if (!process.needProcess(context)) continue;
            LOGGER.debug((Object)("Filter process name is " + process.getName()));
            deviceProcesses.add(process);
        }
        Collections.sort(deviceProcesses, new CommonComparator(sortField, true, true));
        return deviceProcesses;
    }
}

