/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.device.process;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.drm.app.sdk.model.HostDeviceStorageInfo;
import com.huawei.ism.drm.host.agent.action.DeviceAction;
import com.huawei.ism.drm.host.device.process.IDeviceProcessor;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import java.util.List;

public class AsmlibProcessor
implements IDeviceProcessor {
    private static final int PROCESS_ORDER = 190;
    private static final int CLEAN_ORDER = 999;

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public boolean process(RecoveryProcessorContext context) {
        NeMgrProtocolExtend neMgrExtend = (NeMgrProtocolExtend)context.getAttribute("HOST_AUTH_INFO");
        List hostDeviceStorageInfos = (List)context.getAttribute("HOST_DEVICE_INFO");
        DrHost drHost = (DrHost)context.getAttribute("HOST_INFO");
        if (this.hasAsmlib(hostDeviceStorageInfos)) {
            DeviceAction deviceAction = new DeviceAction(neMgrExtend, drHost.getDeviceSn());
            deviceAction.preAsmlib();
        }
        return true;
    }

    @Override
    public boolean clean(RecoveryProcessorContext context) {
        return true;
    }

    private boolean hasAsmlib(List<HostDeviceStorageInfo> hostDeviceStorageInfos) {
        boolean hasAsmlib = false;
        for (HostDeviceStorageInfo hostDeviceStorageInfo : hostDeviceStorageInfos) {
            if (hostDeviceStorageInfo.getStorageType() != 2) continue;
            hasAsmlib = true;
            break;
        }
        return hasAsmlib;
    }

    @Override
    public boolean needProcess(RecoveryProcessorContext context) {
        List hostDeviceStorageInfos = (List)context.getAttribute("HOST_DEVICE_INFO");
        return this.hasAsmlib(hostDeviceStorageInfos);
    }

    @Override
    public int getProcessOrder() {
        return 190;
    }

    @Override
    public int getCleanOrder() {
        return 999;
    }
}

