/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.device.process;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.app.constants.DrmAppEnumDefine;
import com.huawei.ism.drm.app.sdk.model.HostDeviceStorageInfo;
import com.huawei.ism.drm.host.agent.action.DeviceAction;
import com.huawei.ism.drm.host.device.process.IDeviceProcessor;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.util.DrHostDeviceUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class RawProcessor
implements IDeviceProcessor {
    private static final Log LOGGER = LogFactory.getInstance(RawProcessor.class);
    private static final int PROCESS_ORDER = 160;
    private static final int CLEAN_ORDER = 120;

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public boolean process(RecoveryProcessorContext context) {
        NeMgrProtocolExtend neMgrExtend = (NeMgrProtocolExtend)context.getAttribute("HOST_AUTH_INFO");
        List hostDeviceStorageInfos = (List)context.getAttribute("HOST_DEVICE_INFO");
        DrHost drHost = (DrHost)context.getAttribute("HOST_INFO");
        List<HostDeviceStorageInfo> rawStorageInfos = this.buildRawStorageInfos(hostDeviceStorageInfos);
        if (VerifyUtil.isEmpty(rawStorageInfos)) {
            return true;
        }
        this.updateAixAndHPUXDevPath(drHost.getOsType(), rawStorageInfos);
        try {
            DeviceAction deviceAction = new DeviceAction(neMgrExtend, drHost.getDeviceSn());
            deviceAction.createRaws(rawStorageInfos);
        }
        catch (LegoCheckedException legoEx) {
            LOGGER.error((Object)legoEx.getMessage(), (Throwable)legoEx, 90160758787071L);
            Map<String, List<HostDeviceStorageInfo>> storageInfoMap = DrHostDeviceUtil.buildStorageInfoMapByWwn(rawStorageInfos);
            DrHostDeviceUtil.parseAndUpdateStorageErrorCodeInfo(legoEx, "wwn", storageInfoMap);
            return false;
        }
        return true;
    }

    @Override
    public boolean clean(RecoveryProcessorContext context) {
        NeMgrProtocolExtend neMgrExtend = (NeMgrProtocolExtend)context.getAttribute("HOST_AUTH_INFO");
        List hostDeviceStorageInfos = (List)context.getAttribute("HOST_DEVICE_INFO");
        DrHost drHost = (DrHost)context.getAttribute("HOST_INFO");
        List<HostDeviceStorageInfo> rawStorageInfos = this.buildRawStorageInfos(hostDeviceStorageInfos);
        if (VerifyUtil.isEmpty(rawStorageInfos)) {
            return true;
        }
        this.updateAixAndHPUXDevPath(drHost.getOsType(), rawStorageInfos);
        try {
            DeviceAction deviceAction = new DeviceAction(neMgrExtend, drHost.getDeviceSn());
            deviceAction.deleteRaws(rawStorageInfos);
        }
        catch (LegoCheckedException legoEx) {
            LOGGER.error((Object)legoEx.getMessage(), (Throwable)legoEx, 90160758787071L);
            Map<String, List<HostDeviceStorageInfo>> storageInfoMap = DrHostDeviceUtil.buildStorageInfoMapByWwn(rawStorageInfos);
            DrHostDeviceUtil.parseAndUpdateStorageErrorCodeInfo(legoEx, "wwn", storageInfoMap);
            return false;
        }
        return true;
    }

    private List<HostDeviceStorageInfo> buildRawStorageInfos(List<HostDeviceStorageInfo> hostDeviceStorageInfos) {
        ArrayList<HostDeviceStorageInfo> rawStorageInfos = new ArrayList<HostDeviceStorageInfo>();
        for (HostDeviceStorageInfo hostDeviceStorageInfo : hostDeviceStorageInfos) {
            int storageType = hostDeviceStorageInfo.getStorageType();
            int storageSubType = hostDeviceStorageInfo.getStorageSubType();
            if (storageType != 3 && storageType != 1 || storageSubType != 0) continue;
            if (hostDeviceStorageInfo.getErrorCode() != 0L) {
                LOGGER.warn((Object)("The storage info(wwn: " + hostDeviceStorageInfo.getWwn() + ", deviceName" + hostDeviceStorageInfo.getDeviceName() + ") has error, errorCode: " + hostDeviceStorageInfo.getErrorCode()), 90160758786989L);
                continue;
            }
            rawStorageInfos.add(hostDeviceStorageInfo);
        }
        return rawStorageInfos;
    }

    @Override
    public boolean needProcess(RecoveryProcessorContext context) {
        List hostDeviceStorageInfos = (List)context.getAttribute("HOST_DEVICE_INFO");
        DrHost drHost = (DrHost)context.getAttribute("HOST_INFO");
        Integer iOsType = NumberUtil.parseInteger((Object)drHost.getOsType());
        DrmAppEnumDefine.OS_TYPE_E osType = DrmAppEnumDefine.OS_TYPE_E.getType((int)iOsType);
        if (DrmAppEnumDefine.OS_TYPE_E.WINDOWS == osType) {
            return false;
        }
        return !VerifyUtil.isEmpty(this.buildRawStorageInfos(hostDeviceStorageInfos));
    }

    private void updateAixAndHPUXDevPath(String osType, List<HostDeviceStorageInfo> rawStorageInfos) {
        Integer iOsType = NumberUtil.parseInteger((Object)osType);
        DrmAppEnumDefine.OS_TYPE_E eOsType = DrmAppEnumDefine.OS_TYPE_E.getType((int)iOsType);
        List<DrmAppEnumDefine.OS_TYPE_E> supportOs = Arrays.asList(DrmAppEnumDefine.OS_TYPE_E.AIX, DrmAppEnumDefine.OS_TYPE_E.HPUX, DrmAppEnumDefine.OS_TYPE_E.SOLARIS);
        if (!supportOs.contains(eOsType)) {
            return;
        }
        for (HostDeviceStorageInfo rawStorageInfo : rawStorageInfos) {
            String deviceName;
            if (this.isMknode(rawStorageInfo) || null == (deviceName = rawStorageInfo.getDeviceName()) || deviceName.length() < 5) continue;
            this.dealAixProDevice(rawStorageInfo, osType);
            String devName = rawStorageInfo.getDeviceName().substring(5);
            String devPath = "/dev/r" + devName;
            rawStorageInfo.setMountPoint(devPath);
        }
    }

    private void dealAixProDevice(HostDeviceStorageInfo rawStorageInfo, String iOsType) {
        int osType = Integer.parseInt(iOsType);
        if (DrmAppEnumDefine.OS_TYPE_E.AIX.getValue() == osType) {
            String deviceName = rawStorageInfo.getProDeviceName();
            if (deviceName.contains("/dev/hdisk")) {
                return;
            }
            rawStorageInfo.setDeviceName(deviceName);
        }
    }

    private boolean isMknode(HostDeviceStorageInfo rawStorageInfo) {
        String mountPoint;
        String deviceName = rawStorageInfo.getProDeviceName();
        if (null == deviceName || deviceName.length() < 5) {
            return false;
        }
        String devName = deviceName.substring(5);
        String devPath = "/dev/r" + devName;
        return !devPath.equals(mountPoint = rawStorageInfo.getMountPoint());
    }

    @Override
    public int getProcessOrder() {
        return 160;
    }

    @Override
    public int getCleanOrder() {
        return 120;
    }
}

