/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.device.process;

import com.huawei.ism.base.sdk.model.Disk;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.app.constants.DrmAppEnumDefine;
import com.huawei.ism.drm.app.sdk.model.DiskPartition;
import com.huawei.ism.drm.app.sdk.model.HostDeviceStorageInfo;
import com.huawei.ism.drm.host.agent.action.HostAction;
import com.huawei.ism.drm.host.device.process.AbstractDiskProcessor;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.util.DrHostDeviceUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WindowsDiskProcessor
extends AbstractDiskProcessor {
    private static final Log LOGGER = LogFactory.getInstance(WindowsDiskProcessor.class);
    private static final long SLEEP_TIME_AFTER_ONLINEDISK = 30000L;

    @Override
    protected void updateDeviceName(RecoveryProcessorContext context, DrHost drHost, List<HostDeviceStorageInfo> hostDeviceStorageInfos, Map<String, List<Disk>> diskMap, HostAction hostAction, boolean isClean) {
        int osType = NumberUtil.parseInteger((Object)drHost.getOsType());
        if (1 != osType) {
            LOGGER.info((Object)"current os type is windows.", 90160758786989L);
            return;
        }
        DrmAppEnumDefine.CLUSTER_TYPE_E clustertype = (DrmAppEnumDefine.CLUSTER_TYPE_E)context.getAttribute("CLUSTER_TYPE");
        if (!isClean && DrmAppEnumDefine.CLUSTER_TYPE_E.SQL_SERVER_MSFC != clustertype) {
            Set<String> diskNumbers = this.getDiskNumbers(diskMap, hostDeviceStorageInfos);
            hostAction.onlineDisks(diskNumbers);
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)"sleep error.", 90160758786989L);
            }
        }
        List<DiskPartition> partitions = hostAction.queryPartitions();
        Map<String, List<DiskPartition>> diskNameMap = this.buildDiskNameMap(partitions);
        block2: for (HostDeviceStorageInfo hostDeviceStorageInfo : hostDeviceStorageInfos) {
            if (!DrHostDeviceUtil.isNeedUpdateDeviceName(hostDeviceStorageInfo.getDeviceName(), hostDeviceStorageInfo.getStorageSubType(), hostDeviceStorageInfo.getUdevRules())) continue;
            List<Disk> disks = DrHostDeviceUtil.getDiskByStorageInfo(hostDeviceStorageInfo, diskMap);
            if (null == disks || disks.isEmpty()) {
                String key = hostDeviceStorageInfo.getDeviceId() + "_" + hostDeviceStorageInfo.getLunId() + "_" + hostDeviceStorageInfo.getSnapshotId();
                LOGGER.error((Object)("Cannot find the disk(key:" + key + ", wwn:" + hostDeviceStorageInfo.getWwn() + ")"), 90160758786989L);
                continue;
            }
            List<DiskPartition> partitionList = diskNameMap.get(disks.get(0).getDiskBusID());
            String lba = hostDeviceStorageInfo.getLbaAddress();
            if (VerifyUtil.isEmpty(partitionList) || VerifyUtil.isEmpty((String)lba)) {
                LOGGER.error((Object)("Lba or partitionList info is empty(diskName:" + disks.get(0).getDiskName() + ", wwn:" + hostDeviceStorageInfo.getWwn() + ")"), 90160758786989L);
                continue;
            }
            for (DiskPartition partition : partitionList) {
                if (!lba.equals(partition.getLba())) continue;
                hostDeviceStorageInfo.setDeviceName(partition.getDeviceName());
                continue block2;
            }
        }
    }

    private Map<String, List<DiskPartition>> buildDiskNameMap(List<DiskPartition> partitions) {
        HashMap<String, List<DiskPartition>> diskNameMap = new HashMap<String, List<DiskPartition>>();
        if (VerifyUtil.isEmpty(partitions)) {
            LOGGER.error((Object)"DiskPartition is empty.", 90160758786989L);
            return diskNameMap;
        }
        for (DiskPartition partition : partitions) {
            ArrayList<DiskPartition> partitionList = (ArrayList<DiskPartition>)diskNameMap.get(partition.getDiskName());
            if (null == partitionList) {
                partitionList = new ArrayList<DiskPartition>();
                diskNameMap.put(partition.getDiskName(), partitionList);
            }
            partitionList.add(partition);
        }
        return diskNameMap;
    }

    private Set<String> getDiskNumbers(Map<String, List<Disk>> diskMap, List<HostDeviceStorageInfo> hostDeviceStorageInfos) {
        HashSet<String> diskNumbers = new HashSet<String>();
        for (HostDeviceStorageInfo hostDeviceStorageInfo : hostDeviceStorageInfos) {
            String key;
            List<Disk> disks;
            String mountDiskNum = hostDeviceStorageInfo.getSnapshotId();
            if (VerifyUtil.isEmpty((String)mountDiskNum) || "null".equals(mountDiskNum)) {
                mountDiskNum = hostDeviceStorageInfo.getLunId();
            }
            if (null == (disks = diskMap.get(key = hostDeviceStorageInfo.getDeviceId() + "_" + mountDiskNum)) && !VerifyUtil.isEmpty((String)hostDeviceStorageInfo.getWwn())) {
                disks = diskMap.get(hostDeviceStorageInfo.getWwn());
            }
            if (VerifyUtil.isEmpty(disks)) continue;
            diskNumbers.add(disks.get(0).getDiskBusID());
        }
        return diskNumbers;
    }

    @Override
    public boolean needProcess(RecoveryProcessorContext context) {
        DrHost drHost = (DrHost)context.getAttribute("HOST_INFO");
        Integer osType = NumberUtil.parseInteger((Object)drHost.getOsType());
        return DrmAppEnumDefine.OS_TYPE_E.WINDOWS == DrmAppEnumDefine.OS_TYPE_E.getType((int)osType);
    }
}

