/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.discovery.msg;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.comm.internal.jms.MessageRegister;
import com.huawei.lego.comm.internal.jms.MessageTaskManager;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;

public class StorageMessageSubscriber
extends MessageTaskManager {
    private static final Log LOGGER = LogFactory.getInstance(StorageMessageSubscriber.class);

    public StorageMessageSubscriber(IMessageCenter msgCenter) {
        msgCenter.addSubscriberTo((MessageTaskManager)this);
    }

    public MessageRegister[] getTypes() {
        MessageRegister[] mrs = MessageRegister.getMessageRegisters((int)1);
        mrs[0].setMessageTopic(MessageTopic.DATA);
        mrs[0].addMessageCode(107L);
        return mrs;
    }

    public void onMessage(MessageUnit mu) {
        long msgType = mu.getCmdcode();
        if (107L != msgType) {
            LOGGER.error((Object)("Message was not subscribed, msgType: " + msgType), 90160758786876L);
            return;
        }
        Object msg = mu.getObj();
        if (!(msg instanceof Map)) {
            return;
        }
        Map objs = (Map)msg;
        for (Object obj : objs.values()) {
            NetworkEntity ne = (NetworkEntity)obj;
            try {
                this.updateProtectObjectNameByStorage(ne.getSn());
            }
            catch (Exception ex) {
                LOGGER.error((Object)("update protectobject in msg subscriber failed, Name: " + ne.getName() + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160758786876L);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void updateProtectObjectNameByStorage(String devSn) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<ProtectObject> loadProtectObjectList(Session session, String devSn) {
        String hql = "select UUID,MOUUID,PONAME,POTYPE,PROVIDERSN,PGID from ti_protectobject where PROVIDERSN=:devSn";
        NativeQuery query = session.createSQLQuery(hql);
        query.setString("devSn", devSn);
        List result = query.list();
        if (result.isEmpty()) {
            return new ArrayList<ProtectObject>();
        }
        ArrayList<ProtectObject> protectObjectList = new ArrayList<ProtectObject>();
        for (int i = 0; i < result.size(); ++i) {
            Object[] data = (Object[])result.get(i);
            ProtectObject po = new ProtectObject();
            po.setUuid((String)data[1]);
            po.setName((String)data[2]);
            po.getProps().put("PG_ID", (String)data[5]);
            protectObjectList.add(po);
        }
        return protectObjectList;
    }

    private void updateProtectObjectName(Session session, List<ProtectObject> protectObjectList, Map<String, ManagedObject> moMap) {
        for (ProtectObject po : protectObjectList) {
            String uuid = po.getUuid();
            String oldName = po.getName();
            ManagedObject mo = moMap.get(uuid);
            if (null == mo) {
                LOGGER.error((Object)("managed object is null.uuid=" + uuid));
                throw new LegoCheckedException(1073947393L);
            }
            String newPoName = mo.getName();
            if (oldName.equals(newPoName)) continue;
            String sql = "UPDATE ti_protectobject SET PONAME=:newName WHERE MOUUID=:uuid";
            session.beginTransaction();
            NativeQuery query = session.createSQLQuery(sql);
            query.setString("newName", newPoName);
            query.setString("uuid", uuid);
            int updateResult = query.executeUpdate();
            session.getTransaction().commit();
            if (1 == updateResult) continue;
            LOGGER.error((Object)"Update ProtectObject name failed!", 90160758786989L);
        }
    }

    private Map<String, ManagedObject> getMoMapfromPoList(List<ProtectObject> protectObjectList) {
        String[] uuids = new String[protectObjectList.size()];
        HashMap<String, ManagedObject> moMap = new HashMap<String, ManagedObject>();
        for (int i = 0; i < protectObjectList.size(); ++i) {
            ProtectObject po = protectObjectList.get(i);
            uuids[i] = po.getUuid();
        }
        HashMap<String, String[]> props = new HashMap<String, String[]>();
        props.put("uuid", uuids);
        List moList = CommonDAOLocator.getMoDao().findMoBy(ManagedObject.class, props);
        for (ManagedObject mo : moList) {
            moMap.put(mo.getUuid(), mo);
        }
        return moMap;
    }
}

