/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.discovery.synchronizer;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.commons.DiscoverContext;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.CommonTemplate;
import com.huawei.ism.cbb.discover.framework.CommonTemplateManager;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.host.util.DrHostValidUtil;
import com.huawei.ism.drm.license.sdk.ILicenseControl;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.host.sdk.model.Host;
import com.huawei.lego.cbb.resource.sdk.model.Node;
import com.huawei.lego.com.south.sdk.model.SnmpPara;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.mediation.synchronize.AbstractSynchronizer;
import com.huawei.lego.core.sdk.mediation.synchronize.model.MoListOrMap;
import com.huawei.lego.core.sdk.mediation.synchronize.model.SynchronizeParameter;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HostSynchronizer
extends AbstractSynchronizer {
    private static final Log LOGGER = LogFactory.getInstance(HostSynchronizer.class);

    public MoListOrMap synchronizeDataAndConstructMo(SynchronizeParameter param, MoListOrMap moListOrMap) {
        CommonTemplate discoverTemplate;
        LOGGER.info((Object)"this is HostSynchronizer");
        if (null == param || null == param.getDiscoveryPolicy()) {
            LOGGER.error((Object)"param or param.getDiscoveryPolicy() is null.");
            throw new LegoCheckedException(1073947393L);
        }
        ILicenseControl licenseControl = (ILicenseControl)ServiceLocator.getInstance().getService(ILicenseControl.class);
        param.getDiscoveryPolicy().setLocation(param.getLocation());
        NeMgrProtocolExtend extend = new NeMgrProtocolExtend();
        Host host = new Host();
        Host hostExist = this.getExistHost(param.getDeviceIp());
        if (null == hostExist) {
            discoverTemplate = this.discovery(param, host, licenseControl);
        } else {
            discoverTemplate = this.refresh(host, hostExist);
            INeMgrProtocolExtendService neMgr = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
            long moId = hostExist.getMoId();
            extend = neMgr.findByMoId(Long.valueOf(moId));
        }
        this.checkAndSetParam(param, extend, host);
        DiscoverContext context = new DiscoverContext(param, moListOrMap);
        context.setAttribute("StorageDevice", (Object)host);
        context.setAttribute("DiscoveryType", (Object)"register");
        context.setAttribute("NeMgrProtocolExtend", (Object)extend);
        context.setAttribute("OPERATORID", (Object)param.getDiscoveryPolicy().getOperatorId());
        discoverTemplate.process((AbstractContext)context);
        licenseControl.checkLicenseOutOfControlAlarm(true);
        return null;
    }

    private CommonTemplate refresh(Host host, Host hostExist) {
        host.setLinkIp(hostExist.getLinkIp());
        host.setUuid(hostExist.getUuid());
        host.setSn(hostExist.getUuid());
        return CommonTemplateManager.getInstance().getRefreshTemplateByDeviceType("Dr_Host");
    }

    private CommonTemplate discovery(SynchronizeParameter param, Host host, ILicenseControl licenseControl) {
        licenseControl.checkLicenseEnable("LSTQDPMN", 1);
        host.setLinkIp(param.getDeviceIp());
        host.setUuid(param.getDeviceIp());
        host.setSn(host.getUuid());
        return CommonTemplateManager.getInstance().getDiscoverTemplateByDeviceType("Dr_Host");
    }

    private void checkAndSetParam(SynchronizeParameter param, NeMgrProtocolExtend extend, Host host) {
        Map paramMap = param.getDiscoveryPolicy().getParamMap();
        if (paramMap == null) {
            LOGGER.error((Object)"Failed to discover host because of invalidity parameter");
            throw new LegoCheckedException(1073947393L);
        }
        String uName = (String)paramMap.get("username");
        String port = (String)paramMap.get("port");
        String pwd = (String)paramMap.get("password");
        if (!(CommUtil.checkDrmIpParam((String)param.getDeviceIp()) && DrHostValidUtil.checkUserName(uName) && DrHostValidUtil.checkPort(port) && DrHostValidUtil.checkPwd(pwd))) {
            LOGGER.error((Object)"Failed to discover host because of invalidity parameter");
            throw new LegoCheckedException(1073947393L);
        }
        extend.setNetworkIpAddress(param.getDeviceIp());
        extend.setNetworkUserName((String)paramMap.get("username"));
        extend.setNetworkPassword((String)paramMap.get("password"));
        if (extend.getExtendParams() == null) {
            HashMap extParam = new HashMap();
            extParam.put("port", paramMap.get("port"));
            extParam.put("isAgentless", paramMap.get("isAgentless"));
            extParam.put("hostKey", paramMap.get("hostKey"));
            extend.setExtendParams(extParam);
        } else {
            extend.getExtendParams().put("port", paramMap.get("port"));
            extend.getExtendParams().put("isAgentless", paramMap.get("isAgentless"));
            extend.getExtendParams().put("hostKey", paramMap.get("hostKey"));
        }
        this.setManagementProtocolMap(host, paramMap, extend);
    }

    private Host getExistHost(String ip) {
        Host result = null;
        List<String> sns = DrHostUtil.getHostDiscoveryHost(ip);
        if (!VerifyUtil.isEmpty(sns)) {
            String sn = sns.get(0);
            if (null == sn) {
                LOGGER.error((Object)"sn is not exist");
                throw new LegoCheckedException(1073947393L);
            }
            result = (Host)CommonDAOLocator.getMoDao().getMo(Host.class, "hostSN", (Object)sn);
        }
        return result;
    }

    private void setManagementProtocolMap(Host host, Map<String, String> paramMap, NeMgrProtocolExtend extend) {
        if (null == paramMap.get("snmpVersion")) {
            return;
        }
        try {
            paramMap.put("snmpContextEngineId", "");
            SnmpPara snmpPara = new SnmpPara();
            snmpPara.setAuthProtocol(paramMap.get("snmpAuthProtocol"));
            snmpPara.setAuthPwd(paramMap.get("snmpAuthPwd"));
            snmpPara.setContextEngineId(paramMap.get("snmpContextEngineId"));
            snmpPara.setContextName(paramMap.get("snmpContextName"));
            snmpPara.setEncryptProtocol(paramMap.get("snmpEncryptProtocol"));
            snmpPara.setEncryptPwd(paramMap.get("snmpEncryptPwd"));
            snmpPara.setRetries(NumberUtil.convertToInteger((Object)paramMap.get("snmpRetries")).intValue());
            snmpPara.setSecurityName(paramMap.get("snmpSecurityName"));
            snmpPara.setTimeout(NumberUtil.convertToInteger((Object)paramMap.get("snmpTimeout")).intValue());
            if (!"SNMPv3".equalsIgnoreCase(paramMap.get("snmpVersion"))) {
                return;
            }
            snmpPara.setVersion(3);
            snmpPara.setPort(NumberUtil.convertToInteger((Object)paramMap.get("snmpPort")).intValue());
            snmpPara.setNode((Node)host);
            HashMap<String, SnmpPara> protocolMap = new HashMap<String, SnmpPara>();
            protocolMap.put(SnmpPara.class.getName(), snmpPara);
            host.setManagementProtocolMap(protocolMap);
            this.setSnmpParam(extend, paramMap, "snmpAuthProtocol");
            this.setSnmpParam(extend, paramMap, "snmpAuthPwd");
            this.setSnmpParam(extend, paramMap, "snmpContextName");
            this.setSnmpParam(extend, paramMap, "snmpEncryptProtocol");
            this.setSnmpParam(extend, paramMap, "snmpEncryptPwd");
            this.setSnmpParam(extend, paramMap, "snmpContextEngineId");
            this.setSnmpParam(extend, paramMap, "snmpPort");
            this.setSnmpParam(extend, paramMap, "snmpRetries");
            this.setSnmpParam(extend, paramMap, "snmpSecurityName");
            this.setSnmpParam(extend, paramMap, "snmpTimeout");
            this.setSnmpParam(extend, paramMap, "snmpVersion");
        }
        catch (Exception e) {
            LOGGER.error((Object)("set snmp param exception." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786880L);
        }
    }

    private void setSnmpParam(NeMgrProtocolExtend extend, Map<String, String> snmpParam, String key) {
        String object = snmpParam.get(key);
        extend.getExtendParams().put(key, object);
    }
}

