/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.protection.action;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.common.sdk.model.ScriptSchemeDefTemplate;
import com.huawei.ism.drm.common.sdk.model.ScriptSchemeStep;
import com.huawei.ism.drm.host.protection.action.PostProcessScriptAction;
import com.huawei.ism.drm.host.protection.action.PreProcessScriptAction;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.action.service.IHostScriptSchemeService;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectExtendAction;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.util.ScriptParamsUtils;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BaseExecScriptAction
extends AbstractBaseProtectExtendAction {
    protected static final String SCRIPT_NAME = "scriptName";
    protected static final String HOSTSN = "hostId";
    protected static final String IS_USER_DEFINED = "isUserDefined";
    protected static final String PUBLIC_PARAMS = "publicParam";
    protected static final String BEFORE_PARAMS = "beforeParam";
    protected static final String USER_BEFORE_PARAMS = "userBeforeParam";
    protected static final String AFTER_PARAMS = "afterParam";
    protected static final String USER_AFTER_PARAMS = "userAfterParam";
    protected static final String PROTECTGROUP_ID = "protectGroupId";
    protected static final String SCHEME_ID = "schemeId";
    private static final Log LOGGER = LogFactory.getInstance(BaseExecScriptAction.class);

    public boolean doExecute(ActionContext context) {
        List<String> result;
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        LOGGER.info((Object)("BaseExecScriptAction begin to execute,pgname=" + protectGroup.getName()), 90160758786988L);
        String hostSn = (String)this.getParams().get(HOSTSN);
        String scriptName = (String)this.getParams().get(SCRIPT_NAME);
        String isUserDefined = (String)this.getParams().get(IS_USER_DEFINED);
        if (VerifyUtil.isEmpty((String)hostSn) || VerifyUtil.isEmpty((String)scriptName)) {
            LOGGER.error((Object)"hostSn or scriptName is empty", 90160758786989L);
            this.setDetail("lego.err.1073947394");
            return false;
        }
        Map<Object, Object> scriptParams = new HashMap();
        if (protectGroup.getPoType() == 11 && protectGroup.getTemplate().getType() == 2) {
            scriptParams = this.getFrontScriptParams(context);
            if (this instanceof PreProcessScriptAction) {
                this.setBackScriptParams(context, scriptParams, BEFORE_PARAMS);
            } else if (this instanceof PostProcessScriptAction) {
                this.setBackScriptParams(context, scriptParams, AFTER_PARAMS);
            }
        }
        if (!(result = DrHostUtil.execThirdScript(hostSn, scriptName, isUserDefined, JSONObject.fromObject(scriptParams).toString())).isEmpty()) {
            LOGGER.error((Object)"BaseExecScriptAction error ", 90160758786989L);
            this.setDetail(result.get(0));
            return false;
        }
        return true;
    }

    public void checkParams(Map<String, String> param) {
        String hostSn = param.get(HOSTSN);
        String scriptName = param.get(SCRIPT_NAME);
        if (VerifyUtil.isEmpty((String)hostSn) || VerifyUtil.isEmpty((String)scriptName)) {
            LOGGER.error((Object)"params is null. hostSn:[%s]. scriptName:[%s]", new Object[]{hostSn, scriptName});
            throw new LegoCheckedException(1073947393L);
        }
        if (!this.validateScriptName(scriptName)) {
            LOGGER.error((Object)"scriptName is invalid. scriptName:[%s]", new Object[]{scriptName});
            throw new LegoCheckedException(1073947393L);
        }
        String osType = this.getOsTypeByHostSn(hostSn);
        if (!osType.equals("1") && scriptName.endsWith(".bat")) {
            LOGGER.error((Object)"script format error. scriptName:[%s]. osType:[%s]", new Object[]{scriptName, osType});
            throw new LegoCheckedException(1073948218L);
        }
        if (osType.equals("1") && !scriptName.endsWith(".bat")) {
            LOGGER.error((Object)"script format error. scriptName:[%s]. osType:[%s]", new Object[]{scriptName, osType});
            throw new LegoCheckedException(1073948218L);
        }
        this.checkScriptParams(param);
    }

    private void checkScriptParams(Map<String, String> param) {
        LOGGER.info((Object)"check action's script params of protect group.");
        String protectGroupId = param.get(PROTECTGROUP_ID);
        IProtectGroupService protectGroupService = (IProtectGroupService)ProtectionJobUtil.getInstance().getProtectGroupService();
        if (VerifyUtil.isEmpty((Object)protectGroupService)) {
            LOGGER.error((Object)"can't get protectGroupService.");
            throw new LegoCheckedException(102410L, IProtectGroupService.class.getName());
        }
        ProtectGroup protectGroup = protectGroupService.getProtectGroupByID(protectGroupId, false);
        String isUserDefined = param.get(IS_USER_DEFINED);
        LOGGER.info((Object)("action use script: " + isUserDefined));
        for (Schedule schedule : protectGroup.getTemplate().getSchedules()) {
            LOGGER.info((Object)("check schedule, type: " + schedule.getProtectedType() + ", name: " + schedule.getName()));
            if (ScheduleProtectedType.SNAPSHOT.getValue() != schedule.getProtectedType()) {
                LOGGER.debug((Object)"schedule is not snapshot.");
                continue;
            }
            Map props = schedule.getExtParameters();
            String schemeId = (String)props.get("scriptSchemeId");
            if (VerifyUtil.isEmpty((String)schemeId) && "0".equals(isUserDefined)) {
                LOGGER.error((Object)"do not allow to use script scheme when user use user-defined script");
                throw new LegoCheckedException(1073947393L);
            }
            IHostScriptSchemeService service = (IHostScriptSchemeService)ServiceLocator.getInstance().getService(IHostScriptSchemeService.class);
            ScriptSchemeDefTemplate scriptSchemeDefTemplate = service.queryScriptSchemeById(schemeId);
            String frontScriptParams = "";
            String backScriptParams = "";
            String userScriptParams = "";
            if (this instanceof PreProcessScriptAction) {
                LOGGER.debug((Object)"check params of previous processor action.");
                this.checkScriptExistInScriptScheme(isUserDefined, scriptSchemeDefTemplate, "protect-before");
                frontScriptParams = param.get(BEFORE_PARAMS);
                backScriptParams = (String)props.get(BEFORE_PARAMS);
                userScriptParams = param.get(USER_BEFORE_PARAMS);
            } else if (this instanceof PostProcessScriptAction) {
                LOGGER.debug((Object)"check params of post processor action.");
                this.checkScriptExistInScriptScheme(isUserDefined, scriptSchemeDefTemplate, "protect-after");
                frontScriptParams = param.get(AFTER_PARAMS);
                backScriptParams = (String)props.get(AFTER_PARAMS);
                userScriptParams = param.get(USER_AFTER_PARAMS);
            }
            Map paramValidation = service.getParamValidation(schemeId);
            if (!"1".equals(isUserDefined)) {
                LOGGER.info((Object)"there need to check params for using script scheme.");
                ScriptParamsUtils.validateScriptParams((Map)paramValidation, (String)frontScriptParams);
            }
            ScriptParamsUtils.validateUserDefinedParams((String)userScriptParams);
            String scriptParams = ScriptParamsUtils.updateSensitiveParam((Map)paramValidation, (String)frontScriptParams, (String)backScriptParams);
            if (this instanceof PreProcessScriptAction) {
                param.put(BEFORE_PARAMS, scriptParams);
                param.put(USER_BEFORE_PARAMS, userScriptParams);
                continue;
            }
            if (!(this instanceof PostProcessScriptAction)) continue;
            param.put(AFTER_PARAMS, scriptParams);
            param.put(USER_AFTER_PARAMS, userScriptParams);
        }
    }

    private void checkScriptExistInScriptScheme(String isUserDefined, ScriptSchemeDefTemplate scriptSchemeDefTemplate, String position) {
        if (!"0".equals(isUserDefined)) {
            return;
        }
        if (!VerifyUtil.isEmpty((Object)scriptSchemeDefTemplate)) {
            List steps = scriptSchemeDefTemplate.getSteps();
            for (int i = 0; i < steps.size() && !position.equals(((ScriptSchemeStep)steps.get(i)).getPosition()); ++i) {
                if (i != steps.size() - 1) continue;
                LOGGER.error((Object)"steps size:[%s].i:[%s]", new Object[]{steps.size(), i});
                throw new LegoCheckedException(1073947393L);
            }
        }
    }

    private String getOsTypeByHostSn(String hostSn) {
        String osType;
        DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(hostSn);
        if (drResource == null) {
            throw new LegoCheckedException(1073947394L);
        }
        if (drResource instanceof DrHost) {
            DrHost host = (DrHost)drResource;
            osType = host.getOsType();
        } else {
            DrHostGroup hostgroup = (DrHostGroup)drResource;
            osType = hostgroup.getOsType();
        }
        return osType;
    }

    protected boolean validateScriptName(String scriptName) {
        if (!scriptName.endsWith(".sh") && !scriptName.endsWith(".bat")) {
            return false;
        }
        if (scriptName.length() < 4 || scriptName.length() > 32) {
            return false;
        }
        String match = "^[a-zA-Z0-9_\\u4e00-\\u9fa5]{1}[\\u4e00-\\u9fa5\\w-]*$";
        int lastDotIndex = scriptName.lastIndexOf(".");
        return CommUtil.checkParam((String)scriptName.substring(0, lastDotIndex), (String)match);
    }

    private Map<String, String> getFrontScriptParams(ActionContext context) {
        HashMap<String, String> scriptParams = new HashMap<String, String>();
        Schedule schedule = this.getSchedule(context);
        if (null == schedule) {
            LOGGER.info((Object)"schedule is null when get front script params.");
            return scriptParams;
        }
        Map extParameters = schedule.getExtParameters();
        String beforeScriptParam = (String)extParameters.get(BEFORE_PARAMS);
        String userBeforeScriptParam = (String)extParameters.get(USER_BEFORE_PARAMS);
        beforeScriptParam = ScriptParamsUtils.mergeParams((String)userBeforeScriptParam, (String)beforeScriptParam);
        String afterScriptParam = (String)extParameters.get(AFTER_PARAMS);
        String userAfterScriptParam = (String)extParameters.get(USER_AFTER_PARAMS);
        afterScriptParam = ScriptParamsUtils.mergeParams((String)userAfterScriptParam, (String)afterScriptParam);
        String isUserDefined = (String)this.getParams().get(IS_USER_DEFINED);
        scriptParams.put(IS_USER_DEFINED, isUserDefined);
        String publicScriptParam = (String)extParameters.get(PUBLIC_PARAMS);
        if ("1".equals(isUserDefined)) {
            LOGGER.info((Object)"there is no need to send public params where user use defined-self scripts.");
            publicScriptParam = "";
        }
        LOGGER.info((Object)"decrypt and merge params");
        String schemeId = (String)extParameters.get("scriptSchemeId");
        Map paramValidation = ((IHostScriptSchemeService)ServiceLocator.getInstance().getService(IHostScriptSchemeService.class)).getParamValidation(schemeId);
        publicScriptParam = ScriptParamsUtils.decryptSensitiveParam((Map)paramValidation, (String)publicScriptParam);
        scriptParams.put(BEFORE_PARAMS, ScriptParamsUtils.mergeParams((String)publicScriptParam, (String)ScriptParamsUtils.decryptSensitiveParam((Map)paramValidation, (String)beforeScriptParam)));
        scriptParams.put(AFTER_PARAMS, ScriptParamsUtils.mergeParams((String)publicScriptParam, (String)ScriptParamsUtils.decryptSensitiveParam((Map)paramValidation, (String)afterScriptParam)));
        return scriptParams;
    }

    protected void prepareActionParams(ActionContext context, String scriptTag, String paramTag, String userParamTag) {
        JSONObject params;
        ProtectGroup pg = (ProtectGroup)context.getObject("PG_ENTITY");
        int templateType = pg.getTemplate().getType();
        if (pg.getPoType() != 11 || templateType != 2 && templateType != 19) {
            LOGGER.info((Object)("execute pre-processor, pg id: " + pg.getUuid() + ", type: " + pg.getPoType() + ", template\uff1a " + pg.getTemplate()));
            return;
        }
        Schedule schedule = this.getSchedule(context);
        if (null == schedule) {
            LOGGER.info((Object)"schedule is empty, do not need execute pre-processor.");
            return;
        }
        Map extParameters = schedule.getExtParameters();
        String schemeId = (String)extParameters.get("scriptSchemeId");
        String hostSn = (String)extParameters.get("hostOrGroupId");
        String publicScriptParams = (String)extParameters.get(PUBLIC_PARAMS);
        if (this.getParams().containsKey("isEnableFlag") && "false".equals(this.getParams().get("isEnableFlag"))) {
            HashMap<String, String> newParams = new HashMap<String, String>();
            newParams.put("isEnableFlag", "false");
            newParams.put(SCHEME_ID, schemeId);
            newParams.put(HOSTSN, hostSn);
            newParams.put(PUBLIC_PARAMS, publicScriptParams);
            this.setParams(newParams);
            return;
        }
        String isUserDefined = "1";
        String paramsStr = (String)extParameters.get(paramTag);
        if (!VerifyUtil.isEmpty((String)paramsStr) && (params = JSONObject.fromObject((Object)paramsStr)).containsKey((Object)IS_USER_DEFINED)) {
            isUserDefined = params.getString(IS_USER_DEFINED);
        }
        if ("0".equals(isUserDefined)) {
            paramsStr = (String)extParameters.get(paramTag);
            Map paramValidation = ((IHostScriptSchemeService)ServiceLocator.getInstance().getService(IHostScriptSchemeService.class)).getParamValidation(schemeId);
            paramsStr = ScriptParamsUtils.filterSensitiveParam((Map)paramValidation, (String)paramsStr);
            publicScriptParams = ScriptParamsUtils.filterSensitiveParam((Map)paramValidation, (String)publicScriptParams);
        }
        String userScriptParams = (String)extParameters.get(userParamTag);
        JSONArray scriptArr = JSONArray.fromObject(extParameters.get(scriptTag));
        this.setEnable(!VerifyUtil.isEmpty((Collection)scriptArr));
        this.getParams().put(HOSTSN, hostSn);
        this.getParams().put(SCHEME_ID, schemeId);
        this.getParams().put(IS_USER_DEFINED, isUserDefined);
        this.getParams().put(SCRIPT_NAME, scriptArr.isEmpty() ? "" : scriptArr.getString(0));
        this.getParams().put(PUBLIC_PARAMS, publicScriptParams);
        this.getParams().put(paramTag, paramsStr);
        this.getParams().put(userParamTag, userScriptParams);
    }
}

