/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.host.recovery.process.DeleteSnapshotMappingProcessor;
import com.huawei.ism.drm.host.recovery.process.MappingNasSnapshotSubProcessor;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.MappingReplicaSubProcessorBuilderManager;
import com.huawei.ism.drm.recovery.process.IMappingReplicaSubProcessorBuilder;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.List;
import java.util.Set;

public class DeleteNasSnapshotMappingProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -1973949843446731390L;
    private static final Log LOGGER = LogFactory.getInstance(DeleteSnapshotMappingProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        ProtectGroupReplica replica = context.getProtectGroupReplica();
        if (replica == null) {
            LOGGER.error((Object)"replica is null!");
            throw new LegoCheckedException(1073947393L);
        }
        MappingReplicaSubProcessorBuilderManager manager = MappingReplicaSubProcessorBuilderManager.getInstance();
        IMappingReplicaSubProcessorBuilder builder = manager.getBuider(this.getTargetReplicaType(replica));
        List<RecoveryProcessor> mappingReplicaProcessors = this.queryMappingReplicaProcessor(context);
        if (VerifyUtil.isEmpty(mappingReplicaProcessors)) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        Set processors = builder.buildDeleteMappingProcessor((RecoveryProcessor)this, mappingReplicaProcessors);
        this.setChildProc(processors);
        return this.executeSubProcessor(context);
    }

    private List<RecoveryProcessor> queryMappingReplicaProcessor(RecoveryProcessorContext context) {
        DrmEnumDefine.RecoveryPlanExecuteTypeE lastRunType = DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA;
        return this.getRecoveryProcessors(context.getRecoveryPlan(), lastRunType, MappingNasSnapshotSubProcessor.class);
    }

    private int getTargetReplicaType(ProtectGroupReplica replica) {
        int targetReplicaType = replica.getType();
        if (targetReplicaType != 14) {
            targetReplicaType = 14;
        }
        return targetReplicaType;
    }
}

