/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.sdk.model.NasSnapshotClone;
import com.huawei.ism.drm.storage.util.NasCloneUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;

public class DeleteNasSnapshotMappingSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -8124823283913929666L;
    private static final Log LOGGER = LogFactory.getInstance(DeleteNasSnapshotMappingSubProcessor.class);
    private String deviceId;
    private String snapshotId;
    private String snapshotName;
    private String hostOrGroupId;
    private String hostOrGroupName;
    private NasSnapshotClone nasSnapshotClone;

    protected boolean execute(RecoveryProcessorContext context) {
        String id = this.nasSnapshotClone.getId();
        String shareType = this.nasSnapshotClone.getShareType();
        try {
            this.updateProcessNameParams(new String[]{id, shareType});
            boolean result = NasCloneUtil.deleteShare((RecoveryProcessorContext)context, (NasSnapshotClone)this.nasSnapshotClone);
            if (!result) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                this.updateProcessDetail("lego.err.1677929220", new String[0]);
                return false;
            }
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Delete share failed, fsId:%s, shareType:%s, error:%s.", new Object[]{id, shareType, ExceptionUtil.getErrorMessage((Throwable)e)});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail(e);
            return false;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Delete share  failed, fsId:%s, shareType:%s, error:%s.", new Object[]{id, shareType, ExceptionUtil.getErrorMessage((Throwable)e)});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("lego.err.-1", new String[0]);
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }

    protected String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public String getHostOrGroupId() {
        return this.hostOrGroupId;
    }

    public String getHostOrGroupName() {
        return this.hostOrGroupName;
    }

    public NasSnapshotClone getNasSnapshotClone() {
        return this.nasSnapshotClone;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    public void setSnapshotName(String snapshotName) {
        this.snapshotName = snapshotName;
    }

    public void setHostOrGroupId(String hostOrGroupId) {
        this.hostOrGroupId = hostOrGroupId;
    }

    public void setHostOrGroupName(String hostOrGroupName) {
        this.hostOrGroupName = hostOrGroupName;
    }

    public void setNasSnapshotClone(NasSnapshotClone nasSnapshotClone) {
        this.nasSnapshotClone = nasSnapshotClone;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteNasSnapshotMappingSubProcessor)) {
            return false;
        }
        DeleteNasSnapshotMappingSubProcessor other = (DeleteNasSnapshotMappingSubProcessor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$deviceId = this.getDeviceId();
        String other$deviceId = other.getDeviceId();
        if (this$deviceId == null ? other$deviceId != null : !this$deviceId.equals(other$deviceId)) {
            return false;
        }
        String this$snapshotId = this.getSnapshotId();
        String other$snapshotId = other.getSnapshotId();
        if (this$snapshotId == null ? other$snapshotId != null : !this$snapshotId.equals(other$snapshotId)) {
            return false;
        }
        String this$snapshotName = this.getSnapshotName();
        String other$snapshotName = other.getSnapshotName();
        if (this$snapshotName == null ? other$snapshotName != null : !this$snapshotName.equals(other$snapshotName)) {
            return false;
        }
        String this$hostOrGroupId = this.getHostOrGroupId();
        String other$hostOrGroupId = other.getHostOrGroupId();
        if (this$hostOrGroupId == null ? other$hostOrGroupId != null : !this$hostOrGroupId.equals(other$hostOrGroupId)) {
            return false;
        }
        String this$hostOrGroupName = this.getHostOrGroupName();
        String other$hostOrGroupName = other.getHostOrGroupName();
        if (this$hostOrGroupName == null ? other$hostOrGroupName != null : !this$hostOrGroupName.equals(other$hostOrGroupName)) {
            return false;
        }
        NasSnapshotClone this$nasSnapshotClone = this.getNasSnapshotClone();
        NasSnapshotClone other$nasSnapshotClone = other.getNasSnapshotClone();
        return !(this$nasSnapshotClone == null ? other$nasSnapshotClone != null : !this$nasSnapshotClone.equals(other$nasSnapshotClone));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeleteNasSnapshotMappingSubProcessor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $deviceId = this.getDeviceId();
        result = result * 59 + ($deviceId == null ? 43 : $deviceId.hashCode());
        String $snapshotId = this.getSnapshotId();
        result = result * 59 + ($snapshotId == null ? 43 : $snapshotId.hashCode());
        String $snapshotName = this.getSnapshotName();
        result = result * 59 + ($snapshotName == null ? 43 : $snapshotName.hashCode());
        String $hostOrGroupId = this.getHostOrGroupId();
        result = result * 59 + ($hostOrGroupId == null ? 43 : $hostOrGroupId.hashCode());
        String $hostOrGroupName = this.getHostOrGroupName();
        result = result * 59 + ($hostOrGroupName == null ? 43 : $hostOrGroupName.hashCode());
        NasSnapshotClone $nasSnapshotClone = this.getNasSnapshotClone();
        result = result * 59 + ($nasSnapshotClone == null ? 43 : $nasSnapshotClone.hashCode());
        return result;
    }

    public String toString() {
        return "DeleteNasSnapshotMappingSubProcessor(deviceId=" + this.getDeviceId() + ", snapshotId=" + this.getSnapshotId() + ", snapshotName=" + this.getSnapshotName() + ", hostOrGroupId=" + this.getHostOrGroupId() + ", hostOrGroupName=" + this.getHostOrGroupName() + ", nasSnapshotClone=" + this.getNasSnapshotClone() + ")";
    }
}

