/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.recovery.process;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.sdk.service.IHostRetrieveProxy;
import com.huawei.ism.drm.protection.action.service.IHostScriptSchemeService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.util.ScriptParamsUtils;
import com.huawei.ism.host.sdk.model.Host;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DrmExecuteScriptSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -1047856563514903574L;
    private static final Log LOGGER = LogFactory.getInstance(DrmExecuteScriptSubProcessor.class);
    private String scriptName;
    private String pgId;
    private String hostId;

    public DrmExecuteScriptSubProcessor() {
        this.setIsNeedSave(false);
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public void setScriptName(String scriptName) {
        this.scriptName = scriptName;
    }

    public String getPgId() {
        return this.pgId;
    }

    public void setPgId(String pgId) {
        this.pgId = pgId;
    }

    public String getHostId() {
        return this.hostId;
    }

    public void setHostId(String hostId) {
        this.hostId = hostId;
    }

    protected boolean execute(RecoveryProcessorContext context) {
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        DrResource drResource = recoveryService.getDrResourceByID(this.hostId);
        if (VerifyUtil.isEmpty((Object)drResource)) {
            LOGGER.error((Object)"There is no disaster host.", 90160758784001L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        this.updateProcessNameParams(new String[]{drResource.getName(), this.scriptName});
        boolean result = this.executeThirdPartScript((DrHost)drResource, context);
        if (result) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        } else {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        }
        return true;
    }

    protected String generateResultKey() {
        StringBuilder builder = new StringBuilder();
        builder.append("ExecuteScript:");
        builder.append("HostId=");
        builder.append(this.hostId);
        builder.append(";");
        builder.append("PgId=");
        builder.append(this.pgId);
        return builder.toString();
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    JSONObject getScriptParams(RecoveryProcessorContext context) {
        return this.getProcessorParams(context);
    }

    private boolean executeThirdPartScript(DrHost drHost, RecoveryProcessorContext context) {
        ArrayList<String> results;
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        Host host = recoveryService.getHostByUuid(drHost.getDeviceSn());
        if (null == host) {
            LOGGER.error((Object)("The disaster host does not exist.SN:" + drHost.getDeviceSn() + ",Script name:" + this.scriptName), 90160758784001L);
            this.updateProcessDetail("lego.err.1073948686", new String[]{drHost.getDeviceSn()});
            return false;
        }
        INeMgrProtocolExtendService neMgrService = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
        NeMgrProtocolExtend neMgrProtocolExtend = neMgrService.findByMoId(host.getMoId());
        Object object = ServiceLocator.getInstance().getService(IHostRetrieveProxy.class);
        if (object == null) {
            throw new LegoCheckedException(-1L);
        }
        IHostRetrieveProxy hostRetrieveProxy = (IHostRetrieveProxy)object;
        try {
            LOGGER.info((Object)("Start to execute custom script. Script:" + this.scriptName + " Host name:" + drHost.getName()), 90160758784000L);
            JSONObject executeParams = this.getProcessorParams(context);
            results = hostRetrieveProxy.executeThirdPartScript(neMgrProtocolExtend, this.scriptName, executeParams.toString());
            LOGGER.info((Object)("End to execute custom script. Script:" + this.scriptName + " Name:" + drHost.getName() + ",Results:" + this.listToString(results)), 90160758784000L);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("Executing script failed. Name:" + drHost.getName() + ",Script:" + this.scriptName), (Throwable)e, 90160758784001L);
            results = new ArrayList<String>();
            results.add(e.getErrorMessageKey());
        }
        catch (Exception e) {
            LOGGER.error((Object)("Executing script failed. Name:" + drHost.getName() + ",Script:" + this.scriptName + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            results = new ArrayList();
            results.add("lego.err.-1");
        }
        if (!VerifyUtil.isEmpty(results)) {
            this.updateProcessDetail(this.listToString(results), new String[]{drHost.getName()});
            return false;
        }
        return true;
    }

    private JSONObject getProcessorParams(RecoveryProcessorContext context) {
        JSONObject jsonObject;
        HashMap props = new HashMap();
        IRecoveryPlanService planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        Set processors = planService.getRecoveryProcesses(context.getRecoveryPlan().getPlanId(), this.getProcType());
        for (RecoveryProcessDefinition definition : processors) {
            if (definition.getProcType() != this.getProcType()) continue;
            for (RecoveryProcessor processor : definition.getRecoveryProcessors()) {
                if (!processor.getProcId().equals(this.getParentProcId())) continue;
                props.putAll(processor.getProps());
            }
        }
        JSONObject executeParams = JSONObject.fromObject(props.get("STEP_PARAMS"));
        JSONObject processorParams = new JSONObject();
        String processorParamsStr = (String)context.getAttribute("ContextParams");
        if (!VerifyUtil.isEmpty((String)processorParamsStr) && null != (jsonObject = JSONObject.fromObject((Object)processorParamsStr))) {
            for (Object obj : jsonObject.entrySet()) {
                Map.Entry entry = (Map.Entry)obj;
                processorParams.put(entry.getKey(), entry.getValue());
            }
        }
        executeParams.putAll((Map)processorParams);
        String schemeId = (String)props.get("recoveryScriptSchemeId");
        executeParams = this.getExecuteParams(context, executeParams, schemeId);
        JSONObject params = new JSONObject();
        params.put((Object)"params", (Object)executeParams);
        Boolean isUserDefined = "true".equals(props.get("isUserDefined"));
        params.put((Object)"isUserDefined", (Object)(isUserDefined != false ? "1" : "0"));
        return params;
    }

    private JSONObject getExecuteParams(RecoveryProcessorContext context, JSONObject executeParams, String schemeId) {
        if (!VerifyUtil.isEmpty((String)schemeId)) {
            IHostScriptSchemeService schemeService = (IHostScriptSchemeService)ServiceLocator.getInstance().getService(IHostScriptSchemeService.class);
            Map paramValidation = schemeService.getParamValidation(schemeId);
            String decryptParams = ScriptParamsUtils.decryptSensitiveParam((Map)paramValidation, (String)executeParams.toString());
            executeParams = JSONObject.fromObject((Object)decryptParams);
            RecoveryPlan recoveryPlan = context.getRecoveryPlan();
            if (null == recoveryPlan) {
                LOGGER.error((Object)"getProcessorParams error, recoveryPlan is null.");
                throw new LegoCheckedException(1073947393L);
            }
            ProtectGroup pg = recoveryPlan.getProtectGroup();
            if (null == pg) {
                LOGGER.error((Object)"getProcessorParams error, pg is null.");
                throw new LegoCheckedException(1073947393L);
            }
            PolicyTemplate policyTemplate = pg.getTemplate();
            if (null == policyTemplate) {
                LOGGER.error((Object)"getProcessorParams error, policyTemplate is null.");
                throw new LegoCheckedException(1073947393L);
            }
            if (!VerifyUtil.isEmpty((Collection)policyTemplate.getSchedules())) {
                for (Schedule schedule : context.getRecoveryPlan().getProtectGroup().getTemplate().getSchedules()) {
                    LOGGER.info((Object)("get params, type: " + schedule.getProtectedType() + ", name: " + schedule.getName()));
                    if (ScheduleProtectedType.SNAPSHOT.getValue() != schedule.getProtectedType()) {
                        LOGGER.debug((Object)"schedule is not snapshot.");
                        continue;
                    }
                    String publicParamsStr = (String)schedule.getExtParameters().get("publicParam");
                    JSONObject publicParams = JSONObject.fromObject((Object)(publicParamsStr = ScriptParamsUtils.decryptSensitiveParam((Map)paramValidation, (String)publicParamsStr)));
                    if (null == publicParams) continue;
                    executeParams.putAll((Map)publicParams);
                }
            }
        }
        return executeParams;
    }

    private String listToString(List<String> results) {
        StringBuffer buffer = new StringBuffer();
        if (!VerifyUtil.isEmpty(results)) {
            int count = 0;
            for (String str : results) {
                buffer.append(str);
                if (++count >= results.size()) continue;
                buffer.append(" ");
            }
        }
        return buffer.toString();
    }
}

