/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.recovery.process;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.host.recovery.process.MappingLunSubProcessor;
import com.huawei.ism.drm.host.util.DBRecoveryTools;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.framework.util.RecoveryTaskUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.sdk.model.HostGroupVO;
import com.huawei.ism.drm.recovery.sdk.model.HostVO;
import com.huawei.ism.drm.recovery.sdk.model.ResourceVO;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLunBaseManager;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MappingLunProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 5528063538194736252L;
    private static final List<Integer> HYPER_METRO_REPLICATION_TEMPLATE = Arrays.asList(20, 24, 32, 27);
    private static Log logger = LogFactory.getInstance(MappingLunProcessor.class);
    private String hostOrGroupId;

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean execute(RecoveryProcessorContext context) {
        String skipFlag = (String)context.getRecoveryPlan().getGlobalSettings().get("isSkip");
        if ("true".equals(skipFlag)) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            this.updateProcessDetail("ism.drm.recovery.no.host.skip.step", new String[0]);
            return true;
        }
        Collection recoveryTasks = RecoveryProcessUtil.filterRecoveryTask((RecoveryProcessorContext)context, (String)this.getRecoveryTasksKey());
        String currentHostOrGroupId = DrHostUtil.getCurrentDisasterHost(context.getRecoveryPlan(), this.getProcType());
        if (null == currentHostOrGroupId) {
            throw new LegoCheckedException(1073947393L);
        }
        Set mappingLunSubProcessors = this.getChildProc();
        if (VerifyUtil.isEmpty((Collection)mappingLunSubProcessors) || !currentHostOrGroupId.equals(this.getHostOrGroupId())) {
            RecoveryPlan recoveryPlan = context.getRecoveryPlan();
            if (this.isHyperMetroSnap(recoveryPlan)) {
                this.updateSubProcessorsForHyperMetro(context, currentHostOrGroupId, 19);
            } else if (this.isAsyncHyperMetro(recoveryPlan) || this.is4DC(recoveryPlan)) {
                this.updateSubProcessorsForHyperMetro(context, currentHostOrGroupId, 20);
            } else if (this.isSanHyperVault(recoveryPlan)) {
                this.updateSubProcessorsForSanHyperVault(context, currentHostOrGroupId);
            } else if (DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() == this.getProcType()) {
                this.updateSubProcessors(context);
            } else {
                String disSiteId = String.valueOf(context.getAttribute("DISASTER_SITE_ID"));
                this.updateSubProcessors(RecoveryTaskUtil.getRecoveryTasksByDisisaterSite((Collection)recoveryTasks, (String)disSiteId));
            }
        }
        if (null == this.getChildProc() || this.getChildProc().isEmpty()) {
            return this.endRecoveryProcess(context);
        }
        this.setHostOrGroupId(currentHostOrGroupId);
        this.initResourceVOs();
        Map<String, String> lunGroupIds = this.prepareMapping();
        this.setLunGroupId(lunGroupIds);
        List processors = RecoveryServiceUtil.sortAndUpdateProcessorRation((Set)this.getChildProc());
        RecoveryProcessConcurrentExecutor concurrentExecutor = RecoveryProcessConcurrentExecutor.createExecutor((List)processors);
        concurrentExecutor.process(context);
        boolean executeResult = this.calcProcessResultBySubProc();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() == this.getProcStatus()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            executeResult = false;
        }
        return executeResult;
    }

    private void setLunGroupId(Map<String, String> lunGroupIds) {
        Set subProcessors = this.getChildProc();
        for (RecoveryProcessor subProcessor : subProcessors) {
            MappingLunSubProcessor mappingLunSubProcessor = (MappingLunSubProcessor)subProcessor;
            String lunGroupId = lunGroupIds.get(mappingLunSubProcessor.getDeviceId() + "_" + mappingLunSubProcessor.getHostOrGroupId());
            if (VerifyUtil.isEmpty((String)lunGroupId)) continue;
            mappingLunSubProcessor.setLunGroupId(lunGroupId);
        }
    }

    private boolean isHyperMetroSnap(RecoveryPlan recoveryPlan) {
        List<Integer> templateTypeList = DrHostUtil.getPgTemplateType(recoveryPlan);
        return templateTypeList.contains(19) && DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() == this.getProcType();
    }

    private boolean isAsyncHyperMetro(RecoveryPlan recoveryPlan) {
        List<Integer> templateTypeList = DrHostUtil.getPgTemplateType(recoveryPlan);
        boolean noAsyncHyperMetro = true;
        for (Integer type : HYPER_METRO_REPLICATION_TEMPLATE) {
            noAsyncHyperMetro = noAsyncHyperMetro && !templateTypeList.contains(type);
        }
        if (noAsyncHyperMetro) {
            return false;
        }
        return DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue() == this.getProcType() || DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == this.getProcType();
    }

    private boolean isSanHyperVault(RecoveryPlan recoveryPlan) {
        List<Integer> templateTypeList = DrHostUtil.getPgTemplateType(recoveryPlan);
        boolean hasSanVaultTpl = false;
        for (Integer template : templateTypeList) {
            if (!PolicyTemplateType.SAN_HYPER_VAULT_POLICYTEMPLATE.contains(template)) continue;
            hasSanVaultTpl = true;
            break;
        }
        if (!hasSanVaultTpl) {
            return false;
        }
        return DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() == this.getProcType();
    }

    private boolean is4DC(RecoveryPlan recoveryPlan) {
        List<Integer> templateTypeList = DrHostUtil.getPgTemplateType(recoveryPlan);
        if (!this.is4DCTemplate(templateTypeList)) {
            return false;
        }
        return DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue() == this.getProcType() || DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == this.getProcType();
    }

    private boolean is4DCTemplate(List<Integer> templateTypeList) {
        return PolicyTemplateType.REP_4DC_POLICYTEMPLATE.containsAll(templateTypeList);
    }

    private void updateSubProcessorsForHyperMetro(RecoveryProcessorContext context, String currentHostOrGroupId, int templateType) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        List<ProtectObject> pos = DBRecoveryTools.appProtectObjectsFilter(context);
        ArrayList<String> poIdList = new ArrayList<String>();
        for (ProtectObject po : pos) {
            poIdList.add(po.getUuid());
        }
        String poIds = RecoveryProcessUtil.getPoIds(poIdList);
        List<String> nasLunInfos = this.getNasLunInfos(recoveryPlan.getProtectGroups());
        String disasterSiteId = (String)recoveryPlan.getGlobalSettings().get("DISASTER_SITE_ID");
        Collection recoveryTasks = RecoveryProcessUtil.filterRecoveryTask((RecoveryProcessorContext)context, (String)"recoveryTasks");
        if (this.is4DC(context.getRecoveryPlan())) {
            String disSiteId = String.valueOf(context.getAttribute("DISASTER_SITE_ID"));
            recoveryTasks = RecoveryTaskUtil.getRecoveryTasksByDisisaterSite((Collection)recoveryTasks, (String)disSiteId);
        }
        HashSet<RecoveryProcessor> mappingLunSubProcessors = new HashSet<RecoveryProcessor>();
        for (RecoveryTask recoveryTask : recoveryTasks) {
            Set<String> storageIds = this.getStorageIds(recoveryTask, templateType);
            for (String storageId : storageIds) {
                String lunId = this.getLunId(recoveryPlan, storageId);
                Lun lun = DrHostUtil.getSrcLun(disasterSiteId, recoveryTask.getTgtDevcieId(), lunId);
                if (null == lun) {
                    logger.error((Object)("resources is null,sn=" + storageId), 90160758786989L);
                    continue;
                }
                List resources = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResourceByWwn(new String[]{lun.getWwn()});
                if (VerifyUtil.isEmpty((Collection)resources)) {
                    logger.info((Object)("resources is null,lunWwn=" + lun.getWwn()), 90160758786989L);
                    continue;
                }
                this.createSubProcessor(resources, nasLunInfos, currentHostOrGroupId, poIds, recoveryTask, mappingLunSubProcessors);
            }
        }
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.updateSubProcessors(mappingLunSubProcessors);
        } else {
            this.setChildProc(mappingLunSubProcessors);
        }
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private List<String> getNasLunInfos(Set<ProtectGroup> protectGroupSet) {
        ArrayList<String> nasLunInfos = new ArrayList<String>();
        for (ProtectGroup protectGroup : protectGroupSet) {
            Set protectObjectSet = protectGroup.getPolist();
            for (ProtectObject protectObject : protectObjectSet) {
                this.getNasLunInfos(nasLunInfos, protectGroup, protectObject);
            }
        }
        return nasLunInfos;
    }

    private Set<String> getStorageIds(RecoveryTask recoveryTask, int templateType) {
        if (19 == templateType) {
            return recoveryTask.getSrcStorageIds();
        }
        return recoveryTask.getTgtStorageIds();
    }

    private String getLunId(RecoveryPlan recoveryPlan, String srcStorageIds) {
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() == this.getProcType()) {
            return srcStorageIds;
        }
        String lunId = srcStorageIds;
        String[] srcStorageIdArray = srcStorageIds.split(":");
        if (srcStorageIdArray.length > 0) {
            lunId = srcStorageIdArray[srcStorageIdArray.length - 1];
        }
        return lunId;
    }

    private void getNasLunInfos(List<String> nasLunInfos, ProtectGroup protectGroup, ProtectObject protectObject) {
        if (protectObject.getPoType() == protectGroup.getPoType()) {
            return;
        }
        Set protectObjectStorageInfoSet = protectObject.getUsedStorageResourceSet();
        for (ProtectObjectStorageInfo protectObjectStorageInfo : protectObjectStorageInfoSet) {
            nasLunInfos.add(protectObjectStorageInfo.getResourceProviderSN() + "_" + protectObjectStorageInfo.getResourceId());
        }
    }

    private void updateSubProcessorsForSanHyperVault(RecoveryProcessorContext context, String currentHostOrGroupId) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        List<ProtectObject> pos = DBRecoveryTools.appProtectObjectsFilter(context);
        ArrayList<String> poIdList = new ArrayList<String>();
        for (ProtectObject po : pos) {
            poIdList.add(po.getUuid());
        }
        String poIds = RecoveryProcessUtil.getPoIds(poIdList);
        List<String> nasLunInfos = this.getNasLunInfos(recoveryPlan.getProtectGroups());
        Collection recoveryTasks = (Collection)context.getAttribute("recoveryTasks");
        HashSet<RecoveryProcessor> mappingLunSubProcessors = new HashSet<RecoveryProcessor>();
        for (RecoveryTask recoveryTask : recoveryTasks) {
            Set srcStorageWwns = recoveryTask.getSrcStorageWwns();
            for (String lunWwn : srcStorageWwns) {
                List resources = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResourceByWwn(new String[]{lunWwn});
                if (VerifyUtil.isEmpty((Collection)resources)) {
                    logger.info((Object)("resources null,lunWwn=" + lunWwn), 90160758786989L);
                    continue;
                }
                this.createSubProcessor(resources, nasLunInfos, currentHostOrGroupId, poIds, recoveryTask, mappingLunSubProcessors);
            }
        }
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.updateSubProcessors(mappingLunSubProcessors);
        } else {
            this.setChildProc(mappingLunSubProcessors);
        }
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void createSubProcessor(List<StorageResource> resources, List<String> nasLunInfos, String currentHostOrGroupId, String poIds, RecoveryTask recoveryTask, Set<RecoveryProcessor> mappingLunSubProcessors) {
        for (StorageResource storageResource : resources) {
            String key = storageResource.getDevSn() + "_" + storageResource.getResourceId();
            if (nasLunInfos.contains(key)) {
                logger.info((Object)("filter nas lun:" + key), 90160758786816L);
                continue;
            }
            MappingLunSubProcessor processor = new MappingLunSubProcessor();
            processor.setProcName(processor.getName());
            processor.setProcType(this.getProcType());
            processor.setPlanId(this.getPlanId());
            processor.setProcessId(this.getProcessId());
            processor.setParentProc((RecoveryProcessor)this);
            processor.setReplicationId(recoveryTask.getProtectId());
            processor.setSrcDeviceId(recoveryTask.getSrcDeviceId());
            processor.setDeviceId(storageResource.getDevSn());
            processor.setRelationType(recoveryTask.getProtectType());
            processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            processor.setLunId(storageResource.getResourceId());
            processor.setLunName(storageResource.getName());
            processor.setHostOrGroupId(currentHostOrGroupId);
            processor.setPoIds(poIds);
            if (!recoveryTask.getTgtDevcieId().equals(storageResource.getDevSn())) {
                processor.setIsCheckReplication(false);
            }
            mappingLunSubProcessors.add((RecoveryProcessor)processor);
        }
    }

    public String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    protected void initResourceVOs() {
        HashSet<String> hostOrGroupIds = new HashSet<String>();
        Set subProcessors = this.getChildProc();
        for (RecoveryProcessor subProcessor : subProcessors) {
            MappingLunSubProcessor mappingLunSubProcessor = (MappingLunSubProcessor)subProcessor;
            String id = mappingLunSubProcessor.getHostOrGroupId();
            if (VerifyUtil.isEmpty((String)id)) continue;
            hostOrGroupIds.add(id);
        }
        Map<String, ResourceVO> resourceVOs = DrHostUtil.getHostInitiators(hostOrGroupIds);
        if (!VerifyUtil.isEmpty(resourceVOs)) {
            for (RecoveryProcessor subProcessor : subProcessors) {
                MappingLunSubProcessor mappingLunSubProcessor = (MappingLunSubProcessor)subProcessor;
                mappingLunSubProcessor.setResourceVO(resourceVOs.get(mappingLunSubProcessor.getHostOrGroupId()));
            }
        }
    }

    private boolean updateSubProcessors(Collection<RecoveryTask> recoveryTasks) {
        HashSet<MappingLunSubProcessor> mappingLunSubProcessors = new HashSet<MappingLunSubProcessor>();
        for (RecoveryTask recoveryTask : recoveryTasks) {
            Map lunAndHostMap = recoveryTask.getLunAndHostMap();
            Set lunAndHostEntries = lunAndHostMap.entrySet();
            Map lunAndPoMap = recoveryTask.getLunAndPoMap();
            Map resourceAndTypeMap = recoveryTask.getResourceAndTypeMap();
            for (Map.Entry entry : lunAndHostEntries) {
                String slaveLunKey = (String)entry.getKey();
                List hostOrGroupIds = (List)entry.getValue();
                String[] strArray = slaveLunKey.split(":");
                if (this.isCurrentNASProtectObject(resourceAndTypeMap, (String)entry.getKey())) continue;
                String tgtLunId = strArray[4];
                String poIds = RecoveryProcessUtil.getPoIds((List)((List)lunAndPoMap.get(slaveLunKey)));
                for (String id : hostOrGroupIds) {
                    MappingLunSubProcessor processor = new MappingLunSubProcessor();
                    processor.setProcName(processor.getName());
                    processor.setProcType(this.getProcType());
                    processor.setPlanId(this.getPlanId());
                    processor.setProcessId(this.getProcessId());
                    processor.setParentProc((RecoveryProcessor)this);
                    processor.setReplicationId(recoveryTask.getProtectId());
                    processor.setSrcDeviceId(recoveryTask.getSrcDeviceId());
                    processor.setDeviceId(recoveryTask.getTgtDevcieId());
                    processor.setRelationType(recoveryTask.getProtectType());
                    processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
                    processor.setLunId(tgtLunId);
                    processor.setHostOrGroupId(id);
                    processor.setPoIds(poIds);
                    mappingLunSubProcessors.add(processor);
                }
            }
        }
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.updateSubProcessors(mappingLunSubProcessors);
        } else {
            this.setChildProc(mappingLunSubProcessors);
        }
        boolean result = ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return result;
    }

    private boolean isCurrentNASProtectObject(Map<String, Integer> resourceAndTypeMap, String slaveLunKey) {
        Integer appType = resourceAndTypeMap.get(slaveLunKey);
        if (null == appType) {
            return false;
        }
        return DrmEnumDefine.AppType.NAS_FILESYSTEM.getValue() == resourceAndTypeMap.get(slaveLunKey).intValue();
    }

    private boolean endRecoveryProcess(RecoveryProcessorContext context) {
        if (DrmEnumDefine.AppType.LUN == RecoveryServiceUtil.getAppType((RecoveryPlan)context.getRecoveryPlan())) {
            this.updateProcessDetail("ism.drm.recovery.no.configured.host", new String[0]);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        this.updateProcessDetail("ism.drm.recovery.no.configured.host", new String[0]);
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        return false;
    }

    private boolean updateSubProcessors(RecoveryProcessorContext context) {
        Iterator pgIter = context.getRecoveryPlan().getProtectGroups().iterator();
        if (!pgIter.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup pg = (ProtectGroup)pgIter.next();
        String poIds = RecoveryProcessUtil.getPoIds(this.getPoIds(pg));
        HashSet<MappingLunSubProcessor> mappingLunSubProcessors = new HashSet<MappingLunSubProcessor>();
        Collection recoveryTasks = (Collection)context.getAttribute("recoveryTasks");
        for (RecoveryTask recoveryTask : recoveryTasks) {
            MappingLunSubProcessor processor = new MappingLunSubProcessor();
            processor.setProcName(processor.getName());
            processor.setProcType(this.getProcType());
            processor.setPlanId(this.getPlanId());
            processor.setProcessId(this.getProcessId());
            processor.setParentProc((RecoveryProcessor)this);
            processor.setSrcDeviceId(recoveryTask.getSrcDeviceId());
            processor.setDeviceId(recoveryTask.getSrcDeviceId());
            processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            Iterator lunIdIter = recoveryTask.getSrcStorageIds().iterator();
            if (lunIdIter.hasNext()) {
                processor.setLunId((String)lunIdIter.next());
            }
            processor.setHostOrGroupId(pg.getPoProviderSN());
            processor.setPoIds(poIds);
            mappingLunSubProcessors.add(processor);
        }
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.updateSubProcessors(mappingLunSubProcessors);
        } else {
            this.setChildProc(mappingLunSubProcessors);
        }
        boolean result = ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return result;
    }

    private List<String> getPoIds(ProtectGroup pg) {
        ArrayList<String> idList = new ArrayList<String>();
        Set pObjects = pg.getPolist();
        if (VerifyUtil.isEmpty((Collection)pObjects)) {
            return idList;
        }
        for (ProtectObject po : pObjects) {
            if (idList.contains(po.getUuid())) continue;
            idList.add(po.getUuid());
        }
        return idList;
    }

    public String getHostOrGroupId() {
        return this.hostOrGroupId;
    }

    public void setHostOrGroupId(String hostOrGroupId) {
        this.hostOrGroupId = hostOrGroupId;
    }

    private Map<String, String> prepareMapping() {
        Set subProcessors = this.getChildProc();
        HashMap<String, HashSet<ResourceVO>> resourceVOMap = new HashMap<String, HashSet<ResourceVO>>();
        for (RecoveryProcessor subProcessor : subProcessors) {
            MappingLunSubProcessor mappingLunSubProcessor = (MappingLunSubProcessor)subProcessor;
            HashSet<ResourceVO> resources = (HashSet<ResourceVO>)resourceVOMap.get(mappingLunSubProcessor.getDeviceId());
            if (null == resources) {
                resources = new HashSet<ResourceVO>();
                resourceVOMap.put(mappingLunSubProcessor.getDeviceId(), resources);
            }
            resources.add(mappingLunSubProcessor.getResourceVO());
        }
        HashMap<String, String> lunGroupIds = new HashMap<String, String>();
        for (Map.Entry entry : resourceVOMap.entrySet()) {
            StorageLunManagerProxy storageManagerProxy = StorageLunManagerProxy.getInstance();
            IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
            String deviceType = recoveryService.getStorageType((String)entry.getKey());
            IStorageLunBaseManager proxy = storageManagerProxy.getStorageLunMgrByDevType(deviceType);
            Set resources = (Set)entry.getValue();
            for (ResourceVO resouce : resources) {
                String key = (String)entry.getKey() + "_" + resouce.getId();
                String lunGroupId = resouce instanceof HostVO ? proxy.prepareMapping((String)entry.getKey(), (HostVO)resouce) : proxy.prepareMapping((String)entry.getKey(), (HostGroupVO)resouce);
                if (!VerifyUtil.isEmpty((String)lunGroupId)) {
                    lunGroupIds.put(key, lunGroupId);
                    logger.debug((Object)("prepareMapping, lunGroupId:" + lunGroupId + ",key:" + key));
                    continue;
                }
                if (!HvsUnit.class.getName().equals(deviceType)) continue;
                logger.error((Object)"prepareMapping return lunGroupId is null for HvsUnit.");
            }
        }
        return lunGroupIds;
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.storage.recovery.process.MappingLunProcessor.des");
    }

    public void resetEnableStatus(ProtectGroup pg, DrmEnumDefine.RecoveryPlanExecuteTypeE procType) {
        DrmEnumDefine.AppType appType;
        int templateType = pg.getTemplate().getType();
        if (templateType == 47 && this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue()) {
            boolean isPlanSwitch = Boolean.parseBoolean(((ProtectObject)pg.getPolist().stream().findFirst().get()).getProps().getOrDefault("HAS_SWITCHOVER", "false"));
            if (isPlanSwitch) {
                this.setIsEnabled(false);
                this.setIsEditable(false);
            } else {
                this.setIsEnabled(true);
                this.setIsEditable(false);
            }
        }
        if ((appType = DrmEnumDefine.AppType.getType((int)pg.getPoType())) == null) {
            return;
        }
        this.setIsEditable(true);
        logger.debug((Object)("resetEnableStatus : appType=" + appType + " ,templateType=" + templateType + " ,PLAN_EXECUTE_TYPE=" + procType));
    }
}

