/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.recovery.process;

import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.MappingReplicaSubProcessorBuilderManager;
import com.huawei.ism.drm.recovery.process.IMappingReplicaSubProcessorBuilder;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.sdk.model.HostGroupVO;
import com.huawei.ism.drm.recovery.sdk.model.HostVO;
import com.huawei.ism.drm.recovery.sdk.model.ResourceVO;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLunBaseManager;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MappingReplicaProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -3263317254456674235L;
    private static final Log LOGGER = LogFactory.getInstance(MappingReplicaProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        ProtectGroupReplica replica = context.getProtectGroupReplica();
        if (null == replica) {
            LOGGER.error((Object)"replica is null!");
            throw new LegoCheckedException(1073947393L);
        }
        String hostKey = "PG_DISASTER_HOST";
        String hostOrGroupId = (String)context.getRecoveryPlan().getGlobalSettings().get(hostKey);
        replica.setMountedHost(hostOrGroupId);
        String storageDeviceId = replica.getStorageDeviceId();
        String lunGroupId = this.createLunGroup(storageDeviceId, hostOrGroupId);
        replica.addProperty("lunGroupId", lunGroupId);
        MappingReplicaSubProcessorBuilderManager manager = MappingReplicaSubProcessorBuilderManager.getInstance();
        IMappingReplicaSubProcessorBuilder builder = manager.getBuider(replica.getType());
        Set subProcessors = builder.buildMappingProcessor((RecoveryProcessor)this, replica);
        if (null == this.getChildProc() || this.getChildProc().isEmpty()) {
            this.setChildProc(subProcessors);
        } else {
            this.updateSubProcessors(subProcessors);
        }
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return this.executeSubProcessor(context);
    }

    protected String generateResultKey() {
        return "";
    }

    private String createLunGroup(String storageDeviceId, String hostOrGroupId) {
        StorageLunManagerProxy storageManagerProxy = StorageLunManagerProxy.getInstance();
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        String deviceType = recoveryService.getStorageType(storageDeviceId);
        IStorageLunBaseManager proxy = storageManagerProxy.getStorageLunMgrByDevType(deviceType);
        HashSet<String> hostOrGroupIds = new HashSet<String>();
        hostOrGroupIds.add(hostOrGroupId);
        Map<String, ResourceVO> initiators = DrHostUtil.getHostInitiators(hostOrGroupIds);
        ResourceVO resourceVO = initiators.get(hostOrGroupId);
        String lunGroupId = null;
        if (resourceVO instanceof HostVO) {
            lunGroupId = proxy.prepareMapping(storageDeviceId, (HostVO)resourceVO);
        } else if (resourceVO instanceof HostGroupVO) {
            lunGroupId = proxy.prepareMapping(storageDeviceId, (HostGroupVO)resourceVO);
        }
        return lunGroupId;
    }
}

