/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.recovery.process;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.app.constants.DrmAppEnumDefine;
import com.huawei.ism.drm.app.sdk.model.HostDeviceStorageInfo;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.host.recovery.process.MountHostDeviceSubProcessor;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.host.util.DBRecoveryTools;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.host.util.ProtectObjectAppUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.util.ReplicaUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class MountHostDeviceProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 4527941180108048469L;
    private static Log logger = LogFactory.getInstance(MountHostDeviceProcessor.class);
    private Map<String, Boolean> lastProcResult;
    private final Map<String, List<HostDeviceStorageInfo>> hostDeviceStorageInfosMap = new HashMap<String, List<HostDeviceStorageInfo>>();
    private String hostOrGroupId;
    private List<ProtectObject> protectObjectList;

    public String getHostOrGroupId() {
        return this.hostOrGroupId;
    }

    public void setHostOrGroupId(String hostOrGroupId) {
        this.hostOrGroupId = hostOrGroupId;
    }

    public Map<String, List<HostDeviceStorageInfo>> getHostDeviceStorageInfosMap() {
        return this.hostDeviceStorageInfosMap;
    }

    public List<ProtectObject> getProtectObjectList() {
        return this.protectObjectList;
    }

    public void setProtectObjectList(List<ProtectObject> pos) {
        this.protectObjectList = pos;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected boolean execute(RecoveryProcessorContext context) {
        List<ProtectObject> pos = DBRecoveryTools.appProtectObjectsFilter(context);
        this.setProtectObjectList(pos);
        RecoveryProcessResult processResult = context.getProcessResult();
        this.lastProcResult = processResult.getMappingProcessResults();
        String currentHostOrGroupId = DrHostUtil.getCurrentDisasterHost(context.getRecoveryPlan(), this.getProcType());
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        DrResource drResource = resourceService.getDrResourceBySn(currentHostOrGroupId);
        String proProviderType = this.getProProviderType(context, resourceService);
        DrmAppEnumDefine.CLUSTER_TYPE_E eClusterType = null;
        Set<DrResource> hosts = new HashSet();
        if (drResource instanceof DrHostGroup) {
            hosts = drResource.getChildResources();
            eClusterType = DrmAppEnumDefine.CLUSTER_TYPE_E.getType((int)((DrHostGroup)drResource).getClusterType());
        } else if (drResource instanceof DrHost) {
            hosts.add(drResource);
        }
        Set subProcessors = this.getChildProc();
        if (null == currentHostOrGroupId) {
            logger.error((Object)"currentHostOrGroupId is null");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((Collection)subProcessors) || !currentHostOrGroupId.equals(this.getHostOrGroupId())) {
            this.createSubProcessors(pos, hosts);
        } else {
            this.updateMountSubProcessors(subProcessors, hosts);
        }
        Set<HostDeviceStorageInfo> hostStorageInfos = this.buildHostDeviceStorageInfos(context, pos);
        this.updateHostStorageInfos2Props(hostStorageInfos);
        this.buildHostDeviceStorageInfosMap(hostStorageInfos);
        this.setHostOrGroupId(currentHostOrGroupId);
        subProcessors = this.getChildProc();
        if (null == subProcessors || subProcessors.isEmpty()) {
            this.updateProcessDetail("ism.drm.recovery.no.configured.host", new String[0]);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        this.updateSubProcessors(context, pos, proProviderType, eClusterType, subProcessors);
        List processors = RecoveryServiceUtil.sortAndUpdateProcessorRation((Set)this.getChildProc());
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor((List)processors);
        if (null == recoveryTemplate) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        recoveryTemplate.process(context);
        return this.calcProcessResultBySubProc();
    }

    private void updateSubProcessors(RecoveryProcessorContext context, List<ProtectObject> pos, String proProviderType, DrmAppEnumDefine.CLUSTER_TYPE_E eClusterType, Set<RecoveryProcessor> subProcessors) {
        String vgActiveMode = (String)pos.get(0).getProps().get("CLUSTER_VG_ACTIVE_MODE");
        JSONObject wwnRelationJson = new JSONObject();
        for (RecoveryProcessor recoveryProcessor : subProcessors) {
            MountHostDeviceSubProcessor subProcessor = (MountHostDeviceSubProcessor)recoveryProcessor;
            subProcessor.setClusterType(eClusterType);
            subProcessor.setProProviderType(proProviderType);
            subProcessor.setVgActiveMode(vgActiveMode);
            List<HostDeviceStorageInfo> storageInfoList = this.hostDeviceStorageInfosMap.get(subProcessor.getHostSN());
            subProcessor.setHostDeviceStorageInfos(storageInfoList);
            subProcessor.setProtectObjects(pos);
            this.setWwnRelation(wwnRelationJson, storageInfoList, subProcessor.getHostSN());
        }
        logger.info((Object)("wwnRelationJson:" + wwnRelationJson), 90160758786988L);
        context.setAttribute("WWN_RELATION", (Object)wwnRelationJson);
    }

    private void setWwnRelation(JSONObject wwnRelationJson, List<HostDeviceStorageInfo> storageInfoList, String hostSn) {
        if (null == storageInfoList || storageInfoList.isEmpty()) {
            logger.error((Object)("storageInfoList is null or empty.hostSn=" + hostSn), 90160758786988L);
            return;
        }
        for (HostDeviceStorageInfo hostDeviceStorageInfo : storageInfoList) {
            wwnRelationJson.put((Object)hostDeviceStorageInfo.getSrcLunWWN(), (Object)hostDeviceStorageInfo.getWwn());
            logger.debug((Object)("srcWWN:" + hostDeviceStorageInfo.getSrcLunWWN() + ",wwn:" + hostDeviceStorageInfo.getWwn()), 90160758786988L);
        }
    }

    private String getProProviderType(RecoveryProcessorContext context, IResourceService resourceService) {
        ProtectGroup protectGroup = context.getRecoveryPlan().getProtectGroup();
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            logger.error((Object)"protectGroup is empty.", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        String proHostOrGroupId = protectGroup.getPoProviderSN();
        DrResource proDrResource = resourceService.getDrResourceBySn(proHostOrGroupId);
        String proProviderType = String.valueOf(DrmEnumDefine.ProviderTypeE.HOST.getValue());
        if (proDrResource instanceof DrHostGroup) {
            proProviderType = String.valueOf(DrmEnumDefine.ProviderTypeE.HOSTGROUP.getValue());
        }
        return proProviderType;
    }

    private void buildHostDeviceStorageInfosMap(Set<HostDeviceStorageInfo> hostStorageInfos) {
        for (HostDeviceStorageInfo hostDeviceStorageInfo : hostStorageInfos) {
            List<HostDeviceStorageInfo> hostDeviceStorageInfos = this.hostDeviceStorageInfosMap.get(hostDeviceStorageInfo.getHostSN());
            if (null == hostDeviceStorageInfos) {
                hostDeviceStorageInfos = new ArrayList<HostDeviceStorageInfo>();
                this.hostDeviceStorageInfosMap.put(hostDeviceStorageInfo.getHostSN(), hostDeviceStorageInfos);
            }
            hostDeviceStorageInfos.add(hostDeviceStorageInfo);
        }
    }

    protected String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    protected boolean createSubProcessors(List<ProtectObject> pos, Set<DrResource> hosts) {
        HashSet<MountHostDeviceSubProcessor> subProcessors = new HashSet<MountHostDeviceSubProcessor>();
        for (DrResource host : hosts) {
            MountHostDeviceSubProcessor subProcessor = new MountHostDeviceSubProcessor();
            subProcessor.setProcType(this.getProcType());
            subProcessor.setPlanId(this.getPlanId());
            subProcessor.setProcessId(this.getProcessId());
            subProcessor.setParentProc((RecoveryProcessor)this);
            subProcessor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            subProcessor.setProcName(subProcessor.getName());
            subProcessor.setHostSN(host.getDeviceSn());
            subProcessor.setHostName(host.getName());
            subProcessors.add(subProcessor);
        }
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.updateSubProcessors(subProcessors);
        } else {
            this.setChildProc(subProcessors);
        }
        boolean result = ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return result;
    }

    protected Set<DrResource> getRecoveryHostOrGroupId(RecoveryPlan recoveryPlan) {
        HashSet<DrResource> hosts = new HashSet<DrResource>();
        String deviceSn = DrHostUtil.getCurrentDisasterHost(recoveryPlan, this.getProcType());
        List list = CommonDAOLocator.getBaseDao().find("from DrResource where deviceSn = ?", new Object[]{deviceSn});
        if (VerifyUtil.isEmpty((Collection)list)) {
            logger.error((Object)("the drresource(deviceSn:" + deviceSn + ") dose not exist."), 90160758786989L);
            return hosts;
        }
        DrResource hostOrGroup = (DrResource)list.get(0);
        if (hostOrGroup instanceof DrHostGroup) {
            hosts.addAll(hostOrGroup.getChildResources());
        } else if (hostOrGroup instanceof DrHost) {
            hosts.add(hostOrGroup);
        }
        return hosts;
    }

    private boolean updateMountSubProcessors(Set<RecoveryProcessor> subProcessors, Set<DrResource> hosts) {
        HashMap<String, DrResource> hostMap = new HashMap<String, DrResource>();
        for (DrResource host : hosts) {
            hostMap.put(host.getDeviceSn(), host);
        }
        for (RecoveryProcessor subProcessor : subProcessors) {
            MountHostDeviceSubProcessor hostSubProcess = (MountHostDeviceSubProcessor)subProcessor;
            DrResource host = (DrResource)hostMap.get(hostSubProcess.getHostSN());
            if (null == host) continue;
            hostSubProcess.setHostName(host.getName());
        }
        this.setChildProc(subProcessors);
        boolean result = ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return result;
    }

    private String getValue(String expr) {
        if (expr == null) {
            return "";
        }
        String[] items = expr.split("=");
        return items.length > 1 ? items[1] : "";
    }

    protected List<RelicaStorageInfo> getAllRelicaStorageInfoByRecoveryPlan(RecoveryProcessorContext context, RecoveryPlan recoveryPlan, String replicaId) {
        ArrayList<RelicaStorageInfo> result = new ArrayList<RelicaStorageInfo>();
        Set pgs = recoveryPlan.getProtectGroups();
        for (ProtectGroup pg : pgs) {
            if (pg.getTemplate().getType() == 3 || pg.getTemplate().getType() == 4) {
                this.dealThirdDC(result, pg);
                continue;
            }
            if (this.is4DCTemplate(pg)) {
                this.dealFourDC(result, pg);
                continue;
            }
            this.dealCommon(context, recoveryPlan, replicaId, result, pg);
        }
        return result;
    }

    private boolean is4DCTemplate(ProtectGroup pg) {
        return PolicyTemplateType.REP_4DC_POLICYTEMPLATE.contains(pg.getTemplate().getType());
    }

    private void dealCommon(RecoveryProcessorContext context, RecoveryPlan recoveryPlan, String replicaId, List<RelicaStorageInfo> result, ProtectGroup pg) {
        block5: {
            block4: {
                if (DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue() != recoveryPlan.getPlanType() && DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() != this.getProcType()) break block4;
                ProtectGroupReplica replica = context.getProtectGroupReplica();
                if (null == replica) {
                    logger.error((Object)("ProtectGroupReplica of RecoveryProcessorContext is null." + replicaId));
                    return;
                }
                for (ProtectObjectReplica por : replica.getReplicas()) {
                    result.addAll(por.getStorageInfos());
                }
                break block5;
            }
            if (DrmEnumDefine.RecoveryPlanTypeE.REMOTE.getValue() != recoveryPlan.getPlanType()) break block5;
            for (ProtectGroupReplica pgr : pg.getReplicaList()) {
                if (ReplicaUtil.isLocalStorageReplica((ProtectGroupReplica)pgr) || !pgr.getRecoverySite().equals(this.getContextRef().getDisasterSiteId())) continue;
                for (ProtectObjectReplica por : pgr.getReplicas()) {
                    result.addAll(por.getStorageInfos());
                }
            }
        }
    }

    private void dealThirdDC(List<RelicaStorageInfo> result, ProtectGroup pg) {
        HashSet<String> srcStorageKeys = new HashSet<String>();
        for (Object po : pg.getPolist()) {
            for (Object poStorage : po.getUsedStorageResourceSet()) {
                srcStorageKeys.add(poStorage.getResourceProviderSN() + "_" + poStorage.getResourceId());
            }
        }
        HashMap<String, String> linkPairMap = new HashMap<String, String>();
        for (ProtectGroupReplica pgr : pg.getReplicaList()) {
            for (ProtectObjectReplica por : pgr.getReplicas()) {
                for (RelicaStorageInfo rs : por.getStorageInfos()) {
                    String key = rs.getStorageProviderSN() + "_" + rs.getStorageId();
                    String value = rs.getSrcStorageProviderSN() + "_" + rs.getSrcStorageId();
                    linkPairMap.put(key, value);
                }
                if (!pgr.getRecoverySite().equals(this.getContextRef().getDisasterSiteId())) continue;
                result.addAll(por.getStorageInfos());
            }
        }
        HashMap<String, String> pairMap = new HashMap<String, String>();
        for (RelicaStorageInfo rs : result) {
            String[] srcValue;
            String srcValueStr;
            String key = rs.getStorageProviderSN() + "_" + rs.getStorageId();
            if (pairMap.containsKey(key)) {
                srcValueStr = (String)pairMap.get(key);
                srcValue = srcValueStr.split("_");
                rs.setSrcStorageProviderSN(srcValue[0]);
                rs.setSrcStorageId(srcValue[1]);
                continue;
            }
            srcValueStr = this.getSrcStorageStr(key, srcStorageKeys, linkPairMap);
            if (null == srcValueStr) {
                throw new LegoCheckedException(1073947393L);
            }
            srcValue = srcValueStr.split("_");
            rs.setSrcStorageProviderSN(srcValue[0]);
            rs.setSrcStorageId(srcValue[1]);
            pairMap.put(key, srcValueStr);
        }
    }

    private void dealFourDC(List<RelicaStorageInfo> result, ProtectGroup pg) {
        HashMap<String, String> srcStorageWwnKeysMap = new HashMap<String, String>();
        for (ProtectObject po : pg.getPolist()) {
            for (ProtectObjectStorageInfo poStorage : po.getUsedStorageResourceSet()) {
                srcStorageWwnKeysMap.put(poStorage.getLunWWN(), poStorage.getResourceProviderSN() + "_" + poStorage.getResourceId());
            }
        }
        for (ProtectGroupReplica pgr : pg.getReplicaList()) {
            for (ProtectObjectReplica por : pgr.getReplicas()) {
                if (!pgr.getRecoverySite().equals(this.getContextRef().getDisasterSiteId())) continue;
                result.addAll(por.getStorageInfos());
            }
        }
        for (RelicaStorageInfo rs : result) {
            String srcValueStr = (String)srcStorageWwnKeysMap.get(rs.getProtectObjectStorageWwn());
            if (null == srcValueStr) {
                throw new LegoCheckedException(1073947393L);
            }
            String[] srcValue = srcValueStr.split("_");
            rs.setSrcStorageProviderSN(srcValue[0]);
            rs.setSrcStorageId(srcValue[1]);
        }
    }

    private String getSrcStorageStr(String key, Set<String> srcStorageKeys, Map<String, String> linkPairMap) {
        if (srcStorageKeys.contains(linkPairMap.get(key))) {
            return linkPairMap.get(key);
        }
        return this.getSrcStorageStr(linkPairMap.get(key), srcStorageKeys, linkPairMap);
    }

    protected boolean isSameProcessor(RecoveryProcessor oldProcess, RecoveryProcessor newProcess) {
        if (null == oldProcess || null == newProcess) {
            return false;
        }
        return oldProcess.getProcId().equals(newProcess.getProcId());
    }

    private void updateHostStorageInfos2Props(Set<HostDeviceStorageInfo> hostStorageInfos) {
        Map processPropsMap = this.getProps();
        HashSet<String> storageInfokeySet = new HashSet<String>();
        for (String key : processPropsMap.keySet()) {
            if (null == key || !key.startsWith("HOST_STOR_CONFIG_")) continue;
            storageInfokeySet.add(key);
        }
        for (String key : storageInfokeySet) {
            processPropsMap.remove(key);
        }
        for (HostDeviceStorageInfo hostStorageInfo : hostStorageInfos) {
            String key = "HOST_STOR_CONFIG_" + hostStorageInfo.generateKey();
            String value = JSONObject.fromObject((Object)hostStorageInfo).toString();
            processPropsMap.put(key, value);
        }
    }

    protected Set<HostDeviceStorageInfo> buildHostDeviceStorageInfos(RecoveryProcessorContext context, List<ProtectObject> pos) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        String replicaId = "";
        if (null != context.getAttribute("REPLICA_ID")) {
            replicaId = (String)context.getAttribute("REPLICA_ID");
        }
        List<RelicaStorageInfo> replicaStorages = this.getAllRelicaStorageInfoByRecoveryPlan(context, recoveryPlan, replicaId);
        Set<HostDeviceStorageInfo> hostStorageInfos = this.getHostStorageInfos(pos, context, replicaStorages);
        return hostStorageInfos;
    }

    private Set<HostDeviceStorageInfo> getHostStorageInfos(List<ProtectObject> pos, RecoveryProcessorContext context, List<RelicaStorageInfo> replicaStorages) {
        int recoveryPlanType = context.getRecoveryPlan().getPlanType();
        Set<DrResource> hosts = this.getRecoveryHostOrGroupId(context.getRecoveryPlan());
        HashSet<HostDeviceStorageInfo> hostStorageInfos = new HashSet<HostDeviceStorageInfo>();
        HashSet<String> hostStorageInfoKeySet = new HashSet<String>();
        for (DrResource host : hosts) {
            for (ProtectObject po : pos) {
                String dbVersion = (String)po.getProps().get("VERSION");
                String dbUserName = (String)po.getProps().get("USERNAME");
                String instanceName = (String)po.getProps().get("INSTANCENAME");
                PolicyTemplate template = context.getProtectGroup().getTemplate();
                int templateType = template.getType();
                for (ProtectObjectStorageInfo poStorageInfo : po.getUsedStorageResourceSet()) {
                    HostDeviceStorageInfo hostStorageInfo = new HostDeviceStorageInfo();
                    this.setHostStorageDeviceIdAndLunIdInfo(replicaStorages, recoveryPlanType, templateType, poStorageInfo, hostStorageInfo, context);
                    this.convertPoStorageInfoToHostStorageInfo(poStorageInfo, hostStorageInfo);
                    if (po.getPoType() == DrmEnumDefine.AppType.SAPHANA.getValue()) {
                        hostStorageInfo.setAlias(poStorageInfo.getAlias());
                        String currentHostSn = poStorageInfo.getCurrentHostSn();
                        String srcHostSN = VerifyUtil.isEmpty((String)currentHostSn) ? po.getProviderSN() : currentHostSn;
                        DrHost srcHost = (DrHost)((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(srcHostSN);
                        DrHost rechost = (DrHost)host;
                        JSONObject srcInstanceHostAliasJsonObject = JSONObject.fromObject((Object)srcHost.getHostAlias());
                        JSONObject recInstanceHostAliasJsonObject = JSONObject.fromObject((Object)rechost.getHostAlias());
                        if (!srcInstanceHostAliasJsonObject.isEmpty() && !srcInstanceHostAliasJsonObject.get(instanceName).equals(recInstanceHostAliasJsonObject.get(instanceName))) continue;
                    }
                    hostStorageInfo.setHostSN(host.getDeviceSn());
                    hostStorageInfo.setAppVersion(dbVersion);
                    hostStorageInfo.setAppType(Integer.valueOf(po.getPoType()));
                    hostStorageInfo.setAppUserName(dbUserName);
                    hostStorageInfo.setPoUuid(po.getUuid());
                    this.setHostStorageInfoSnapInfo(hostStorageInfo);
                    if (hostStorageInfoKeySet.contains(hostStorageInfo.generateKey())) continue;
                    hostStorageInfos.add(hostStorageInfo);
                    hostStorageInfoKeySet.add(hostStorageInfo.generateKey());
                }
            }
        }
        return hostStorageInfos;
    }

    private void convertPoStorageInfoToHostStorageInfo(ProtectObjectStorageInfo poStorageInfo, HostDeviceStorageInfo hostStorageInfo) {
        hostStorageInfo.setStorageSubType(poStorageInfo.getStorageSubType());
        hostStorageInfo.setUdevRules(poStorageInfo.getUdevFlag());
        hostStorageInfo.setMountPoint(poStorageInfo.getMountPoint());
        hostStorageInfo.setDeviceName(poStorageInfo.getDeviceName());
        hostStorageInfo.setLbaAddress(poStorageInfo.getLabAddress());
        hostStorageInfo.setStorageType(poStorageInfo.getStorageType());
        hostStorageInfo.setVgName(poStorageInfo.getVolumeGroupName());
        hostStorageInfo.setVgMapInfo(poStorageInfo.getVgMapInfo());
        hostStorageInfo.setPvName(poStorageInfo.getPvName());
        hostStorageInfo.setProDeviceName(poStorageInfo.getDeviceName());
        hostStorageInfo.setProMountPoint(poStorageInfo.getMountPoint());
        hostStorageInfo.setSrcLunWWN(poStorageInfo.getLunWWN());
    }

    protected void setHostStorageDeviceIdAndLunIdInfo(List<RelicaStorageInfo> replicaStorages, int recoveryPlanType, int templateType, ProtectObjectStorageInfo poStorageInfo, HostDeviceStorageInfo hostStorageInfo, RecoveryProcessorContext context) {
        for (RelicaStorageInfo relicaStorage : replicaStorages) {
            if (!ProtectObjectAppUtil.checkPoStorage(poStorageInfo, relicaStorage)) continue;
            if (DrmEnumDefine.RecoveryPlanTypeE.REMOTE.getValue() == recoveryPlanType && DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() != this.getProcType()) {
                hostStorageInfo.setDeviceId(relicaStorage.getStorageProviderSN());
                hostStorageInfo.setLunId(relicaStorage.getStorageId());
                break;
            }
            if (PolicyTemplateType.SAN_HYPER_VAULT_POLICYTEMPLATE.contains(templateType)) {
                this.setStorageForSanHyperVault(hostStorageInfo, relicaStorage);
                break;
            }
            hostStorageInfo.setDeviceId(relicaStorage.getSrcStorageProviderSN());
            hostStorageInfo.setLunId(relicaStorage.getSrcStorageId());
            break;
        }
    }

    private void setStorageForSanHyperVault(HostDeviceStorageInfo hostStorageInfo, RelicaStorageInfo relicaStorage) {
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA.getValue() == this.getProcType() || DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() == this.getProcType()) {
            hostStorageInfo.setDeviceId(relicaStorage.getSrcStorageProviderSN());
            hostStorageInfo.setLunId(relicaStorage.getSrcStorageId());
        } else {
            String lunWwn = relicaStorage.getProtectObjectStorageWwn();
            List resources = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResourceByWwn(new String[]{lunWwn});
            if (VerifyUtil.isEmpty((Collection)resources)) {
                logger.error((Object)("resources null,lunWwn=" + lunWwn), 90160758786989L);
                return;
            }
            hostStorageInfo.setDeviceId(((StorageResource)resources.get(0)).getDevSn());
            hostStorageInfo.setLunId(((StorageResource)resources.get(0)).getResourceId());
        }
    }

    protected void setHostStorageInfoSnapInfo(HostDeviceStorageInfo hostStorageInfo) {
        for (Map.Entry<String, Boolean> entry : this.lastProcResult.entrySet()) {
            String key = entry.getKey();
            String[] preProps = key.split(":");
            if (preProps.length <= 1) {
                logger.warn((Object)("lastProcResult is error, key:" + key), 90160758786989L);
                continue;
            }
            String preKey = preProps[1];
            String[] props = preKey.split(";");
            String deviceId = this.getValue(props[0]);
            String lunId = this.getValue(props[1]);
            String snapshotId = this.getValue(props[2]);
            String wwn = this.getValue(props[3]);
            if ("null".equals(wwn) || "--".equals(wwn)) {
                wwn = "";
            }
            if (!this.setSnapshotIdAndWwn(hostStorageInfo, deviceId, lunId, snapshotId, wwn)) continue;
            return;
        }
    }

    private boolean setSnapshotIdAndWwn(HostDeviceStorageInfo hostStorageInfo, String deviceId, String lunId, String snapshotId, String wwn) {
        if (VerifyUtil.isEmpty((Object)hostStorageInfo)) {
            logger.info((Object)"hostStorageInfo is empty or null");
            return false;
        }
        List<StorageResource> resources = this.getTargetResources(hostStorageInfo);
        if (VerifyUtil.isEmpty(resources)) {
            logger.error((Object)"resources is null or empty", 90160758786989L);
            return false;
        }
        for (StorageResource storageResource : resources) {
            if (!Lun.class.isInstance(storageResource)) {
                logger.info((Object)"storageResources is not Lun");
                continue;
            }
            Lun lun = (Lun)Lun.class.cast(storageResource);
            if (!lun.getDevSn().equals(deviceId) || !lun.getLunId().equals(lunId)) continue;
            hostStorageInfo.setSnapshotId(snapshotId);
            hostStorageInfo.setWwn(wwn.toLowerCase(Locale.ENGLISH));
            return true;
        }
        return false;
    }

    private List<StorageResource> getTargetResources(HostDeviceStorageInfo hostStorageInfo) {
        String devSN = hostStorageInfo.getDeviceId();
        String lunId = hostStorageInfo.getLunId();
        Lun lun = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getLunBySnAndLunId(devSN, lunId);
        if (VerifyUtil.isEmpty((Object)lun)) {
            logger.info((Object)("lun is empty or null,devSN =" + devSN));
            return null;
        }
        List resources = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResourceByWwn(new String[]{lun.getWwn()});
        return resources;
    }

    protected boolean calcProcessResultBySubProc() {
        boolean executeResult = super.calcProcessResultBySubProc();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() == this.getProcStatus()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            executeResult = false;
        }
        return executeResult;
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.host.recovery.process.MountHostDeviceProcessor.des");
    }
}

