/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.app.constants.DrmAppEnumDefine;
import com.huawei.ism.drm.app.sdk.model.HostDeviceStorageInfo;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.host.device.DeviceProcessorManager;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.util.DBRecoveryTools;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.List;

public class MountHostDeviceSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -5922416498960746126L;
    private static final Log LOGGER = LogFactory.getInstance(MountHostDeviceSubProcessor.class);
    private String hostSN;
    private String hostName;
    private String poUuid;
    private String poName;
    private DrmAppEnumDefine.CLUSTER_TYPE_E clusterType;
    private String proProviderType;
    private String vgActiveMode;
    private List<HostDeviceStorageInfo> hostDeviceStorageInfos;
    private List<ProtectObject> protectObjects;
    private Boolean result = Boolean.FALSE;
    private Long errorCode;

    public String getHostSN() {
        return this.hostSN;
    }

    public void setHostSN(String hostSN) {
        this.hostSN = hostSN;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getPoUuid() {
        return this.poUuid;
    }

    public void setPoUuid(String poUuid) {
        this.poUuid = poUuid;
    }

    public String getPoName() {
        return this.poName;
    }

    public void setPoName(String poName) {
        this.poName = poName;
    }

    public DrmAppEnumDefine.CLUSTER_TYPE_E getClusterType() {
        return this.clusterType;
    }

    public void setClusterType(DrmAppEnumDefine.CLUSTER_TYPE_E clusterType) {
        this.clusterType = clusterType;
    }

    public String getProProviderType() {
        return this.proProviderType;
    }

    public void setProProviderType(String proProviderType) {
        this.proProviderType = proProviderType;
    }

    public String getVgActiveMode() {
        return this.vgActiveMode;
    }

    public void setVgActiveMode(String vgActiveMode) {
        this.vgActiveMode = vgActiveMode;
    }

    public List<HostDeviceStorageInfo> getHostDeviceStorageInfos() {
        return this.hostDeviceStorageInfos;
    }

    public void setHostDeviceStorageInfos(List<HostDeviceStorageInfo> hostDeviceStorageInfos) {
        this.hostDeviceStorageInfos = hostDeviceStorageInfos;
    }

    public List<ProtectObject> getProtectObjects() {
        return this.protectObjects;
    }

    public void setProtectObjects(List<ProtectObject> protectObjects) {
        this.protectObjects = protectObjects;
    }

    public Boolean getResult() {
        return this.result;
    }

    public void setResult(Boolean result) {
        this.result = result;
    }

    public Long getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(Long errorCode) {
        this.errorCode = errorCode;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected boolean execute(RecoveryProcessorContext context) {
        this.generateProcessorName();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        this.mountToHost();
        if (this.result.booleanValue()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            LOGGER.info((Object)"end to mount host device.", 90160758786988L);
        } else {
            String procDetailKey = "ism.drm.recovery.mount.error";
            if (null != this.errorCode) {
                procDetailKey = "lego.err." + this.errorCode;
            }
            this.updateProcessDetail(procDetailKey, new String[0]);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        }
        return true;
    }

    protected void mountToHost() {
        List<DrHost> drHosts = DrHostUtil.getDrHostBySNs(new String[]{this.hostSN});
        if (VerifyUtil.isEmpty(drHosts)) {
            this.setResult(Boolean.FALSE);
            return;
        }
        DeviceProcessorManager.getInstance().executeMountProcessors(drHosts.get(0), this.hostDeviceStorageInfos, this.clusterType, this.proProviderType, this.vgActiveMode);
        for (HostDeviceStorageInfo hostDeviceStorageInfo : this.hostDeviceStorageInfos) {
            if (hostDeviceStorageInfo.getErrorCode() == 0L) continue;
            this.setResult(Boolean.FALSE);
            this.setErrorCode(hostDeviceStorageInfo.getErrorCode());
        }
        if (null == this.getErrorCode() || 0L == this.getErrorCode()) {
            this.setResult(Boolean.TRUE);
        }
    }

    protected String generateResultKey() {
        return DBRecoveryTools.getMountHostProcResultKey(this.hostSN);
    }

    private void generateProcessorName() {
        this.updateProcessName(this.getName());
        this.updateProcessNameParams(new String[]{this.hostName});
    }
}

