/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.recovery.process;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.host.discovery.proxy.HostApplicationDiscoverProxy;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.host.sdk.model.Host;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class RefreshHostSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 2462925564560426284L;
    private static final Log LOGGER = LogFactory.getInstance(RefreshHostSubProcessor.class);
    private String deviceId;
    private String hostDeviceName;
    private String hostSN;

    public RefreshHostSubProcessor() {
        this.setIsNeedSave(false);
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getHostDeviceName() {
        return this.hostDeviceName;
    }

    public void setHostDeviceName(String hostDeviceName) {
        this.hostDeviceName = hostDeviceName;
    }

    public String getHostSN() {
        return this.hostSN;
    }

    public void setHostSN(String hostSN) {
        this.hostSN = hostSN;
    }

    public boolean execute(RecoveryProcessorContext context) {
        try {
            this.generateProcessorName();
            if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
                return true;
            }
            this.refreshHosts();
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Refreshing host failed.", (Throwable)e, 90160758787071L);
            this.updateProcessDetail(e);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Refreshing host failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            this.updateProcessDetail("lego.err.-1", new String[0]);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }

    private void refreshHosts() {
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        List drHosts = recoveryService.getDrHostsByDrHostOrGroupId(this.getHostSN());
        IMoDao moDao = CommonDAOLocator.getMoDao();
        HostApplicationDiscoverProxy hostAppDiscoverProxy = HostApplicationDiscoverProxy.getInstance();
        for (DrHost drHost : drHosts) {
            Host host = (Host)moDao.getMo(Host.class, "hostSN", (Object)drHost.getDeviceSn());
            if (null == host) {
                LOGGER.error((Object)("get host is null,hostSn=" + drHost.getDeviceSn()), 90160758787071L);
                throw new LegoCheckedException(1073947394L);
            }
            host.setChildMos(new HashSet());
            INeMgrProtocolExtendService service = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
            NeMgrProtocolExtend extend = service.findByMoId(host.getMoId());
            Map<Integer, List<ManagedObject>> results = hostAppDiscoverProxy.discoverApplication(extend);
            DrHostUtil.updateAppInfo(host, results);
            DrHostUtil.setHostDisks(host, extend);
            moDao.addMoAndSubMoWithoutMsg((ManagedObject)host, new HashMap());
        }
    }

    private void generateProcessorName() {
        DrResource resource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(this.hostSN);
        String hostName = this.hostSN;
        if (null != resource && !VerifyUtil.isEmpty((String)resource.getName())) {
            hostName = resource.getName();
        }
        String pName = this.getName();
        this.updateProcessName(pName);
        this.updateProcessNameParams(new String[]{hostName, this.hostDeviceName});
    }

    public String generateResultKey() {
        String key = this.getRefreshHostPorcResultKey(this.hostSN);
        return key;
    }

    private String getRefreshHostPorcResultKey(String disasterHostSN) {
        StringBuilder builder = new StringBuilder();
        builder.append("HostSN=");
        builder.append(disasterHostSN);
        return builder.toString();
    }
}

