/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.recovery.process.builder;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.host.recovery.process.DeleteSnapshotMappingSubProcessor;
import com.huawei.ism.drm.host.recovery.process.MappingSnapshotReplicaSubProcessor;
import com.huawei.ism.drm.protection.replica.sdk.model.LocalStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.recovery.process.IMappingReplicaSubProcessorBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MappingSnapshotReplicaProcessorBuilder
implements IMappingReplicaSubProcessorBuilder {
    public Set<RecoveryProcessor> buildMappingProcessor(RecoveryProcessor parent, ProtectGroupReplica replia) {
        HashSet<RecoveryProcessor> results = new HashSet<RecoveryProcessor>();
        String hostOrHostgroupId = replia.getMountedHost();
        Set protectObjectReplicaList = replia.getReplicas();
        for (ProtectObjectReplica protectObjectReplica : protectObjectReplicaList) {
            Set storageReplicaList = protectObjectReplica.getStorageInfos();
            for (RelicaStorageInfo storageInfo : storageReplicaList) {
                MappingSnapshotReplicaSubProcessor processor = new MappingSnapshotReplicaSubProcessor();
                processor.setProcName("com.huawei.ism.drm.host.recovery.process.MappingSnapshotCopySubProcessor");
                processor.setProcType(parent.getProcType());
                processor.setPlanId(parent.getPlanId());
                processor.setProcessId(parent.getProcessId());
                processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
                processor.setParentProc(parent);
                processor.setReplicaSourceId(storageInfo.getSrcStorageId());
                processor.setDeviceId(storageInfo.getSrcStorageProviderSN());
                processor.setReplicaId(storageInfo.getStorageId());
                processor.setReplicaName(((LocalStorageReplica)storageInfo).getSnapshotName());
                processor.setMountHostOrHostGroupId(hostOrHostgroupId);
                processor.setLunGroupId(replia.getProperty("lunGroupId"));
                results.add((RecoveryProcessor)processor);
            }
        }
        return results;
    }

    public Set<RecoveryProcessor> buildDeleteMappingProcessor(RecoveryProcessor parent, List<RecoveryProcessor> processors) {
        HashSet<RecoveryProcessor> results = new HashSet<RecoveryProcessor>();
        for (RecoveryProcessor processor : processors) {
            if (!(processor instanceof MappingSnapshotReplicaSubProcessor)) continue;
            MappingSnapshotReplicaSubProcessor tmpProcessor = (MappingSnapshotReplicaSubProcessor)processor;
            DeleteSnapshotMappingSubProcessor deleteMappingProcessor = new DeleteSnapshotMappingSubProcessor();
            deleteMappingProcessor.setProcType(parent.getProcType());
            deleteMappingProcessor.setPlanId(parent.getPlanId());
            deleteMappingProcessor.setProcessId(parent.getProcessId());
            deleteMappingProcessor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            deleteMappingProcessor.setParentProc(parent);
            deleteMappingProcessor.setLunId(tmpProcessor.getReplicaSourceId());
            deleteMappingProcessor.setDeviceId(tmpProcessor.getDeviceId());
            deleteMappingProcessor.setSnapshotId(tmpProcessor.getReplicaId());
            deleteMappingProcessor.setSnapshotName(tmpProcessor.getReplicaName());
            deleteMappingProcessor.setHostOrGroupId(tmpProcessor.getMountHostOrHostGroupId());
            results.add((RecoveryProcessor)deleteMappingProcessor);
        }
        return results;
    }

    public int getReplicaType() {
        return 3;
    }
}

