/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.service.impl;

import com.huawei.ism.base.sdk.model.Disk;
import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.CommonComparator;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.database.sdk.model.ClusterInstance;
import com.huawei.ism.database.sdk.model.Database;
import com.huawei.ism.database.sdk.model.DatabaseInstance;
import com.huawei.ism.drm.app.constants.DrmAppEnumDefine;
import com.huawei.ism.drm.app.sdk.model.HostDeviceStorageInfo;
import com.huawei.ism.drm.application.manager.proxy.ApplicationAdapterProxy;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.NeMgrProtocolExtendServiceUtil;
import com.huawei.ism.drm.common.sdk.model.ScriptSchemeDefTemplate;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.host.device.DeviceProcessorManager;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.host.sdk.service.IHostService;
import com.huawei.ism.drm.host.util.DBRecoveryTools;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.host.util.ProtectObjectAppUtil;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.protection.action.service.IHostScriptSchemeService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.recovery.sdk.model.HostGroupVO;
import com.huawei.ism.drm.recovery.sdk.model.HostVO;
import com.huawei.ism.drm.recovery.sdk.model.ResourceVO;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.site.util.SiteResourceManagerUtil;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLunBaseManager;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.host.sdk.model.Host;
import com.huawei.ism.host.sdk.model.HostFileSystem;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate5.HibernateTemplate;

@Service(name="com.huawei.ism.drm.host.sdk.service.IHostService", desc="", interfaceClass=IHostService.class)
public class HostServiceImpl
extends BaseService
implements IHostService {
    private static Log logger = LogFactory.getInstance(HostServiceImpl.class);
    private static final long LOG_CODE = -1L;
    private static final long SCRIPT_FAILED = 2002L;
    private IMoDao moDao;
    private ISiteService siteService;
    private IStorageService storageService;

    public void setMoDao(IMoDao moDao) {
        this.moDao = moDao;
    }

    public void setSiteService(ISiteService siteService) {
        this.siteService = siteService;
    }

    public void setStorageService(IStorageService storageService) {
        this.storageService = storageService;
    }

    private void isHostUsed(String hostSN) {
        DrResource parent;
        DrHost drResource = (DrHost)((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySnInLocalSite(hostSN, "ism.drm.deviceType.drhost.mainType");
        if (null != drResource && null != (parent = drResource.getParentDrResource())) {
            throw new LegoCheckedException(1073947657L);
        }
        String hql = "from ProtectGroup as pg where poProviderSN = ?";
        List pgs = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(hql, new Object[]{hostSN});
        if (null != pgs && !pgs.isEmpty()) {
            logger.error((Object)("Host(" + hostSN + ") has been used by protectgroup.Failed to unRegister."), 90160777660712L);
            throw new LegoCheckedException(1073947657L);
        }
        NetworkEntity hostNe = (NetworkEntity)CommonDAOLocator.getMoDao().getMo(NetworkEntity.class, "sn", (Object)hostSN);
        if (null == hostNe) {
            logger.error((Object)("Host(" + hostSN + ") is not existed"), 90160777660712L);
            return;
        }
        boolean isUsed = ((IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class)).isUsedHostGroupByRp(hostSN);
        if (isUsed) {
            logger.error((Object)("Host(" + hostSN + ") has been used by recoveryplan.Failed to unRegister."), 90160777660712L);
            throw new LegoCheckedException(1073947657L);
        }
    }

    public Host getHost(String hostSN) {
        if (VerifyUtil.isEmpty((String)hostSN)) {
            logger.error((Object)("Host(" + hostSN + ") dosen't exist.Failed to get."), 90160777660720L);
            throw new LegoCheckedException(1073947393L);
        }
        Host host = (Host)this.moDao.getMo(Host.class, "hostSN", (Object)hostSN);
        return host;
    }

    public Host getHostByIP(String ipAddress) {
        if (VerifyUtil.isEmpty((String)ipAddress)) {
            logger.error((Object)("Host(" + ipAddress + ") dosen't exist.Failed to get."), 90160777660720L);
            throw new LegoCheckedException(1073947393L);
        }
        Host host = (Host)this.moDao.getMo(Host.class, "managedIpAddress", (Object)ipAddress);
        return host;
    }

    public List<DrHost> getHostListBySiteId(String siteId, Long userId) {
        Site site = SiteResourceManagerUtil.isSiteExisted((String)siteId);
        if (null == site) {
            logger.error((Object)"site is empty.");
            return new ArrayList<DrHost>();
        }
        List sns = SiteResourceManagerUtil.getResourceSNBySiteId((String)siteId, (int)1);
        if (VerifyUtil.isEmpty((Collection)sns)) {
            return new ArrayList<DrHost>();
        }
        if (site.getSiteType() == 0 && null != userId && VerifyUtil.isEmpty((Collection)(sns = SiteResourceManagerUtil.filterDrResourceSN((List)sns, (Long)userId)))) {
            return new ArrayList<DrHost>();
        }
        return SiteResourceManagerUtil.translateCriAndGetResource((List)sns, DrHost.class, (String)"deviceSn", (String)siteId);
    }

    public List<DrHost> getHostAndGroupListBySite(List<String> siteIds, Long userId) {
        if (VerifyUtil.isEmpty(siteIds)) {
            logger.error((Object)"siteIds is empty.");
            return Collections.emptyList();
        }
        ArrayList<DrHost> hosts = new ArrayList<DrHost>();
        for (String siteId : siteIds) {
            List<DrHost> hostsInSite = this.getHostListBySiteId(siteId, userId);
            if (null == hostsInSite) continue;
            hosts.addAll(hostsInSite);
        }
        ArrayList<DrHost> resultList = new ArrayList<DrHost>();
        ArrayList<DrHost> hostNotInGroupList = new ArrayList<DrHost>();
        for (DrHost host : hosts) {
            if (null != host.getParentDrResource()) {
                DrHostGroup hostGroup = (DrHostGroup)host.getParentDrResource();
                DrHost hostGroupInfo = new DrHost();
                hostGroupInfo.setDbId(hostGroup.getDbId());
                hostGroupInfo.setDeviceSn(hostGroup.getDeviceSn());
                hostGroupInfo.setOsType(hostGroup.getOsType());
                hostGroupInfo.setName(hostGroup.getName());
                hostGroupInfo.setChildResources(hostGroup.getChildResources());
                if (resultList.contains(hostGroupInfo)) continue;
                resultList.add(hostGroupInfo);
                continue;
            }
            hostNotInGroupList.add(host);
        }
        Collections.sort(resultList, new CommonComparator("name", true));
        Collections.sort(hostNotInGroupList, new CommonComparator("name", true));
        resultList.addAll(hostNotInGroupList);
        return resultList;
    }

    public ManagedObject getHostByMoId(Long moId) {
        return (ManagedObject)CommonDAOLocator.getMoDao().get((Serializable)moId);
    }

    public void checkHostUsed(Long moId) {
        if (null == moId) {
            throw new LegoCheckedException(1073947393L);
        }
        ManagedObject ob = (ManagedObject)CommonDAOLocator.getMoDao().get((Serializable)moId);
        if (null == ob) {
            logger.error((Object)"delete Host error because mo is null", 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        DrResource resource = SiteResourceManagerUtil.getDrResourceByMoId((Long)moId);
        if (null == resource) {
            return;
        }
        this.isHostUsed(resource.getDeviceSn());
    }

    public List<DrHost> getHostWithoutHostGroup(String siteId, Long userId) {
        List<DrHost> current = this.getHostListBySiteId(siteId, userId);
        ArrayList<DrHost> hostList = new ArrayList<DrHost>();
        for (DrHost host : new ArrayList<DrHost>(current)) {
            if (null == host.getParentDrResource()) continue;
            hostList.add(host);
        }
        current.removeAll(hostList);
        return current;
    }

    public List<Database> queryAllDB(String orderBy, boolean isAsc, String hostSN, int dbType) {
        if (VerifyUtil.isEmpty((String)hostSN)) {
            logger.error((Object)"getting databaseinstance is error because hostSN is empty", 90160758786896L);
            throw new LegoCheckedException(1073947393L);
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("hostSN", hostSN);
        props.put("dbType", NumberUtil.convertToInteger((Object)dbType));
        List allDBIns = this.moDao.findMoBy(DatabaseInstance.class, orderBy, isAsc, props);
        if (VerifyUtil.isEmpty((Collection)allDBIns)) {
            logger.debug((Object)("query databaseinstance is empty in DB.,hostSN:" + hostSN + ",dbType:" + dbType), 90160758786896L);
            return new ArrayList<Database>();
        }
        Object[] moIds = new Long[allDBIns.size()];
        for (int i = 0; i < allDBIns.size(); ++i) {
            moIds[i] = ((DatabaseInstance)allDBIns.get(i)).getMoId();
        }
        props.clear();
        props.put("parentMo.moId", moIds);
        List allDB = this.moDao.findMoBy(Database.class, orderBy, isAsc, props);
        if (VerifyUtil.isEmpty((Collection)allDB)) {
            logger.debug((Object)("query Database is null,parentMo.moId=" + Arrays.toString(moIds) + ",hostSN:" + hostSN + ",dbType:" + dbType), 90160758786896L);
        }
        return allDB;
    }

    public List<HostFileSystem> queryAllFS(String orderBy, boolean isAsc, String hostSN, int fsType) {
        if (VerifyUtil.isEmpty((String)hostSN)) {
            logger.error((Object)"getting databaseinstance is error because hostSN is empty", 90160758786896L);
            throw new LegoCheckedException(1073947393L);
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("hostSN", hostSN);
        List allFSIns = this.moDao.findMoBy(HostFileSystem.class, orderBy, isAsc, props);
        if (VerifyUtil.isEmpty((Collection)allFSIns)) {
            return new ArrayList<HostFileSystem>();
        }
        return allFSIns;
    }

    public List<ClusterInstance> queryAllCluster(String orderBy, boolean isAsc, String hostSN, int type) {
        if (VerifyUtil.isEmpty((String)hostSN)) {
            logger.error((Object)"Getting openGauss cluster error because hostSN is empty", 90160758786896L);
            throw new LegoCheckedException(1073947393L);
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("hostSN", hostSN);
        props.put("clusterType", type);
        List clusters = this.moDao.findMoBy(ClusterInstance.class, orderBy, isAsc, props);
        if (VerifyUtil.isEmpty((Collection)clusters)) {
            return Collections.emptyList();
        }
        return clusters;
    }

    public List<DrHost> getDrHostsBySns(String[] hostSns) {
        if (VerifyUtil.isEmpty((Object[])hostSns)) {
            logger.error((Object)"The input parameters is empty.", 90160758786896L);
            throw new LegoCheckedException(1073947393L);
        }
        return DrHostUtil.getDrHostBySNs(hostSns);
    }

    public List<Integer> getHostAppTypes(String hostSn) {
        List clusters;
        List<HostFileSystem> fileSystems;
        HashSet<Integer> appTypes = new HashSet<Integer>();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("hostSN", hostSn);
        List dbInstances = this.moDao.findMoBy(DatabaseInstance.class, "name", false, props);
        if (!VerifyUtil.isEmpty((Collection)dbInstances)) {
            for (DatabaseInstance dbInstance : dbInstances) {
                appTypes.add(dbInstance.getDbType());
            }
        }
        if (!VerifyUtil.isEmpty(fileSystems = this.queryAllFS("name", true, hostSn, 9))) {
            appTypes.add(9);
        }
        if (!VerifyUtil.isEmpty((Collection)(clusters = this.moDao.findMoBy(ClusterInstance.class, "name", false, props)))) {
            for (ClusterInstance cluster : clusters) {
                appTypes.add(cluster.getClusterType());
            }
        }
        return new ArrayList<Integer>(appTypes);
    }

    public List<DrHost> getDrHostsByManageServerId(String manageServerId, String osType, Long userId) {
        HibernateTemplate template;
        List drHosts;
        List sites = this.siteService.getSites(manageServerId);
        if (VerifyUtil.isEmpty((Collection)sites)) {
            return Collections.emptyList();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("from DrHost t where t.parentDrResource=null and t.siteId in(");
        ArrayList<String> params = new ArrayList<String>();
        for (Site site : sites) {
            sb.append("?,");
            params.add(site.getSiteId());
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        if (!VerifyUtil.isEmpty((String)osType)) {
            sb.append(" and t.osType=?");
            params.add(osType);
        }
        if (VerifyUtil.isEmpty((Collection)(drHosts = (template = CommonDAOLocator.getBaseDao().getHibernateTemplate()).find(sb.toString(), params.toArray())))) {
            return Collections.emptyList();
        }
        HashMap<String, Site> siteMap = new HashMap<String, Site>();
        for (Site site : sites) {
            siteMap.put(site.getSiteId(), site);
        }
        if (((Site)sites.get(0)).getSiteType() == 0) {
            drHosts = SiteResourceManagerUtil.filterDrResource((List)drHosts, (Long)userId);
        }
        ArrayList<DrHost> results = new ArrayList<DrHost>();
        for (DrResource drHost : drHosts) {
            Site site = (Site)siteMap.get(drHost.getSiteId());
            if (null != site) {
                drHost.setExtProperty(site.getName());
            }
            results.add((DrHost)drHost);
        }
        return results;
    }

    public void stopDatabase(String hostSn, String poUuid) {
        if (VerifyUtil.isEmpty((String)hostSn) || VerifyUtil.isEmpty((String)poUuid)) {
            throw new LegoCheckedException(1073947393L);
        }
        try {
            ProtectObject po = ProtectObjectAppUtil.getProtectObjectByPoUUID(poUuid);
            if (null == po) {
                throw new LegoCheckedException(1073947393L);
            }
            po.setProviderSN(hostSn);
            po.getProps().put("APP_PROC_TYPE", String.valueOf(DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue()));
            ApplicationAdapterProxy.getInstance().getAppManager(po.getPoType()).suspend(po);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("stopDatabase po(" + poUuid + ") LegoCheckedException"), (Throwable)e, -1L);
            long errorCode = e.getErrorCode();
            if (errorCode == 1L) {
                throw new LegoCheckedException(2002L, (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            String errorMsg = "stopDatabase po(" + poUuid + ") Exception";
            ExceptionUtil.rethrowException((Throwable)e, (String)errorMsg, (long)-1L, null, (Log)logger);
        }
    }

    public void stopAsmInstance(String hostSn, String instName) {
        try {
            if (VerifyUtil.isEmpty((String)hostSn) || VerifyUtil.isEmpty((String)instName)) {
                throw new LegoCheckedException(1073947393L);
            }
            List<ProtectObject> poList = this.getPoListByHostSn(hostSn);
            ProtectObject protectObject = this.getAsmProtectObject(poList, instName);
            Map dbProps = protectObject.getProps();
            ProtectObject po = new ProtectObject();
            Map newProps = po.getProps();
            po.setProviderSN(hostSn);
            po.setPoType(1);
            newProps.put("PROVIDER_TYPE", String.valueOf(DrmEnumDefine.ProviderTypeE.HOST.getValue()));
            newProps.put("VERSION", dbProps.get("VERSION"));
            newProps.put("INSTANCENAME", instName);
            newProps.put("ASM_USERNAME", dbProps.get("ASM_USERNAME"));
            newProps.put("ASM_PASSWD", dbProps.get("ASM_PASSWD"));
            newProps.put("SERVICENAME", "SERVICENAME");
            newProps.put("IS_CLOSE_ASM", "1");
            newProps.put("AUTH_TYPE", dbProps.get("AUTH_TYPE"));
            newProps.put("IS_ASM", "1");
            ApplicationAdapterProxy.getInstance().getAppManager(po.getPoType()).suspend(po);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("stopAsmInstance LegoCheckedException\uff0cinstName=" + instName), (Throwable)e, -1L);
            long errorCode = e.getErrorCode();
            if (errorCode == 1L) {
                throw new LegoCheckedException(2002L, (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            String errorMsg = "stopAsmInstance LegoCheckedException\uff0cinstName=" + instName;
            ExceptionUtil.rethrowException((Throwable)e, (String)errorMsg, (long)-1L, null, (Log)logger);
        }
    }

    private List<ProtectObject> getPoListByHostSn(String hostSn) {
        String drResourceSn = hostSn;
        DrResource resource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(hostSn);
        if (null == resource || !(resource instanceof DrHost)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (null != resource.getParentDrResource()) {
            drResourceSn = resource.getParentDrResource().getDbId();
        }
        List<ProtectObject> poList = ProtectObjectAppUtil.getProtectObjectByHostSn(drResourceSn);
        return poList;
    }

    private ProtectObject getAsmProtectObject(List<ProtectObject> poList, String instName) {
        if (VerifyUtil.isEmpty(poList)) {
            throw new LegoCheckedException(1073947393L);
        }
        ProtectObject po = null;
        for (ProtectObject protectObject : poList) {
            Map props = protectObject.getProps();
            if (!"1".equals(props.get("IS_ASM")) || !instName.equals(props.get("ASM_INSTANCENAME"))) continue;
            po = protectObject;
            if (!"1".equals(props.get("AUTH_TYPE"))) continue;
            break;
        }
        if (null == po) {
            throw new LegoCheckedException(1073947393L);
        }
        return po;
    }

    public OperationResult unMappingLun(String devSn, String lunId, DrResource drResource, String hostOrGroupId) {
        HashSet<String> hostOrGroupIdList = new HashSet<String>();
        hostOrGroupIdList.add(hostOrGroupId);
        Map<String, ResourceVO> resourceVOs = DrHostUtil.getHostInitiators(hostOrGroupIdList);
        if (VerifyUtil.isEmpty(resourceVOs)) {
            logger.error((Object)("unMapping,ResourceVO is empty,hostOrGroupId=" + hostOrGroupId), -1L);
            throw new LegoCheckedException(1073947393L);
        }
        StorageLunManagerProxy storageManagerProxy = StorageLunManagerProxy.getInstance();
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        String deviceType = recoveryService.getStorageType(devSn);
        IStorageLunBaseManager proxy = storageManagerProxy.getStorageLunMgrByDevType(deviceType);
        if (drResource instanceof DrHost) {
            return proxy.removeLunMapping(devSn, lunId, (HostVO)resourceVOs.get(hostOrGroupId));
        }
        return proxy.removeLunMapping(devSn, lunId, (HostGroupVO)resourceVOs.get(hostOrGroupId));
    }

    public Map<String, Long> umountDevices(String hostSn, List<String> poUuids) {
        String[] poUuidsArray = poUuids.toArray(new String[poUuids.size()]);
        List<ProtectObject> pos = ProtectObjectAppUtil.getProtectObjecstByPoUUIDs(poUuidsArray);
        List<DrHost> drHosts = DrHostUtil.getDrHostBySNs(new String[]{hostSn});
        if (VerifyUtil.isEmpty(drHosts) || VerifyUtil.isEmpty(pos)) {
            logger.error((Object)"drHosts or pos is empty.");
            throw new LegoCheckedException(1073947394L);
        }
        DrHost drHost = drHosts.get(0);
        DrmAppEnumDefine.CLUSTER_TYPE_E eClusterType = null;
        if (null != drHost.getParentDrResource()) {
            DrHostGroup hostGroup = (DrHostGroup)drHost.getParentDrResource();
            eClusterType = DrmAppEnumDefine.CLUSTER_TYPE_E.getType((int)hostGroup.getClusterType());
        }
        List<HostDeviceStorageInfo> hostDeviceStorageInfoList = this.getHostDeviceStorageList(hostSn, pos, drHost, eClusterType);
        DeviceProcessorManager.getInstance().executeUmountProcessors(drHosts.get(0), hostDeviceStorageInfoList, eClusterType);
        HashMap<String, Long> resultMap = new HashMap<String, Long>();
        for (HostDeviceStorageInfo hostDeviceStorageInfo : hostDeviceStorageInfoList) {
            String key = DBRecoveryTools.getUmountHostProcResultKey(hostSn);
            if (hostDeviceStorageInfo.getErrorCode() == 0L) continue;
            resultMap.put(key, hostDeviceStorageInfo.getErrorCode());
        }
        return resultMap;
    }

    private List<HostDeviceStorageInfo> getHostDeviceStorageList(String hostSn, List<ProtectObject> pos, DrHost drHost, DrmAppEnumDefine.CLUSTER_TYPE_E eClusterType) {
        ArrayList<HostDeviceStorageInfo> hostDeviceStorageInfoList = new ArrayList<HostDeviceStorageInfo>();
        for (ProtectObject po : pos) {
            String dbUserName = (String)po.getProps().get("USERNAME");
            for (ProtectObjectStorageInfo poStorageInfo : po.getUsedStorageResourceSet()) {
                if (this.isNotCurrentHostAchiveLogLun((DrResource)drHost, poStorageInfo, eClusterType)) {
                    logger.error((Object)("The achive log lun is not current host, wwn:" + poStorageInfo.getLunWWN() + ", device name: " + poStorageInfo.getDeviceName() + ", mount point: " + poStorageInfo.getMountPoint()), -1L);
                    continue;
                }
                HostDeviceStorageInfo hostDeviceStorageInfo = new HostDeviceStorageInfo();
                this.convertPoStorageInfoToHostDeviceStorageInfo(poStorageInfo, hostDeviceStorageInfo);
                hostDeviceStorageInfo.setHostSN(hostSn);
                hostDeviceStorageInfo.setAppType(Integer.valueOf(po.getPoType()));
                hostDeviceStorageInfo.setAppUserName(dbUserName);
                hostDeviceStorageInfo.setPoUuid(po.getUuid());
                hostDeviceStorageInfo.setAlias(poStorageInfo.getAlias());
                hostDeviceStorageInfoList.add(hostDeviceStorageInfo);
            }
        }
        return hostDeviceStorageInfoList;
    }

    private void convertPoStorageInfoToHostDeviceStorageInfo(ProtectObjectStorageInfo poStorageInfo, HostDeviceStorageInfo hostDeviceStorageInfo) {
        hostDeviceStorageInfo.setDeviceId(poStorageInfo.getResourceProviderSN());
        hostDeviceStorageInfo.setHostName(poStorageInfo.getHostName());
        hostDeviceStorageInfo.setDeviceName(poStorageInfo.getDeviceName());
        hostDeviceStorageInfo.setUdevRules(poStorageInfo.getUdevFlag());
        hostDeviceStorageInfo.setLbaAddress(poStorageInfo.getLabAddress());
        hostDeviceStorageInfo.setLunId(poStorageInfo.getResourceId());
        hostDeviceStorageInfo.setMountPoint(poStorageInfo.getMountPoint());
        hostDeviceStorageInfo.setStorageSubType(poStorageInfo.getStorageSubType());
        hostDeviceStorageInfo.setStorageType(poStorageInfo.getStorageType());
        hostDeviceStorageInfo.setVgName(poStorageInfo.getVolumeGroupName());
        hostDeviceStorageInfo.setPvName(poStorageInfo.getPvName());
        hostDeviceStorageInfo.setWwn(poStorageInfo.getLunWWN());
        hostDeviceStorageInfo.setProDeviceName(poStorageInfo.getDeviceName());
        hostDeviceStorageInfo.setProMountPoint(poStorageInfo.getMountPoint());
    }

    public void testConnecting(String hostSn, String poUuid) {
        if (VerifyUtil.isEmpty((String)hostSn) || VerifyUtil.isEmpty((String)poUuid)) {
            logger.error((Object)"hostSn or poUuid is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        try {
            ProtectObject po = ProtectObjectAppUtil.getProtectObjectByPoUUID(poUuid);
            if (null == po) {
                throw new LegoCheckedException(1073947393L);
            }
            po.setProviderSN(hostSn);
            po.getProps().put("APP_PROC_TYPE", String.valueOf(DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue()));
            po.getProps().put("PROP_KEY_APP_RECOVERY_ACTION", "RECOVERY_ACTION_STOP_PROAPP");
            ApplicationAdapterProxy.getInstance().getAppManager(po.getPoType()).testConnecting(po);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("stopDatabase po(" + poUuid + ") LegoCheckedException"), (Throwable)e, -1L);
            long errorCode = e.getErrorCode();
            if (errorCode == 1L) {
                throw new LegoCheckedException(2002L, (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            String errorMsg = "stopDatabase po(" + poUuid + ") Exception";
            ExceptionUtil.rethrowException((Throwable)e, (String)errorMsg, (long)-1L, null, (Log)logger);
        }
    }

    private boolean isNotCurrentHostAchiveLogLun(DrResource host, ProtectObjectStorageInfo poStorageInfo, DrmAppEnumDefine.CLUSTER_TYPE_E eClusterType) {
        if (null == eClusterType || eClusterType != DrmAppEnumDefine.CLUSTER_TYPE_E.ORACLE_RAC) {
            return false;
        }
        return Integer.valueOf(1).equals(poStorageInfo.getArchiveLog()) && VerifyUtil.isEmpty((String)poStorageInfo.getAsmDiskGroupName()) && !host.getDeviceSn().equals(poStorageInfo.getAppName());
    }

    public List<Disk> queryDisks(String hostSn) {
        if (VerifyUtil.isEmpty((String)hostSn)) {
            logger.error((Object)"The hostSn is empty", 90160758786896L);
            throw new LegoCheckedException(1073947393L);
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("topMoUuid", hostSn);
        return this.moDao.findMoBy(Disk.class, "diskName", true, props);
    }

    public List<DrHost> getHostAndGroupListForHyperMetro(String lunWwn, Long userId) {
        List storageResourceList = this.storageService.getStorageResourceByWwn(new String[]{lunWwn});
        if (VerifyUtil.isEmpty((Collection)storageResourceList)) {
            logger.error((Object)"storageResourceList is empty.");
            return Collections.emptyList();
        }
        ArrayList<String> siteIds = new ArrayList<String>();
        for (StorageResource storageResource : storageResourceList) {
            IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
            DrResource drResource = resourceService.getDrResourceBySn(storageResource.getDevSn());
            if (null == drResource || siteIds.contains(drResource.getSiteId())) continue;
            siteIds.add(drResource.getSiteId());
        }
        return this.getHostAndGroupListBySite(siteIds, userId);
    }

    public List<ScriptSchemeDefTemplate> queryDefaultThirdScripts(String hostSn) {
        try {
            List scriptSchemeInfo = ((IHostScriptSchemeService)ServiceLocator.getInstance().getService(IHostScriptSchemeService.class)).queryDefaultThirdScripts();
            this.filterSchemeByOs(hostSn, scriptSchemeInfo);
            return scriptSchemeInfo;
        }
        catch (Exception e) {
            logger.error((Object)("Parsing script scheme template failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            return null;
        }
    }

    public ScriptSchemeDefTemplate queryScriptSchemeById(String schemeId) {
        ScriptSchemeDefTemplate scriptSchemeDefTemplate = ((IHostScriptSchemeService)ServiceLocator.getInstance().getService(IHostScriptSchemeService.class)).queryScriptSchemeById(schemeId);
        return scriptSchemeDefTemplate;
    }

    public Map<String, List<String>> queryCustomThirdScripts(String hostSn) {
        NeMgrProtocolExtend extend = DrHostUtil.getNeMgrProtocolExtend(NeMgrProtocolExtendServiceUtil.getNeMgrExtendService(), hostSn);
        extend.getExtendParams().put("mac_address", hostSn);
        List<String> userScriptNameList = DrHostUtil.queryThirdScript(extend);
        HashMap<String, List<String>> userScriptNames = new HashMap<String, List<String>>();
        userScriptNames.put("scripts", userScriptNameList);
        return userScriptNames;
    }

    public boolean isMounted(String hostSn) {
        boolean bl;
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            String sql = "select count(1) from ti_protectgroupreplica where MOUNTEDHOST=:_hostSn";
            NativeQuery query = session.createNativeQuery(sql);
            query.setParameter("_hostSn", (Object)hostSn);
            BigInteger count = (BigInteger)query.uniqueResult();
            bl = count.compareTo(BigInteger.ZERO) > 0;
        }
        catch (DataAccessException e) {
            try {
                logger.error((Object)("failed to query Replica hostmounted. hostSn:" + hostSn), (Throwable)e, 90160758786896L);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession((Session)session);
        return bl;
    }

    private void filterSchemeByOs(String hostSn, List<ScriptSchemeDefTemplate> scriptSchemeInfo) {
        int firstIndex;
        List<DrHost> drHosts = this.getDrHostsBySns(new String[]{hostSn});
        if (null == drHosts || drHosts.isEmpty()) {
            logger.error((Object)"failed to filter scheme by os, dr host is null or empty.");
            return;
        }
        String version = drHosts.get(0).getVersion();
        String osType = drHosts.get(0).getOsType();
        String replacedVersion = version.replaceAll("[^\\d]*(\\d+)", ".$1").replaceAll("^[^\\d]*|[^\\d]*$", "");
        int secondIndex = replacedVersion.indexOf(".", (firstIndex = replacedVersion.indexOf(".")) + 1);
        String handleVersion = secondIndex <= 0 ? replacedVersion : replacedVersion.substring(0, secondIndex);
        logger.info((Object)"host sn: %s, os type: %s, version: %s.", new Object[]{hostSn, osType, version});
        ArrayList<ScriptSchemeDefTemplate> templates = new ArrayList<ScriptSchemeDefTemplate>();
        templates.addAll(scriptSchemeInfo);
        for (ScriptSchemeDefTemplate scriptSchemeDefTemplate : templates) {
            String[] osArr = new String[]{};
            String osPlatform = "";
            Map os = scriptSchemeDefTemplate.getOs();
            if (null != os && os.containsKey("version")) {
                osArr = ((String)os.get("version")).split(",");
            }
            if (null != os && os.containsKey("platform")) {
                osPlatform = (String)os.get("platform");
            }
            if (Arrays.asList(osArr).contains(handleVersion) && osType.equals(osPlatform)) continue;
            scriptSchemeInfo.remove(scriptSchemeDefTemplate);
        }
    }
}

