/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.service.impl;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.sdk.service.IHostService;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteResourceService;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.site.util.SiteResourceManagerUtil;
import com.huawei.ism.host.sdk.model.Host;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@ServiceBoundInfo(methodName="onBind", targetBeanName="siteResourceServiceProxy", properties="resType:ism.drm.deviceType.drhost.mainType")
public class HostSiteResourceServiceImpl
implements ISiteResourceService {
    private static Log logger = LogFactory.getInstance(HostSiteResourceServiceImpl.class);

    public void isResourceUsed(Long moId) {
        ((IHostService)ServiceLocator.getInstance().getService(IHostService.class)).checkHostUsed(moId);
    }

    public void registerResource(Site site, String[] resSns) {
        if (null == site) {
            logger.error((Object)"site is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (0 == site.getSiteType() && VerifyUtil.isEmpty((Object[])resSns)) {
            return;
        }
        if (site.getSiteType() != 0) {
            logger.error((Object)("the type is error:" + site.getSiteType()), 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        this.batchSaveHostIntoDB(site, resSns);
    }

    private void batchSaveHostIntoDB(Site site, String[] resSns) {
        ArrayList<DrHost> drHosts = new ArrayList<DrHost>(resSns.length);
        for (String resSN : resSns) {
            NetworkEntity entity = (NetworkEntity)CommonDAOLocator.getMoDao().getMo(NetworkEntity.class, "sn", (Object)resSN);
            if (null == entity) {
                logger.error((Object)("the entity is not existed:" + resSN), 90160758787071L);
                throw new LegoCheckedException(1073947394L);
            }
            if (!(entity instanceof Host)) continue;
            if (null != this.getDrResourceBySn(resSN)) {
                logger.error((Object)("the host has been registered:" + resSN), 90160758787071L);
                throw new LegoCheckedException(1073947671L);
            }
            DrHost drHost = (DrHost)this.getDrResourceByMo(entity);
            drHost.setSiteId(site.getSiteId());
            drHosts.add(drHost);
        }
        if (!VerifyUtil.isEmpty(drHosts)) {
            CommonDAOLocator.getBaseDao().saveOrUpdateAll(drHosts);
        }
    }

    public void refreshResouce(Site site) {
        if (null == site) {
            logger.error((Object)"site is empty.");
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void removeOldHostGroup(IMoDao moDao, Map<String, DrResource> oldHostGroupMap) {
        if (VerifyUtil.isEmpty(oldHostGroupMap)) {
            return;
        }
        StringBuilder hql = new StringBuilder("from DrResource where dbId in(");
        ArrayList<String> params = new ArrayList<String>();
        for (Map.Entry<String, DrResource> entry : oldHostGroupMap.entrySet()) {
            hql.append("?,");
            params.add(entry.getKey());
        }
        hql.deleteCharAt(hql.length() - 1);
        hql.append(")");
        List hostGroups = moDao.getHibernateTemplate().find(hql.toString(), params.toArray());
        for (DrResource hostGroup : hostGroups) {
            if (!VerifyUtil.isEmpty((Collection)hostGroup.getChildResources())) continue;
            moDao.getHibernateTemplate().delete((Object)hostGroup);
        }
    }

    public int sum(String siteId, Long userId) {
        if (VerifyUtil.isEmpty((String)siteId)) {
            return 0;
        }
        List sns = SiteResourceManagerUtil.getResourceSNBySiteId((String)siteId, (int)1);
        if (VerifyUtil.isEmpty((Collection)sns)) {
            return 0;
        }
        Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(siteId);
        if (0 == site.getSiteType()) {
            sns = SiteResourceManagerUtil.filterDrResourceSN((List)sns, (Long)userId);
        }
        return sns.size();
    }

    public <T extends ManagedObject> DrResource getDrResourceByMo(T mo) {
        if (!(mo instanceof Host)) {
            logger.error((Object)"DrResource is not Host.");
            return null;
        }
        Host hostMO = (Host)mo;
        Integer port = null;
        NeMgrProtocolExtend neMgrProtocolExtend = this.getExtByHostList(hostMO);
        if (null != neMgrProtocolExtend) {
            String sPort = (String)neMgrProtocolExtend.getExtendParams().get("port");
            port = NumberUtil.parseInteger((Object)sPort);
        }
        DrHost host = DrHostUtil.buildDrHostByMo(hostMO, port);
        return host;
    }

    private NeMgrProtocolExtend getExtByHostList(Host host) {
        NeMgrProtocolExtend neMgrProtocolExtend;
        try {
            INeMgrProtocolExtendService service = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
            neMgrProtocolExtend = service.findByMoId(host.getMoId());
        }
        catch (Exception ex) {
            logger.error((Object)("unable to get extInfo of Host:" + host.getHostName() + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160758786880L);
            return null;
        }
        return neMgrProtocolExtend;
    }

    public DrResource getDrResourceBySn(String devSN) {
        List drHosts = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrHost where deviceSn=?", new Object[]{devSN});
        if (null != drHosts && !drHosts.isEmpty()) {
            return (DrResource)drHosts.get(0);
        }
        return null;
    }

    public List<DrResource> getDrResourceBySite(Integer siteType) {
        List drHosts = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrHost where siteId in (select siteId from Site where siteType = ?)", new Object[]{siteType});
        ArrayList<DrResource> result = new ArrayList<DrResource>();
        if (null != drHosts) {
            result.addAll(drHosts);
        }
        return result;
    }

    public List<DrResource> getDrResourceBySite(String siteId) {
        ArrayList<DrResource> result = new ArrayList<DrResource>();
        List resources = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrHost where siteId=?", new Object[]{siteId});
        if (null == resources) {
            return result;
        }
        for (DrHost dr : resources) {
            result.add((DrResource)dr);
        }
        return result;
    }
}

