/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.service.impl;

import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.host.recovery.process.MappingSnapshotSubProcessor;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.process.IProcessorInfoService;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SnapshotCopyServiceImpl
implements IProcessorInfoService {
    private static final Log logger = LogFactory.getInstance(SnapshotCopyServiceImpl.class);

    public int getProcessorType() {
        return DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue();
    }

    public Map<String, String> querySnapshotCopyInfos(RecoveryProcessorContext context, int procType) {
        HashMap<String, String> snapshotMap = new HashMap<String, String>();
        List<RecoveryProcessor> allMappingSnapshotProcessor = this.queryMappingSnapshotsProcessor(context, procType);
        for (RecoveryProcessor mappingSnapshotProcessor : allMappingSnapshotProcessor) {
            MappingSnapshotSubProcessor mstp = (MappingSnapshotSubProcessor)mappingSnapshotProcessor;
            snapshotMap.put(mstp.getLunId(), mstp.getSnapshotId() + "-" + mstp.getSnapshotWWN());
        }
        return snapshotMap;
    }

    protected List<RecoveryProcessor> queryMappingSnapshotsProcessor(RecoveryProcessorContext context, int procType) {
        DrmEnumDefine.RecoveryPlanExecuteTypeE lastRunType = DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING;
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue() == procType) {
            lastRunType = DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING;
        }
        return this.getRecoveryProcessors(context.getRecoveryPlan(), lastRunType, MappingSnapshotSubProcessor.class);
    }

    protected List<RecoveryProcessor> getRecoveryProcessors(RecoveryPlan recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE execType, Class<? extends RecoveryProcessor> cls) {
        if (null == recoveryPlan || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            logger.error((Object)"recoveryPlan is null or getProtectGroups is empty", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<QueryCondition> conditions = new ArrayList<QueryCondition>();
        conditions.add(new QueryCondition("procType", (Object)execType.getValue()));
        Iterator iterator = recoveryPlan.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        int templateType = ((ProtectGroup)iterator.next()).getTemplate().getType();
        conditions.add(new QueryCondition("protectionType", (Object)templateType));
        IRecoveryProcessService rProcessService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        List recoveryProcessors = rProcessService.getRecoveryProcessors(recoveryPlan.getPlanId(), conditions, cls);
        return recoveryProcessors;
    }
}

