/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.template;

import com.huawei.ism.drm.base.util.xml.XmlParser;
import com.huawei.ism.drm.common.sdk.model.ScriptSchemeDefTemplate;
import com.huawei.ism.drm.common.sdk.model.ScriptSchemeStep;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class ScriptSchemeTemplateParser {
    private final XmlParser xmlParser = new XmlParser();
    private final List<Document> templateDocuments = new ArrayList<Document>();

    public void readTemplateFile(URL processFileUrl) {
        Document document = this.xmlParser.init(processFileUrl);
        if (null != document) {
            this.templateDocuments.add(document);
        }
    }

    public List<ScriptSchemeDefTemplate> parseTemplateFile() {
        ArrayList<ScriptSchemeDefTemplate> templateList = new ArrayList<ScriptSchemeDefTemplate>();
        for (Document document : this.templateDocuments) {
            Element rootElement = this.xmlParser.getRootElement(document);
            if (null == rootElement) {
                throw new LegoCheckedException(-1L);
            }
            List processNodes = this.xmlParser.getNodes(rootElement, "/Config/scheme");
            for (Node processNode : processNodes) {
                Element processElement = (Element)processNode;
                ScriptSchemeDefTemplate scriptSchemeDefTemplate = this.parseScriptSchemeTemplate(processElement);
                templateList.add(scriptSchemeDefTemplate);
            }
        }
        return templateList;
    }

    private ScriptSchemeDefTemplate parseScriptSchemeTemplate(Element scriptElement) {
        List publicParamsNodes;
        ScriptSchemeDefTemplate scriptSchemeDefTemplate = new ScriptSchemeDefTemplate();
        String id = this.xmlParser.getAttribute(scriptElement, "id");
        scriptSchemeDefTemplate.setId(id);
        String freezeTimeout = this.xmlParser.getAttribute(scriptElement, "freeze-timeout");
        scriptSchemeDefTemplate.setFreezeTimeout(VerifyUtil.isEmpty((String)freezeTimeout) ? "30" : freezeTimeout);
        ArrayList<ScriptSchemeStep> steps = new ArrayList<ScriptSchemeStep>();
        List compatibilityNodes = this.xmlParser.getNodes(scriptElement, "compatibility");
        if (!VerifyUtil.isEmpty((Collection)compatibilityNodes)) {
            Element compatibilityElement = (Element)compatibilityNodes.get(0);
            this.parseCompatibilityInfo(compatibilityElement, scriptSchemeDefTemplate);
        }
        if (!VerifyUtil.isEmpty((Collection)(publicParamsNodes = this.xmlParser.getNodes(scriptElement, "publicParams")))) {
            scriptSchemeDefTemplate.setPublicParams(this.parseParam(publicParamsNodes));
        }
        List stepNodes = this.xmlParser.getNodes(scriptElement, "step");
        for (Node stepNode : stepNodes) {
            ScriptSchemeStep step = new ScriptSchemeStep();
            Element stepElement = (Element)stepNode;
            this.parseStepInfo(stepElement, step);
            steps.add(step);
        }
        scriptSchemeDefTemplate.setSteps(steps);
        return scriptSchemeDefTemplate;
    }

    private void parseCompatibilityInfo(Element compatibilityElement, ScriptSchemeDefTemplate scriptSchemeDefTemplate) {
        List appNodes;
        List osNodes = this.xmlParser.getNodes(compatibilityElement, "os");
        if (!VerifyUtil.isEmpty((Collection)osNodes)) {
            this.parseOsInfo(osNodes, scriptSchemeDefTemplate);
        }
        if (!VerifyUtil.isEmpty((Collection)(appNodes = this.xmlParser.getNodes(compatibilityElement, "app")))) {
            this.parseAppInfo(appNodes, scriptSchemeDefTemplate);
        }
    }

    private void parseAppInfo(List<Node> appNodes, ScriptSchemeDefTemplate scriptSchemeDefTemplate) {
        List tagNodes;
        List versionNodes;
        String type = "";
        String version = "";
        ArrayList<Map<String, String>> tags = new ArrayList<Map<String, String>>();
        Element appElement = (Element)appNodes.get(0);
        List typeNodes = this.xmlParser.getNodes(appElement, "type");
        if (!VerifyUtil.isEmpty((Collection)typeNodes)) {
            type = ((Node)typeNodes.get(0)).getText().trim();
        }
        if (!VerifyUtil.isEmpty((Collection)(versionNodes = this.xmlParser.getNodes(appElement, "version")))) {
            version = ((Node)versionNodes.get(0)).getText().trim();
        }
        if (!VerifyUtil.isEmpty((Collection)(tagNodes = this.xmlParser.getNodes(appElement, "tag")))) {
            this.parseTagInfo(tagNodes, tags);
        }
        Map app = scriptSchemeDefTemplate.getApp();
        app.put("type", type);
        app.put("version", version);
        app.put("tag", tags);
    }

    private void parseTagInfo(List<Node> tagNodes, List<Map<String, String>> tags) {
        for (Node node : tagNodes) {
            Element tagElement = (Element)node;
            String en = this.xmlParser.getAttribute(tagElement, "id");
            List zhNodes = this.xmlParser.getNodes(tagElement, "zh");
            List enNodes = this.xmlParser.getNodes(tagElement, "en");
            if (!VerifyUtil.isEmpty((Collection)enNodes) && !VerifyUtil.isEmpty((String)((Node)enNodes.get(0)).getText())) {
                en = ((Node)enNodes.get(0)).getText().trim();
            }
            String zh = ((Node)zhNodes.get(0)).getText().trim();
            HashMap<String, String> tag = new HashMap<String, String>();
            tag.put("en", en);
            tag.put("zh", zh);
            tags.add(tag);
        }
    }

    private void parseOsInfo(List<Node> osNodes, ScriptSchemeDefTemplate scriptSchemeDefTemplate) {
        List versionNodes;
        String platform = "";
        String version = "";
        Element osElement = (Element)osNodes.get(0);
        List platformNodes = this.xmlParser.getNodes(osElement, "platform");
        if (!VerifyUtil.isEmpty((Collection)platformNodes)) {
            platform = ((Node)platformNodes.get(0)).getText().trim();
        }
        if (!VerifyUtil.isEmpty((Collection)(versionNodes = this.xmlParser.getNodes(osElement, "version")))) {
            version = ((Node)versionNodes.get(0)).getText().trim();
        }
        Map os = scriptSchemeDefTemplate.getOs();
        os.put("platform", platform);
        os.put("version", version);
    }

    private void parseStepInfo(Element stepElement, ScriptSchemeStep step) {
        String script = this.xmlParser.getAttribute(stepElement, "script");
        String position = this.xmlParser.getAttribute(stepElement, "position");
        List nameNodes = this.xmlParser.getNodes(stepElement, "name");
        if (!VerifyUtil.isEmpty((Collection)nameNodes)) {
            List<String> i18nNameList = this.parseI18n((Node)nameNodes.get(0));
            step.getName().put("i18nKey", i18nNameList.get(2));
            HashMap<String, String> i18n = new HashMap<String, String>();
            i18n.put("zh", i18nNameList.get(0));
            i18n.put("en", i18nNameList.get(1));
            step.getName().put("i18n", i18n);
        }
        step.setScript(script);
        step.setPosition(position);
        step.setPolicy(this.getStringValue(stepElement, "policy", ""));
        List scriptParamsNodes = this.xmlParser.getNodes(stepElement, "scriptParams");
        if (!VerifyUtil.isEmpty((Collection)scriptParamsNodes)) {
            step.setParams(this.parseParam(scriptParamsNodes));
        }
    }

    private List<Map<String, Object>> parseParam(List<Node> scriptParamsNodes) {
        Element scriptParamsElement = (Element)scriptParamsNodes.get(0);
        List paramNodes = this.xmlParser.getNodes(scriptParamsElement, "param");
        ArrayList<Map<String, Object>> param = new ArrayList<Map<String, Object>>();
        for (Node paramNode : paramNodes) {
            HashMap<String, Object> paramInfo = new HashMap<String, Object>();
            Element paramElement = (Element)paramNode;
            String name = this.xmlParser.getAttribute(paramElement, "name");
            paramInfo.put("name", name);
            paramInfo.put("sensitive", this.getStringValue(paramElement, "sensitive", "false"));
            paramInfo.put("optional", this.getStringValue(paramElement, "optional", "false"));
            List<String> descriptionList = this.parseDescription(paramNode);
            HashMap<String, String> description = new HashMap<String, String>();
            description.put("zh", descriptionList.get(0));
            description.put("en", descriptionList.get(1));
            paramInfo.put("description", description);
            Map<String, Object> parseValidate = this.parseValidate(paramNode);
            paramInfo.putAll(parseValidate);
            param.add(paramInfo);
        }
        return param;
    }

    private List<String> parseDescription(Node node) {
        String zh = "";
        String en = "";
        ArrayList<String> descriptionList = new ArrayList<String>();
        Element element = (Element)node;
        List descriptionNodes = this.xmlParser.getNodes(element, "description");
        if (!VerifyUtil.isEmpty((Collection)descriptionNodes)) {
            List enNodes;
            Element descriptionElement = (Element)descriptionNodes.get(0);
            List zhNodes = this.xmlParser.getNodes(descriptionElement, "zh");
            if (!VerifyUtil.isEmpty((Collection)zhNodes)) {
                zh = ((Node)zhNodes.get(0)).getText().trim();
            }
            if (!VerifyUtil.isEmpty((Collection)(enNodes = this.xmlParser.getNodes(descriptionElement, "en")))) {
                en = ((Node)enNodes.get(0)).getText().trim();
            }
        }
        descriptionList.add(zh);
        descriptionList.add(en);
        return descriptionList;
    }

    private Map<String, Object> parseValidate(Node node) {
        String zh = "";
        String en = "";
        HashMap<String, Object> validateInfo = new HashMap<String, Object>();
        Element element = (Element)node;
        List validateNodes = this.xmlParser.getNodes(element, "validation");
        if (!VerifyUtil.isEmpty((Collection)validateNodes)) {
            List enNodes;
            Element validateElement = (Element)validateNodes.get(0);
            validateInfo.put("expr", this.getStringValue(validateElement, "expr", ""));
            validateInfo.put("length", this.getStringValue(validateElement, "length", "512"));
            List zhNodes = this.xmlParser.getNodes(validateElement, "zh");
            if (!VerifyUtil.isEmpty((Collection)zhNodes)) {
                zh = ((Node)zhNodes.get(0)).getText().trim();
            }
            if (!VerifyUtil.isEmpty((Collection)(enNodes = this.xmlParser.getNodes(validateElement, "en")))) {
                en = ((Node)enNodes.get(0)).getText().trim();
            }
        }
        HashMap<String, String> validate = new HashMap<String, String>();
        validate.put("en", en);
        validate.put("zh", zh);
        validateInfo.put("validate", validate);
        return validateInfo;
    }

    private List<String> parseI18n(Node node) {
        String zh = "";
        String en = "";
        String i18nKey = "";
        ArrayList<String> i18nList = new ArrayList<String>();
        Element element = (Element)node;
        List i18nNodes = this.xmlParser.getNodes(element, "i18n");
        if (!VerifyUtil.isEmpty((Collection)i18nNodes)) {
            List enNodes;
            i18nKey = ((Node)i18nNodes.get(0)).getText().trim();
            i18nKey = VerifyUtil.isEmpty((String)i18nKey) ? "" : i18nKey;
            Element i18nElement = (Element)i18nNodes.get(0);
            List zhNodes = this.xmlParser.getNodes(i18nElement, "zh");
            if (!VerifyUtil.isEmpty((Collection)zhNodes)) {
                zh = ((Node)zhNodes.get(0)).getText().trim();
            }
            if (!VerifyUtil.isEmpty((Collection)(enNodes = this.xmlParser.getNodes(i18nElement, "en")))) {
                en = ((Node)enNodes.get(0)).getText().trim();
            }
        }
        i18nList.add(zh);
        i18nList.add(en);
        i18nList.add(i18nKey);
        return i18nList;
    }

    private String getStringValue(Element processorElement, String attributeName, String defaultValue) {
        String value = this.xmlParser.getAttribute(processorElement, attributeName);
        if (VerifyUtil.isEmpty((String)value)) {
            return defaultValue;
        }
        return value;
    }
}

