/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.topology;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.host.topology.element.AsmDiskElement;
import com.huawei.ism.drm.host.topology.element.DeviceElement;
import com.huawei.ism.drm.host.topology.element.DiskElement;
import com.huawei.ism.drm.host.topology.element.DiskGroupElement;
import com.huawei.ism.drm.host.topology.element.HangPointElement;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.topo.builder.AbstractTopoBuilder;
import com.huawei.ism.drm.topo.element.NamedElement;
import com.huawei.ism.drm.topo.sdk.context.TopoBaseContext;
import com.huawei.ism.drm.topo.sdk.topology.Skin;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.topology.IData;
import com.huawei.topology.Node;
import java.util.List;
import java.util.Locale;

public abstract class AbstractHostTopoBuilder
extends AbstractTopoBuilder {
    private static Log logger = LogFactory.getInstance(AbstractHostTopoBuilder.class);

    protected void createDiskTopo(TopoBaseContext context, String hostSN, Node fatherNode, ProtectObjectStorageInfo hostStorageInfo) {
        Node diskStyleNode = TopoServiceUtil.createDiskStyleNode((TopoBaseContext)context, (String)hostSN);
        context.addChild((IData)fatherNode, (IData)diskStyleNode);
        String diskID = hostSN + "Disk" + hostStorageInfo.getResourceId();
        DiskElement diskNode = new DiskElement(diskID);
        context.addChild((IData)diskStyleNode, (IData)diskNode);
        String lunNodeID = hostStorageInfo.getResourceProviderSN() + hostStorageInfo.getResourceId();
        context.linkTo((Node)diskNode, (Object)lunNodeID, new Skin[0]);
    }

    protected void createDiskTopo(TopoBaseContext context, String hostSN, Node fatherNode, ProtectObjectStorageInfo hostStorageInfo, List<String> siteIds) {
        Node diskStyleNode = TopoServiceUtil.createDiskStyleNode((TopoBaseContext)context, (String)hostSN);
        context.addChild((IData)fatherNode, (IData)diskStyleNode);
        String diskID = hostSN + "Disk" + hostStorageInfo.getResourceId();
        DiskElement diskNode = new DiskElement(diskID);
        context.addChild((IData)diskStyleNode, (IData)diskNode);
        if (VerifyUtil.isEmpty(siteIds)) {
            String lunNodeID = hostStorageInfo.getResourceProviderSN() + hostStorageInfo.getResourceId();
            this.linkDiskNodeToLun(context, (Node)diskNode, lunNodeID, null);
        } else {
            String lunNodeID = hostStorageInfo.getLunWWN();
            for (String siteId : siteIds) {
                this.linkDiskNodeToLun(context, (Node)diskNode, lunNodeID, siteId);
                this.linkeNodeToLunByWwn(context, (Node)diskNode, lunNodeID);
            }
        }
    }

    protected void linkDiskNodeToLun(TopoBaseContext context, Node diskNode, String target, String prefix) {
        if (prefix == null) {
            context.linkTo(diskNode, (Object)target, new Skin[0]);
        } else {
            context.linkTo(diskNode, (Object)(prefix + target), new Skin[0]);
            context.linkTo(diskNode, (Object)(prefix + target.toUpperCase(Locale.getDefault())), new Skin[0]);
        }
    }

    protected void createDeviceTopo(TopoBaseContext context, String hostSN, Node fatherNode, Node deviceNode, ProtectObjectStorageInfo hostStorageInfo) {
        Node deviceStyleNode = TopoServiceUtil.createDeviceStyleNode((TopoBaseContext)context, (String)hostSN);
        context.addChild((IData)fatherNode, (IData)deviceStyleNode);
        context.addChild((IData)deviceStyleNode, (IData)deviceNode);
        context.linkTo(deviceNode, (Object)(hostSN + "Disk" + hostStorageInfo.getResourceId()), new Skin[0]);
    }

    protected void buildAsmTopo(TopoBaseContext context, String hostSN, Node fatherNode, ProtectObjectStorageInfo hostStorageInfo, Object hostId) {
        Node asmStyleNode = TopoServiceUtil.createDiskGroupStyleNode((TopoBaseContext)context, (String)hostSN);
        context.addChild((IData)fatherNode, (IData)asmStyleNode);
        String id = hostSN + ":diskGroup:" + hostStorageInfo.getAsmDiskGroupName();
        Object asmNode = (Node)context.getElementBox().getElementByID((Object)id);
        if (asmNode == null) {
            asmNode = new DiskGroupElement(id, hostStorageInfo.getAsmDiskGroupName());
            asmNode = (Node)context.addChild((IData)asmStyleNode, (IData)asmNode);
        }
        context.linkTo(asmNode, hostId, new Skin[0]);
    }

    protected String buildHostStorageTopo(TopoBaseContext context, String hostSN, Node fatherNode, ProtectObjectStorageInfo hostStorageInfo, List<String> siteIds) {
        int storageType = hostStorageInfo.getStorageType();
        String id = hostSN + hostStorageInfo.getDeviceName();
        if (TopoServiceUtil.checkIsASM((int)storageType)) {
            NamedElement node = storageType == DrmEnumDefine.StorageTypeE.ASM_WINDOWS.getValue() ? new AsmDiskElement(id, hostStorageInfo.getMountPoint()) : new DeviceElement(id, hostStorageInfo.getDeviceName());
            this.buildAsmTopo(context, hostSN, fatherNode, hostStorageInfo, id);
            this.createDeviceTopo(context, hostSN, fatherNode, (Node)node, hostStorageInfo);
            this.createDiskTopo(context, hostSN, fatherNode, hostStorageInfo, siteIds);
            id = hostSN + ":diskGroup:" + hostStorageInfo.getAsmDiskGroupName();
        } else if (storageType == DrmEnumDefine.StorageTypeE.PRIMAL.getValue()) {
            Object node = (Node)context.getElementBox().getElementByID((Object)id);
            if (node == null) {
                node = new DeviceElement(id, hostStorageInfo.getDeviceName());
            }
            this.createDeviceTopo(context, hostSN, fatherNode, (Node)node, hostStorageInfo);
            this.createDiskTopo(context, hostSN, fatherNode, hostStorageInfo, siteIds);
        } else {
            Object node = (Node)context.getElementBox().getElementByID((Object)id);
            if (node == null) {
                node = new HangPointElement(id, hostStorageInfo.getMountPoint());
            }
            this.createDeviceTopo(context, hostSN, fatherNode, (Node)node, hostStorageInfo);
            this.createDiskTopo(context, hostSN, fatherNode, hostStorageInfo, siteIds);
        }
        return id;
    }
}

